/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceListSelectionDialog
extends SelectionDialog {
    Text pattern;
    Table resourceNames;
    Table folderNames;
    String patternString;
    IContainer container;
    int typeMask;
    static Collator collator = Collator.getInstance();
    boolean gatherResourcesDynamically = true;
    StringMatcher stringMatcher;
    UpdateFilterThread updateFilterThread;
    UpdateGatherThread updateGatherThread;
    ResourceDescriptor[] descriptors;
    int descriptorsSize;
    WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();

    public ResourceListSelectionDialog(Shell parentShell, IResource[] resources) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.gatherResourcesDynamically = false;
        this.initDescriptors(resources);
    }

    public ResourceListSelectionDialog(Shell parentShell, IContainer container, int typeMask) {
        super(parentShell);
        this.container = container;
        this.typeMask = typeMask;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected String adjustPattern() {
        String text = this.pattern.getText().trim();
        if (!text.equals("") && text.indexOf(42) == -1 && text.indexOf(63) == -1 && text.indexOf(60) == -1) {
            text = String.valueOf(text) + "*";
            return text;
        }
        if (text.endsWith("<")) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    public boolean close() {
        boolean result = super.close();
        this.labelProvider.dispose();
        return result;
    }

    public void create() {
        super.create();
        this.pattern.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label l = new Label(dialogArea, 0);
        l.setText(WorkbenchMessages.getString("ResourceSelectionDialog.label"));
        GridData data = new GridData(768);
        l.setLayoutData((Object)data);
        l = new Label(dialogArea, 0);
        l.setText(WorkbenchMessages.getString("ResourceSelectionDialog.pattern"));
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.pattern = new Text(dialogArea, 2052);
        this.pattern.setLayoutData((Object)new GridData(768));
        l = new Label(dialogArea, 0);
        l.setText(WorkbenchMessages.getString("ResourceSelectionDialog.matching"));
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.resourceNames = new Table(dialogArea, 2564);
        data = new GridData(1808);
        data.heightHint = 12 * this.resourceNames.getItemHeight();
        this.resourceNames.setLayoutData((Object)data);
        l = new Label(dialogArea, 0);
        l.setText(WorkbenchMessages.getString("ResourceSelectionDialog.folders"));
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.folderNames = new Table(dialogArea, 2820);
        data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 4 * this.folderNames.getItemHeight();
        this.folderNames.setLayoutData((Object)data);
        if (this.gatherResourcesDynamically) {
            this.updateGatherThread = new UpdateGatherThread();
        } else {
            this.updateFilterThread = new UpdateFilterThread();
        }
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ResourceListSelectionDialog.this.resourceNames.setFocus();
                } else {
                    ResourceListSelectionDialog.this.textChanged();
                }
            }
        });
        this.resourceNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceListSelectionDialog.this.updateFolders((ResourceDescriptor)e.item.getData());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourceListSelectionDialog.this.okPressed();
            }
        });
        this.folderNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ResourceListSelectionDialog.this.okPressed();
            }
        });
        Dialog.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    private void filterResources() {
        int matchLength;
        String oldPattern = this.patternString;
        this.patternString = this.adjustPattern();
        if (this.patternString.equals(oldPattern)) {
            return;
        }
        this.updateFilterThread.stop = true;
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        UpdateFilterThread oldThread = this.updateFilterThread;
        this.updateFilterThread = new UpdateFilterThread();
        if (this.patternString.equals("")) {
            this.updateFilterThread.firstMatch = 0;
            this.updateFilterThread.lastMatch = -1;
            this.updateFilterThread.start();
            return;
        }
        if (oldPattern != null && oldPattern.length() != 0 && oldPattern.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, oldPattern, 0, matchLength = oldPattern.length() - 1)) {
            this.updateFilterThread.firstMatch = oldThread.firstMatch;
            this.updateFilterThread.lastMatch = oldThread.lastMatch;
            this.updateFilterThread.start();
            return;
        }
        this.updateFilterThread.firstMatch = 0;
        this.updateFilterThread.lastMatch = this.descriptorsSize - 1;
        this.updateFilterThread.start();
    }

    private int getFirstMatch() {
        int high = this.descriptorsSize;
        int low = -1;
        boolean match = false;
        ResourceDescriptor desc = new ResourceDescriptor();
        desc.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (high - low > 1) {
            int index = (high + low) / 2;
            String label = this.descriptors[index].label;
            if (this.match(label)) {
                high = index;
                match = true;
                continue;
            }
            int compare = this.descriptors[index].compareTo(desc);
            if (compare == -1) {
                low = index;
                continue;
            }
            high = index;
        }
        if (match) {
            return high;
        }
        return -1;
    }

    private void gatherResources() {
        int matchLength;
        String oldPattern = this.patternString;
        this.patternString = this.adjustPattern();
        if (this.patternString.equals(oldPattern)) {
            return;
        }
        this.updateGatherThread.stop = true;
        this.updateGatherThread = new UpdateGatherThread();
        if (this.patternString.equals("")) {
            this.updateGatherThread.start();
            return;
        }
        this.stringMatcher = new StringMatcher(this.patternString, true, false);
        if (oldPattern != null && oldPattern.length() != 0 && oldPattern.endsWith("*") && this.patternString.endsWith("*") && this.patternString.regionMatches(0, oldPattern, 0, matchLength = oldPattern.length() - 1)) {
            this.updateGatherThread.refilter = true;
            this.updateGatherThread.firstMatch = 0;
            this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
            this.updateGatherThread.start();
            return;
        }
        final ArrayList resources = new ArrayList();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResourceListSelectionDialog.this.getMatchingResources(resources);
                IResource[] resourcesArray = new IResource[resources.size()];
                resources.toArray(resourcesArray);
                ResourceListSelectionDialog.this.initDescriptors(resourcesArray);
            }
        });
        this.updateGatherThread.firstMatch = 0;
        this.updateGatherThread.lastMatch = this.descriptorsSize - 1;
        this.updateGatherThread.start();
    }

    private Image getImage(ResourceDescriptor desc) {
        IResource r = (IResource)desc.resources.get(0);
        return this.labelProvider.getImage(r);
    }

    private int getLastMatch() {
        int high = this.descriptorsSize;
        int low = -1;
        boolean match = false;
        ResourceDescriptor desc = new ResourceDescriptor();
        desc.label = this.patternString.substring(0, this.patternString.length() - 1);
        while (high - low > 1) {
            int index = (high + low) / 2;
            String label = this.descriptors[index].label;
            if (this.match(label)) {
                low = index;
                match = true;
                continue;
            }
            int compare = this.descriptors[index].compareTo(desc);
            if (compare == -1) {
                low = index;
                continue;
            }
            high = index;
        }
        if (match) {
            return low;
        }
        return -1;
    }

    private void getMatchingResources(final ArrayList resources) {
        try {
            this.container.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) {
                    int type = proxy.getType();
                    if ((ResourceListSelectionDialog.this.typeMask & type) != 0 && ResourceListSelectionDialog.this.match(proxy.getName())) {
                        IResource res = proxy.requestResource();
                        if (ResourceListSelectionDialog.this.select(res)) {
                            resources.add(res);
                            return true;
                        }
                        return false;
                    }
                    return type != 1;
                }
            }, 0);
        }
        catch (CoreException coreException) {}
    }

    private Image getParentImage(IResource resource) {
        IContainer parent = resource.getParent();
        return this.labelProvider.getImage(parent);
    }

    private String getParentLabel(IResource resource) {
        IContainer parent = resource.getParent();
        String text = parent.getType() == 8 ? this.labelProvider.getText(parent) : parent.getFullPath().makeRelative().toString();
        return text;
    }

    private void initDescriptors(final IResource[] resources) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ResourceListSelectionDialog.this.descriptors = new ResourceDescriptor[resources.length];
                int i = 0;
                while (i < resources.length) {
                    IResource r = resources[i];
                    ResourceDescriptor d = new ResourceDescriptor();
                    d.label = r.getName();
                    d.resources.add(r);
                    ResourceListSelectionDialog.this.descriptors[i] = d;
                    ++i;
                }
                Arrays.sort(ResourceListSelectionDialog.this.descriptors);
                ResourceListSelectionDialog.this.descriptorsSize = ResourceListSelectionDialog.this.descriptors.length;
                int index = 0;
                if (ResourceListSelectionDialog.this.descriptorsSize < 2) {
                    return;
                }
                ResourceDescriptor current = ResourceListSelectionDialog.this.descriptors[index];
                IResource currentResource = (IResource)current.resources.get(0);
                int i2 = 1;
                while (i2 < ResourceListSelectionDialog.this.descriptorsSize) {
                    ResourceDescriptor next = ResourceListSelectionDialog.this.descriptors[i2];
                    IResource nextResource = (IResource)next.resources.get(0);
                    if (nextResource.getType() == currentResource.getType() && next.label.equals(current.label)) {
                        current.resources.add(nextResource);
                    } else {
                        if (current.resources.size() > 1) {
                            current.resourcesSorted = false;
                        }
                        ResourceListSelectionDialog.this.descriptors[index + 1] = ResourceListSelectionDialog.this.descriptors[i2];
                        current = ResourceListSelectionDialog.this.descriptors[++index];
                        currentResource = (IResource)current.resources.get(0);
                    }
                    ++i2;
                }
                ResourceListSelectionDialog.this.descriptorsSize = index + 1;
            }
        });
    }

    private boolean match(String label) {
        if (this.patternString == null || this.patternString.equals("") || this.patternString.equals("*")) {
            return true;
        }
        return this.stringMatcher.match(label);
    }

    protected void okPressed() {
        TableItem[] items = this.folderNames.getSelection();
        if (items.length == 1) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(items[0].getData());
            this.setResult(result);
        }
        super.okPressed();
    }

    protected boolean select(IResource resource) {
        return true;
    }

    private void textChanged() {
        if (this.gatherResourcesDynamically) {
            this.gatherResources();
        } else {
            this.filterResources();
        }
    }

    private void updateFolders(final ResourceDescriptor desc) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (!desc.resourcesSorted) {
                    Collections.sort(desc.resources, new Comparator(this){
                        private final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            String s1 = ResourceListSelectionDialog.access$8(15.access$0(this.this$1), (IResource)o1);
                            String s2 = ResourceListSelectionDialog.access$8(15.access$0(this.this$1), (IResource)o2);
                            return collator.compare(s1, s2);
                        }
                    });
                    desc.resourcesSorted = true;
                }
                ResourceListSelectionDialog.this.folderNames.removeAll();
                int i = 0;
                while (i < desc.resources.size()) {
                    TableItem newItem = new TableItem(ResourceListSelectionDialog.this.folderNames, 0);
                    IResource r = (IResource)desc.resources.get(i);
                    newItem.setText(ResourceListSelectionDialog.this.getParentLabel(r));
                    newItem.setImage(ResourceListSelectionDialog.this.getParentImage(r));
                    newItem.setData((Object)r);
                    ++i;
                }
                ResourceListSelectionDialog.this.folderNames.setSelection(0);
            }

            static /* synthetic */ ResourceListSelectionDialog access$0(15 var0) {
                return var0.ResourceListSelectionDialog.this;
            }
        });
    }

    private void updateItem(int index, int itemPos, int itemCount) {
        ResourceDescriptor desc = this.descriptors[index];
        if (itemPos < itemCount) {
            TableItem item = this.resourceNames.getItem(itemPos);
            if (item.getData() != desc) {
                item.setText(desc.label);
                item.setData((Object)desc);
                item.setImage(this.getImage(desc));
                if (itemPos == 0) {
                    this.resourceNames.setSelection(0);
                    this.updateFolders(desc);
                }
            }
        } else {
            TableItem item = new TableItem(this.resourceNames, 0);
            item.setText(desc.label);
            item.setData((Object)desc);
            item.setImage(this.getImage(desc));
            if (itemPos == 0) {
                this.resourceNames.setSelection(0);
                this.updateFolders(desc);
            }
        }
    }

    static /* synthetic */ void access$2(ResourceListSelectionDialog resourceListSelectionDialog, int n, int n2, int n3) {
        resourceListSelectionDialog.updateItem(n, n2, n3);
    }

    static class ResourceDescriptor
    implements Comparable {
        String label;
        ArrayList resources = new ArrayList();
        boolean resourcesSorted = true;

        ResourceDescriptor() {
        }

        public int compareTo(Object o) {
            return collator.compare(this.label, ((ResourceDescriptor)o).label);
        }
    }

    class UpdateFilterThread
    extends Thread {
        boolean stop = false;
        int firstMatch = 0;
        int lastMatch;

        UpdateFilterThread() {
            this.lastMatch = ResourceListSelectionDialog.this.descriptorsSize - 1;
        }

        public void run() {
            int last;
            Display display = ResourceListSelectionDialog.this.resourceNames.getDisplay();
            int[] itemIndex = new int[1];
            int[] itemCount = new int[1];
            boolean[] disposed = new boolean[1];
            display.syncExec(new Runnable(this, disposed, itemCount){
                private final /* synthetic */ UpdateFilterThread this$1;
                private final /* synthetic */ boolean[] val$disposed;
                private final /* synthetic */ int[] val$itemCount;
                {
                    this.this$1 = updateFilterThread;
                    this.val$disposed = blArray;
                    this.val$itemCount = nArray;
                }

                public void run() {
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                        this.val$disposed[0] = true;
                        return;
                    }
                    this.val$itemCount[0] = UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount();
                }
            });
            if (disposed[0]) {
                return;
            }
            if (ResourceListSelectionDialog.this.patternString.indexOf(63) == -1 && ResourceListSelectionDialog.this.patternString.endsWith("*") && ResourceListSelectionDialog.this.patternString.indexOf(42) == ResourceListSelectionDialog.this.patternString.length() - 1) {
                this.firstMatch = ResourceListSelectionDialog.this.getFirstMatch();
                if (this.firstMatch == -1) {
                    this.firstMatch = 0;
                    this.lastMatch = -1;
                } else {
                    this.lastMatch = ResourceListSelectionDialog.this.getLastMatch();
                }
                last = this.lastMatch;
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i++;
                    display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                        private final /* synthetic */ UpdateFilterThread this$1;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ int[] val$itemIndex;
                        private final /* synthetic */ int[] val$itemCount;
                        {
                            this.this$1 = updateFilterThread;
                            this.val$index = n;
                            this.val$itemIndex = nArray;
                            this.val$itemCount = nArray2;
                        }

                        public void run() {
                            if (this.this$1.stop || UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                                return;
                            }
                            ResourceListSelectionDialog.access$2(UpdateFilterThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                            this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                        }
                    });
                }
            } else {
                last = this.lastMatch;
                boolean setFirstMatch = true;
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i;
                    if (ResourceListSelectionDialog.this.match(ResourceListSelectionDialog.this.descriptors[index].label)) {
                        if (setFirstMatch) {
                            setFirstMatch = false;
                            this.firstMatch = index;
                        }
                        last = index;
                        display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                            private final /* synthetic */ UpdateFilterThread this$1;
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ int[] val$itemIndex;
                            private final /* synthetic */ int[] val$itemCount;
                            {
                                this.this$1 = updateFilterThread;
                                this.val$index = n;
                                this.val$itemIndex = nArray;
                                this.val$itemCount = nArray2;
                            }

                            public void run() {
                                if (this.this$1.stop || UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                                    return;
                                }
                                ResourceListSelectionDialog.access$2(UpdateFilterThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                                this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                            }
                        });
                    }
                    ++i;
                }
            }
            if (disposed[0]) {
                return;
            }
            this.lastMatch = last;
            display.syncExec(new Runnable(this, itemCount, itemIndex){
                private final /* synthetic */ UpdateFilterThread this$1;
                private final /* synthetic */ int[] val$itemCount;
                private final /* synthetic */ int[] val$itemIndex;
                {
                    this.this$1 = updateFilterThread;
                    this.val$itemCount = nArray;
                    this.val$itemIndex = nArray2;
                }

                public void run() {
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.isDisposed()) {
                        return;
                    }
                    this.val$itemCount[0] = UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount();
                    if (this.val$itemIndex[0] < this.val$itemCount[0]) {
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.setRedraw(false);
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.remove(this.val$itemIndex[0], this.val$itemCount[0] - 1);
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.setRedraw(true);
                    }
                    if (UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).resourceNames.getItemCount() == 0) {
                        UpdateFilterThread.access$0((UpdateFilterThread)this.this$1).folderNames.removeAll();
                    }
                }
            });
        }

        static /* synthetic */ ResourceListSelectionDialog access$0(UpdateFilterThread updateFilterThread) {
            return updateFilterThread.ResourceListSelectionDialog.this;
        }
    }

    class UpdateGatherThread
    extends Thread {
        boolean stop = false;
        int lastMatch = -1;
        int firstMatch = 0;
        boolean refilter = false;

        UpdateGatherThread() {
        }

        public void run() {
            Display display = ResourceListSelectionDialog.this.resourceNames.getDisplay();
            int[] itemIndex = new int[1];
            int[] itemCount = new int[1];
            boolean[] disposed = new boolean[1];
            display.syncExec(new Runnable(this, disposed, itemCount){
                private final /* synthetic */ UpdateGatherThread this$1;
                private final /* synthetic */ boolean[] val$disposed;
                private final /* synthetic */ int[] val$itemCount;
                {
                    this.this$1 = updateGatherThread;
                    this.val$disposed = blArray;
                    this.val$itemCount = nArray;
                }

                public void run() {
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                        this.val$disposed[0] = true;
                        return;
                    }
                    this.val$itemCount[0] = UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount();
                }
            });
            if (disposed[0]) {
                return;
            }
            if (!this.refilter) {
                int i = 0;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i++;
                    display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                        private final /* synthetic */ UpdateGatherThread this$1;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ int[] val$itemIndex;
                        private final /* synthetic */ int[] val$itemCount;
                        {
                            this.this$1 = updateGatherThread;
                            this.val$index = n;
                            this.val$itemIndex = nArray;
                            this.val$itemCount = nArray2;
                        }

                        public void run() {
                            if (this.this$1.stop || UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                                return;
                            }
                            ResourceListSelectionDialog.access$2(UpdateGatherThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                            this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                        }
                    });
                }
            } else {
                int i = this.firstMatch;
                while (i <= this.lastMatch) {
                    if (i % 50 == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.stop || ResourceListSelectionDialog.this.resourceNames.isDisposed()) {
                        disposed[0] = true;
                        return;
                    }
                    int index = i;
                    if (ResourceListSelectionDialog.this.match(ResourceListSelectionDialog.this.descriptors[index].label)) {
                        display.syncExec(new Runnable(this, index, itemIndex, itemCount){
                            private final /* synthetic */ UpdateGatherThread this$1;
                            private final /* synthetic */ int val$index;
                            private final /* synthetic */ int[] val$itemIndex;
                            private final /* synthetic */ int[] val$itemCount;
                            {
                                this.this$1 = updateGatherThread;
                                this.val$index = n;
                                this.val$itemIndex = nArray;
                                this.val$itemCount = nArray2;
                            }

                            public void run() {
                                if (this.this$1.stop || UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                                    return;
                                }
                                ResourceListSelectionDialog.access$2(UpdateGatherThread.access$0(this.this$1), this.val$index, this.val$itemIndex[0], this.val$itemCount[0]);
                                this.val$itemIndex[0] = this.val$itemIndex[0] + 1;
                            }
                        });
                    }
                    ++i;
                }
            }
            if (disposed[0]) {
                return;
            }
            display.syncExec(new Runnable(this, itemCount, itemIndex){
                private final /* synthetic */ UpdateGatherThread this$1;
                private final /* synthetic */ int[] val$itemCount;
                private final /* synthetic */ int[] val$itemIndex;
                {
                    this.this$1 = updateGatherThread;
                    this.val$itemCount = nArray;
                    this.val$itemIndex = nArray2;
                }

                public void run() {
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.isDisposed()) {
                        return;
                    }
                    this.val$itemCount[0] = UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount();
                    if (this.val$itemIndex[0] < this.val$itemCount[0]) {
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.setRedraw(false);
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.remove(this.val$itemIndex[0], this.val$itemCount[0] - 1);
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.setRedraw(true);
                    }
                    if (UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).resourceNames.getItemCount() == 0) {
                        UpdateGatherThread.access$0((UpdateGatherThread)this.this$1).folderNames.removeAll();
                    }
                }
            });
        }

        static /* synthetic */ ResourceListSelectionDialog access$0(UpdateGatherThread updateGatherThread) {
            return updateGatherThread.ResourceListSelectionDialog.this;
        }
    }
}

