/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class SelectionListenerAction
extends Action
implements ISelectionChangedListener {
    private static final List EMPTY_LIST = Arrays.asList(new Object[0]);
    private IStructuredSelection selection = new StructuredSelection();
    private boolean selectionDirty = true;
    private List resources;
    private List nonResources;
    static /* synthetic */ Class class$0;

    protected SelectionListenerAction(String text) {
        super(text);
    }

    private final void computeResources() {
        this.resources = null;
        this.nonResources = null;
        Iterator e = this.selection.iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (next instanceof IResource) {
                if (this.resources == null) {
                    this.resources = new ArrayList(this.selection.size());
                }
                this.resources.add(next);
                continue;
            }
            if (next instanceof IAdaptable) {
                Object resource;
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = iAdaptable.getAdapter((Class)clazz)) != null) {
                    if (this.resources == null) {
                        this.resources = new ArrayList(this.selection.size());
                    }
                    this.resources.add(resource);
                    continue;
                }
            }
            if (this.nonResources == null) {
                this.nonResources = new ArrayList(1);
            }
            this.nonResources.add(next);
        }
    }

    protected List getSelectedNonResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.nonResources == null) {
            return EMPTY_LIST;
        }
        return this.nonResources;
    }

    protected List getSelectedResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.resources == null) {
            return EMPTY_LIST;
        }
        return this.resources;
    }

    public IStructuredSelection getStructuredSelection() {
        return this.selection;
    }

    protected boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }

    public final void selectionChanged(IStructuredSelection selection) {
        this.selection = selection;
        this.selectionDirty = true;
        this.resources = null;
        this.nonResources = null;
        this.setEnabled(this.updateSelection(selection));
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else {
            this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected boolean selectionIsOfType(int resourceMask) {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        Iterator e = this.getSelectedResources().iterator();
        while (e.hasNext()) {
            IResource next = (IResource)e.next();
            if (this.resourceIsType(next, resourceMask)) continue;
            return false;
        }
        return true;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return true;
    }
}

