/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyResourceAction;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class MoveResourceAction
extends CopyResourceAction {
    public static final String ID = "org.eclipse.ui.MoveResourceAction";
    protected List destinations;

    public MoveResourceAction(Shell shell) {
        super(shell, WorkbenchMessages.getString("MoveResourceAction.text"));
        this.setToolTipText(WorkbenchMessages.getString("MoveResourceAction.toolTip"));
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.move_resource_action_context");
    }

    protected CopyFilesAndFoldersOperation createOperation() {
        return new MoveFilesAndFoldersOperation(this.getShell());
    }

    protected List getDestinations() {
        return this.destinations;
    }

    protected IResource[] getResources(List resourceList) {
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), WorkbenchMessages.getString("MoveResourceAction.title"), WorkbenchMessages.getString("MoveResourceAction.checkMoveMessage"));
        return checker.checkReadOnlyResources(super.getResources(resourceList));
    }

    protected void runOperation(IResource[] resources, IContainer destination) {
        this.destinations = new ArrayList();
        IResource[] copiedResources = this.operation.copyResources(resources, destination);
        int i = 0;
        while (i < copiedResources.length) {
            this.destinations.add(destination.getFullPath().append(copiedResources[i].getName()));
            ++i;
        }
    }
}

