/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Assert;

public class GlobalBuildAction
extends Action {
    private int buildType;
    private IWorkbench workbench;
    private IWorkbenchWindow window;
    private Shell shell;

    public GlobalBuildAction(IWorkbench workbench, Shell shell, int type) {
        Assert.isNotNull(workbench);
        Assert.isNotNull(shell);
        this.workbench = workbench;
        this.shell = shell;
        this.setBuildType(type);
    }

    public GlobalBuildAction(IWorkbenchWindow window, int type) {
        Assert.isNotNull(window);
        this.workbench = window.getWorkbench();
        this.window = window;
        this.setBuildType(type);
    }

    private void setBuildType(int type) {
        switch (type) {
            case 9: 
            case 10: {
                this.setText(WorkbenchMessages.getString("GlobalBuildAction.text"));
                this.setToolTipText(WorkbenchMessages.getString("GlobalBuildAction.toolTip"));
                this.setId("build");
                WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.global_incremental_build_action_context");
                break;
            }
            case 6: {
                this.setText(WorkbenchMessages.getString("GlobalBuildAction.rebuildText"));
                this.setToolTipText(WorkbenchMessages.getString("GlobalBuildAction.rebuildToolTip"));
                this.setId("rebuildAll");
                WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.global_full_build_action_context");
                break;
            }
            default: {
                Assert.isTrue(false, "Invalid build type");
            }
        }
        this.buildType = type;
    }

    private Shell getShell() {
        if (this.window != null) {
            return this.window.getShell();
        }
        return this.shell;
    }

    private String getOperationMessage() {
        if (this.buildType == 10) {
            return WorkbenchMessages.getString("GlobalBuildAction.buildOperationTitle");
        }
        return WorkbenchMessages.getString("GlobalBuildAction.rebuildAllOperationTitle");
    }

    public void doBuild() {
        this.doBuildOperation();
    }

    void doBuildOperation() {
        final MultiStatus status = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.getString("GlobalBuildAction.buildProblems"), null);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("", 1);
                monitor.setTaskName(GlobalBuildAction.this.getOperationMessage());
                try {
                    try {
                        ResourcesPlugin.getWorkspace().build(GlobalBuildAction.this.buildType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        status.add(e.getStatus());
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            WorkbenchPlugin.log("Exception in " + ((Object)((Object)this)).getClass().getName() + ".run: " + e.getTargetException());
            MessageDialog.openError((Shell)this.shell, (String)WorkbenchMessages.getString("GlobalBuildAction.buildProblems"), (String)WorkbenchMessages.format("GlobalBuildAction.internalError", new Object[]{e.getTargetException().getMessage()}));
            return;
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.shell, (String)WorkbenchMessages.getString("GlobalBuildAction.problemTitle"), null, (IStatus)status);
        }
    }

    IProject[] getWorkspaceProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public void run() {
        IProject[] roots = this.getWorkspaceProjects();
        if (roots.length < 1) {
            return;
        }
        if (!this.verifyBuildersAvailable(roots)) {
            return;
        }
        this.saveAllResources();
        this.doBuildOperation();
    }

    void saveAllResources() {
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] windows = this.workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] perspectives = windows[i].getPages();
            int j = 0;
            while (j < perspectives.length) {
                perspectives[j].saveAllEditors(false);
                ++j;
            }
            ++i;
        }
    }

    boolean verifyBuildersAvailable(IProject[] roots) {
        try {
            int i = 0;
            while (i < roots.length) {
                if (roots[i].isAccessible() && roots[i].getDescription().getBuildSpec().length > 0) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Exception in " + ((Object)((Object)this)).getClass().getName() + ".run: " + (Object)((Object)e));
            ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.getString("GlobalBuildAction.buildProblems"), (String)WorkbenchMessages.format("GlobalBuildAction.internalError", new Object[]{e.getMessage()}), (IStatus)e.getStatus());
            return false;
        }
        return false;
    }
}

