/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.CommonSQLParserException;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.ArithmeticExpression;
import com.sap.sql.tree.BetweenPredicate;
import com.sap.sql.tree.BooleanNot;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.ConcatenationExpression;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.ExistsPredicate;
import com.sap.sql.tree.InListPredicate;
import com.sap.sql.tree.InSubqueryPredicate;
import com.sap.sql.tree.JoinedTable;
import com.sap.sql.tree.LikePredicate;
import com.sap.sql.tree.NullPredicate;
import com.sap.sql.tree.QuantifiedComparisonPredicate;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SQLStatement;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SetFunction;
import com.sap.sql.tree.TableReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class CheckJoinVisitor
extends CheckVisitor {
    private ArrayList scopes = new ArrayList();
    private int joinNum = 0;
    private static final int NOTFOUND = -1;

    public CheckJoinVisitor(Vector errorLog) throws CommonSQLParserException {
        super(errorLog);
        this.scopes.add(new Scope());
    }

    public void visitJoinedTableBefore(JoinedTable x) {
        Scope parent = (Scope)this.scopes.get(this.joinNum);
        ++this.joinNum;
        Scope current = new Scope();
        current.parent = parent;
        this.scopes.add(this.joinNum, current);
    }

    private void checkOnClause(Scope current, SearchCondition onClause) {
        onColumnCollector occ = new onColumnCollector(current);
        onClause.accept((SQLVisitor)occ);
        if (!occ.onlyAnd) {
            this.println("onAnd", null, 1);
        }
        if (occ.setFunc) {
            this.println("onNoSet", null, 1);
        }
        if (current.outerJoin && !occ.onlySimpleComparison) {
            this.println("joinOnCmpViolated", null, 1);
        }
    }

    public void visitJoinedTable(JoinedTable x) {
        SearchCondition onClause;
        Scope current = (Scope)this.scopes.get(this.joinNum);
        Scope parent = current.parent;
        if (parent != null) {
            parent.child = current;
        }
        ArrayList<Object> myTables = new ArrayList<Object>();
        Query rightTab = x.getRightOperand();
        if (rightTab instanceof TableReference) {
            myTables.add(rightTab);
        } else {
            this.println("joinRightArgument", null, 1);
        }
        Query leftTab = x.getLeftOperand();
        if (leftTab instanceof TableReference) {
            myTables.add(leftTab);
        }
        if (current.child != null) {
            myTables.addAll(Arrays.asList(current.child.localTables));
        }
        current.localTables = new TableReference[myTables.size()];
        myTables.toArray(current.localTables);
        if (x.getJoinType() == 5) {
            current.outerJoin = true;
        }
        if ((onClause = x.getJoinCondition()) != null) {
            this.checkOnClause(current, onClause);
        }
        --this.joinNum;
    }

    private int searchLocalTable(ColumnReference colRef, TableReference[] tables) {
        String tableName = colRef.getTableName();
        if (null == tableName) {
            tableName = colRef.getColumnDescriptor().getTable().getName();
            int i = 0;
            while (i < tables.length) {
                if (tableName.equals(tables[i].getTableName())) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < tables.length) {
                if (tableName.equals(tables[i].getAliasName())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void dumpLists() {
        int i = 0;
        while (i < this.scopes.size()) {
            Scope current = (Scope)this.scopes.get(i);
            System.out.println(current + ":" + current.parent + ":" + current.child + ":");
            if (current.localTables != null) {
                int j = 0;
                while (j < current.localTables.length) {
                    this.println(current.localTables[j].getTableName(), 2);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void println(String line, int mode) {
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                LogEntry le = new LogEntry(line);
                this.errorLog.add(le);
                break;
            }
            case 2: {
                break;
            }
            default: {
                System.out.println("Unknown PrintMode");
            }
        }
    }

    private void println(String key, String f0, int mode) {
        if (f0 != null) {
            this.println(CommonSQLParserErrors.msg(key, f0), mode);
        } else {
            this.println(CommonSQLParserErrors.msg(key), mode);
        }
    }

    public boolean acceptsStatement(SQLStatement tree) {
        return true;
    }

    class onColumnCollector
    extends SQLVisitor {
        int inSubQuery = 0;
        boolean setFunc = false;
        boolean onlyAnd = true;
        private boolean onlySimpleComparison = true;
        private final List currentColumns = new ArrayList();
        private final Scope currentScope;

        onColumnCollector(Scope aScope) {
            this.currentScope = aScope;
        }

        public void visitColumnReference(ColumnReference x) {
            if (0 == this.inSubQuery) {
                this.currentColumns.add(x);
                int tableIndex = CheckJoinVisitor.this.searchLocalTable(x, this.currentScope.localTables);
                if (-1 == tableIndex) {
                    String columnName = x.getColumnName();
                    String aliasName = x.getTableName();
                    if (aliasName != null) {
                        columnName = aliasName + "." + columnName;
                    }
                    CheckJoinVisitor.this.println("blockNesting", columnName, 1);
                    return;
                }
                if (this.currentScope.outerJoin) {
                    Scope check = this.currentScope.child;
                    while (check != null) {
                        TableReference tabToCheck;
                        if (check.outerJoin && (tabToCheck = this.currentScope.localTables[tableIndex]).getTableName().equals(check.localTables[0].getTableName())) {
                            CheckJoinVisitor.this.println("joinOJ1SidedViolated", null, 1);
                        }
                        check = check.child;
                    }
                }
            }
        }

        public void visitQuerySpecificationBefore(QuerySpecification x) {
            ++this.inSubQuery;
        }

        public void visitQuerySpecification(QuerySpecification x) {
            --this.inSubQuery;
        }

        public void visitBooleanOr(BooleanOr x) {
            this.onlyAnd = false;
        }

        public void visitBooleanNot(BooleanNot x) {
            this.onlyAnd = false;
        }

        public void visitSetFunction(SetFunction x) {
            this.setFunc = true;
            this.onlySimpleComparison = false;
        }

        public void visitArithmeticExpression(ArithmeticExpression x) {
            this.onlySimpleComparison = false;
        }

        public void visitBetweenPredicate(BetweenPredicate x) {
            this.onlySimpleComparison = false;
        }

        public void visitConcatenationExpression(ConcatenationExpression x) {
            this.onlySimpleComparison = false;
        }

        public void visitCountAll(CountAll x) {
            this.setFunc = true;
            this.onlySimpleComparison = false;
        }

        public void visitExistsPredicate(ExistsPredicate x) {
            this.onlySimpleComparison = false;
        }

        public void visitInListPredicate(InListPredicate x) {
            this.onlySimpleComparison = false;
        }

        public void visitInSubqueryPredicate(InSubqueryPredicate x) {
            this.onlySimpleComparison = false;
        }

        public void visitLikePredicate(LikePredicate x) {
            this.onlySimpleComparison = false;
        }

        public void visitNullPredicate(NullPredicate x) {
            this.onlySimpleComparison = false;
        }

        public void visitQuantifiedComparisonPredicate(QuantifiedComparisonPredicate x) {
            this.onlySimpleComparison = false;
        }

        public void visitComparisonPredicate(ComparisonPredicate x) {
            if (0 == this.inSubQuery && this.currentScope.outerJoin) {
                int columnCount = this.currentColumns.size();
                switch (columnCount) {
                    case 1: {
                        int tableIdx = CheckJoinVisitor.this.searchLocalTable((ColumnReference)this.currentColumns.get(0), this.currentScope.localTables);
                        if (tableIdx == 0) break;
                        CheckJoinVisitor.this.println("joinOjOnProperViolated", null, 1);
                        break;
                    }
                    case 2: {
                        int leftColumnTable = CheckJoinVisitor.this.searchLocalTable((ColumnReference)this.currentColumns.get(0), this.currentScope.localTables);
                        int rightColumnTable = CheckJoinVisitor.this.searchLocalTable((ColumnReference)this.currentColumns.get(1), this.currentScope.localTables);
                        if (leftColumnTable == rightColumnTable) {
                            CheckJoinVisitor.this.println("joinOjOnProperViolated", null, 1);
                        }
                        if (leftColumnTable == 0 || rightColumnTable == 0) break;
                        CheckJoinVisitor.this.println("joinOjOnProperViolated", null, 1);
                        break;
                    }
                    default: {
                        CheckJoinVisitor.this.println("joinOjOnProperViolated", null, 1);
                    }
                }
            }
            this.currentColumns.clear();
        }
    }

    class Scope {
        Scope parent = null;
        Scope child = null;
        TableReference[] localTables;
        boolean outerJoin = false;

        Scope() {
        }
    }
}

