/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.sqlparser;

import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.sqlparser.CheckVisitor;
import com.sap.sql.sqlparser.CommonSQLParserErrors;
import com.sap.sql.sqlparser.LogEntry;
import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.ComparisonPredicate;
import com.sap.sql.tree.CountAll;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectForUpdateStatement;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SetFunction;
import com.sap.sql.tree.TableReference;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Vector;

public class CheckGroupVisitor
extends CheckVisitor {
    private static final Location trace = Location.getLocation((Class)(class$com$sap$sql$sqlparser$CheckGroupVisitor == null ? (class$com$sap$sql$sqlparser$CheckGroupVisitor = CheckGroupVisitor.class$("com.sap.sql.sqlparser.CheckGroupVisitor")) : class$com$sap$sql$sqlparser$CheckGroupVisitor));
    private ArrayList querys = new ArrayList();
    private int subQuery = 0;
    private boolean inSelSub = false;
    private boolean inSetFunc = false;
    private boolean inComPre = false;
    private boolean illegalGrp = false;
    private char stmtKind = (char)63;
    private boolean debug = trace.beDebug();
    static /* synthetic */ Class class$com$sap$sql$sqlparser$CheckGroupVisitor;

    public CheckGroupVisitor(Vector errorLog) {
        super(errorLog);
        this.querys.add(this.subQuery, new QuDes(null));
    }

    public void visitQuerySpecificationBefore(QuerySpecification x) {
        QuDes pa = (QuDes)this.querys.get(this.subQuery);
        ++this.subQuery;
        this.querys.add(this.subQuery, new QuDes(pa));
        if (x.getGroupByList() != null) {
            int i = 0;
            while (i < x.getGroupByList().length) {
                ((QuDes)this.querys.get((int)this.subQuery)).grplist.add(x.getGroupByList()[i]);
                ++i;
            }
        }
        if (this.inComPre && x.getGroupByList() != null) {
            this.illegalGrp = true;
        }
        if (x.getHavingClause() != null) {
            SearchCondition sc = x.getHavingClause();
            HavingCollector hc = new HavingCollector();
            sc.accept((SQLVisitor)hc);
            ((QuDes)this.querys.get((int)this.subQuery)).havlistdir = hc.getHavCols(true);
            ((QuDes)this.querys.get((int)this.subQuery)).havlistsub = hc.getHavCols(false);
            hc = null;
        }
        if (x.getWhereClause() != null) {
            SearchCondition sc = x.getWhereClause();
            WhereChecker wc = new WhereChecker();
            sc.accept((SQLVisitor)wc);
            ((QuDes)this.querys.get((int)this.subQuery)).querySets = wc.getQuerySets();
            wc = null;
        }
    }

    public void visitQuerySpecification(QuerySpecification x) {
        --this.subQuery;
    }

    public void visitSelectForUpdateBefore(SelectForUpdateStatement x) {
        this.stmtKind = (char)102;
    }

    public void visitSelectSublistBefore(SelectSublist x) {
        this.inSelSub = true;
    }

    public void visitSelectSublist(SelectSublist x) {
        this.inSelSub = false;
    }

    public void visitColumnReference(ColumnReference x) {
        if (this.inSelSub) {
            ((QuDes)this.querys.get((int)this.subQuery)).sellist.add(x);
        }
        if (this.inSelSub && this.inSetFunc) {
            ((QuDes)this.querys.get((int)this.subQuery)).setfunclist.add(x);
        }
    }

    public void visitCountAll(CountAll x) {
        if (this.inSelSub) {
            ((QuDes)this.querys.get((int)this.subQuery)).countAll = true;
        }
    }

    public void visitSetFunctionBefore(SetFunction x) {
        this.inSetFunc = true;
    }

    public void visitSetFunction(SetFunction x) {
        this.inSetFunc = false;
    }

    public void visitComparisonPredicateBefore(ComparisonPredicate x) {
        this.inComPre = true;
    }

    public void visitComparisonPredicate(ComparisonPredicate x) {
        this.inComPre = false;
    }

    public void visitTableReference(TableReference x) {
        ((QuDes)this.querys.get((int)this.subQuery)).tablist.add(x);
    }

    public void dumpLists() {
        int i = 0;
        while (i < this.querys.size()) {
            this.println("Query: " + i, 2);
            int j = 0;
            while (j < ((QuDes)this.querys.get((int)i)).grplist.size()) {
                this.println("Grp: " + ((ColumnReference)((QuDes)this.querys.get((int)i)).grplist.get(j)).getColumnName(), 2);
                ++j;
            }
            int j2 = 0;
            while (j2 < ((QuDes)this.querys.get((int)i)).sellist.size()) {
                this.println("Sel: " + ((ColumnReference)((QuDes)this.querys.get((int)i)).sellist.get(j2)).getColumnName(), 2);
                ++j2;
            }
            int j3 = 0;
            while (j3 < ((QuDes)this.querys.get((int)i)).setfunclist.size()) {
                this.println("Fun: " + ((ColumnReference)((QuDes)this.querys.get((int)i)).setfunclist.get(j3)).getColumnName(), 2);
                ++j3;
            }
            int j4 = 0;
            while (j4 < ((QuDes)this.querys.get((int)i)).havlistdir.size()) {
                this.println("HavD: " + ((ColumnReference)((QuDes)this.querys.get((int)i)).havlistdir.get(j4)).getColumnName(), 2);
                ++j4;
            }
            int j5 = 0;
            while (j5 < ((QuDes)this.querys.get((int)i)).havlistsub.size()) {
                this.println("HavS: " + ((ColumnReference)((QuDes)this.querys.get((int)i)).havlistsub.get(j5)).getColumnName(), 2);
                ++j5;
            }
            int j6 = 0;
            while (j6 < ((QuDes)this.querys.get((int)i)).querySets.size()) {
                this.println("QSet: " + ((ColumnReference)((QuDes)this.querys.get((int)i)).querySets.get(j6)).getColumnName(), 2);
                ++j6;
            }
            int j7 = 0;
            while (j7 < ((QuDes)this.querys.get((int)i)).tablist.size()) {
                this.println("Tab: " + ((TableReference)((QuDes)this.querys.get((int)i)).tablist.get(j7)).getTableName(), 2);
                ++j7;
            }
            ++i;
        }
        this.performChecks();
    }

    public void performChecks() {
        int i = 0;
        while (i < this.querys.size()) {
            this.checkGroup(i);
            this.checkHaving(i);
            this.checkQuerySet(i);
            ++i;
        }
        this.checkSetInUpd();
        if (this.illegalGrp) {
            this.println("noGrpInSubQ", null, 1);
        }
    }

    private void checkGroup(int quNu) {
        trace.entering("checkGroup");
        if (((QuDes)this.querys.get((int)quNu)).grplist.size() > 0) {
            if (((QuDes)this.querys.get((int)quNu)).sellist.size() == 0 && !((QuDes)this.querys.get((int)quNu)).countAll) {
                this.resolveAsterix(quNu);
            }
            int i = 0;
            while (i < ((QuDes)this.querys.get((int)quNu)).sellist.size()) {
                int found = 0;
                String selCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).sellist.get(i)).getColumnName();
                int j = 0;
                while (j < ((QuDes)this.querys.get((int)quNu)).grplist.size()) {
                    String grpCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).grplist.get(j)).getColumnName();
                    if (grpCol.compareTo(selCol) == 0) {
                        ++found;
                        if (this.debug) {
                            trace.debugT(grpCol + " is grpcol " + quNu);
                        }
                    }
                    if (this.isOuterRef((ColumnReference)((QuDes)this.querys.get((int)quNu)).grplist.get(j), (QuDes)this.querys.get(quNu))) {
                        this.println("outRefInGrp", grpCol, 1);
                    }
                    ++j;
                }
                int j2 = 0;
                while (j2 < ((QuDes)this.querys.get((int)quNu)).setfunclist.size()) {
                    String setFuncCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).setfunclist.get(j2)).getColumnName();
                    if (setFuncCol.compareTo(selCol) == 0) {
                        ++found;
                        if (this.debug) {
                            trace.debugT(setFuncCol + " is setcol " + quNu);
                        }
                    }
                    ++j2;
                }
                if (found == 0) {
                    this.println("noGrpOrAgg", selCol, 1);
                }
                ++i;
            }
        } else if (((QuDes)this.querys.get((int)quNu)).setfunclist.size() > 0 || ((QuDes)this.querys.get((int)quNu)).havlistdir.size() > 0) {
            int i = 0;
            while (i < ((QuDes)this.querys.get((int)quNu)).sellist.size()) {
                int found = 0;
                ColumnReference sel = (ColumnReference)((QuDes)this.querys.get((int)quNu)).sellist.get(i);
                int j = 0;
                while (j < ((QuDes)this.querys.get((int)quNu)).setfunclist.size()) {
                    ColumnReference setfunc = (ColumnReference)((QuDes)this.querys.get((int)quNu)).setfunclist.get(j);
                    if (sel.equals(setfunc)) {
                        ++found;
                        if (this.debug) {
                            trace.debugT(sel.getColumnName() + " is in set " + quNu);
                        }
                    }
                    ++j;
                }
                if (found == 0) {
                    this.println("noSetFunc", sel.getColumnName(), 1);
                }
                ++i;
            }
        }
        trace.exiting();
    }

    private void checkHaving(int quNu) {
        trace.entering("checkHaving");
        if (((QuDes)this.querys.get((int)quNu)).havlistdir.size() > 0) {
            int i = 0;
            while (i < ((QuDes)this.querys.get((int)quNu)).havlistdir.size()) {
                int found = 0;
                String havCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).havlistdir.get(i)).getColumnName();
                int j = 0;
                while (j < ((QuDes)this.querys.get((int)quNu)).grplist.size()) {
                    String grpCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).grplist.get(j)).getColumnName();
                    if (grpCol.compareTo(havCol) == 0) {
                        ++found;
                        if (!this.debug) break;
                        trace.debugT(havCol + " is grouped " + quNu);
                        break;
                    }
                    ++j;
                }
                if (found == 0) {
                    if (this.isOuterRef((ColumnReference)((QuDes)this.querys.get((int)quNu)).havlistdir.get(i), (QuDes)this.querys.get(quNu))) {
                        if (this.debug) {
                            trace.debugT(havCol + " is outer ref " + quNu);
                        }
                    } else {
                        this.println("noGrpOrOutRef", havCol, 1);
                    }
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < ((QuDes)this.querys.get((int)quNu)).havlistsub.size()) {
                int j = 0;
                while (j < ((QuDes)this.querys.get((int)quNu)).sellist.size()) {
                    String havCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).havlistsub.get(i2)).getColumnName();
                    String TCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).sellist.get(j)).getColumnName();
                    int found = 0;
                    if (havCol.compareTo(TCol) == 0) {
                        int k = 0;
                        while (k < ((QuDes)this.querys.get((int)quNu)).grplist.size()) {
                            String grpCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).grplist.get(k)).getColumnName();
                            if (grpCol.compareTo(havCol) == 0) {
                                ++found;
                            }
                            if (this.debug) {
                                trace.debugT(havCol + " is grouped " + quNu);
                            }
                            ++k;
                        }
                        int k2 = 0;
                        while (k2 < ((QuDes)this.querys.get((int)quNu)).setfunclist.size()) {
                            String setFuncCol = ((ColumnReference)((QuDes)this.querys.get((int)quNu)).setfunclist.get(k2)).getColumnName();
                            if (setFuncCol.compareTo(havCol) == 0) {
                                ++found;
                            }
                            if (this.debug) {
                                trace.debugT(setFuncCol + " is setcol " + quNu);
                            }
                            ++k2;
                        }
                        if (found == 0) {
                            this.println("noGrpOrSetFunc", havCol, 1);
                        }
                    }
                    ++j;
                }
                ++i2;
            }
        }
        trace.exiting();
    }

    private void checkQuerySet(int quNu) {
        trace.entering("checkQuerySet");
        if (((QuDes)this.querys.get((int)quNu)).querySets.size() > 0) {
            int i = 0;
            while (i < ((QuDes)this.querys.get((int)quNu)).querySets.size()) {
                boolean colOk = false;
                ColumnReference setCol = (ColumnReference)((QuDes)this.querys.get((int)quNu)).querySets.get(i);
                QuDes havingScope = ((QuDes)this.querys.get((int)quNu)).parent;
                if (havingScope != null) {
                    if (havingScope.havlistsub.size() == 0) {
                        this.println("setInWhere", null, 1);
                        break;
                    }
                    int j = 0;
                    while (j < havingScope.havlistsub.size()) {
                        ColumnReference havCol = (ColumnReference)havingScope.havlistsub.get(j);
                        if (setCol.equals(havCol) && this.isOuterRef(setCol, (QuDes)this.querys.get(quNu))) {
                            colOk = true;
                            if (this.debug) {
                                trace.debugT(havCol.getColumnName() + " is in set & outer ref " + quNu);
                            }
                        }
                        ++j;
                    }
                    if (!colOk) {
                        this.println("setInWhere", null, 1);
                    }
                } else {
                    this.println("setInWhere", null, 1);
                }
                ++i;
            }
        }
        trace.exiting();
    }

    private void checkSetInUpd() {
        if (this.stmtKind == 'f') {
            QuDes qd = (QuDes)this.querys.get(1);
            if (qd.setfunclist.size() > 0) {
                this.println("noSetInUpd", null, 1);
            }
        }
    }

    private boolean isOuterRef(ColumnReference colRef, QuDes quDes) {
        trace.entering("isOuterRef");
        int found = 0;
        String tabName = colRef.getTableName();
        if (tabName == null && colRef.getColumnDescriptor() != null && colRef.getColumnDescriptor().getTable() != null) {
            tabName = colRef.getColumnDescriptor().getTable().getName();
        }
        if (tabName == null) {
            trace.exiting((Object)"isOuterRef:false");
            return false;
        }
        int i = 0;
        while (i < quDes.tablist.size()) {
            String lookupTab = ((TableReference)quDes.tablist.get(i)).getTableName();
            String lookupAli = ((TableReference)quDes.tablist.get(i)).getAliasName();
            if (tabName != null && lookupTab != null && tabName.compareTo(lookupTab) == 0 || tabName != null && lookupAli != null && tabName.compareTo(lookupAli) == 0) {
                ++found;
                if (!this.debug) break;
                trace.debugT(colRef.getColumnName() + " found in " + tabName);
                break;
            }
            ++i;
        }
        if (found == 0) {
            trace.exiting((Object)"isOuterRef:true");
            return true;
        }
        trace.exiting((Object)"isOuterRef:false");
        return false;
    }

    private void resolveAsterix(int quNu) {
        trace.entering("resolveAsterix");
        ArrayList tabs = ((QuDes)this.querys.get((int)quNu)).tablist;
        ArrayList sel = ((QuDes)this.querys.get((int)quNu)).sellist;
        int i = 0;
        while (i < tabs.size()) {
            TableReference tabRef = (TableReference)tabs.get(i);
            if (tabRef.getTableDescriptor() != null) {
                ColumnIterator ci = tabRef.getTableDescriptor().getColumns();
                while (ci.hasNext()) {
                    sel.add(new ColumnReference(ci.next().getName()));
                }
            }
            ++i;
        }
        trace.exiting();
    }

    private void println(String line, int mode) {
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                this.errorLog.add(new LogEntry(line));
                break;
            }
            case 2: {
                break;
            }
            default: {
                System.out.println("Unknown PrintMode");
            }
        }
    }

    private void println(String key, String f0, int mode) {
        if (f0 != null) {
            this.println(CommonSQLParserErrors.msg(key, f0), mode);
        } else {
            this.println(CommonSQLParserErrors.msg(key), mode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WhereChecker
    extends SQLVisitor {
        int inSubQ = 0;
        boolean inSet = false;
        boolean inSelSubList = false;
        ArrayList subQSet = new ArrayList();

        WhereChecker() {
        }

        public void visitQuerySpecification(QuerySpecification x) {
            ++this.inSubQ;
        }

        public void visitQuerySpecificationBefore(QuerySpecification x) {
            --this.inSubQ;
        }

        public void visitSelectSublistBefore(SelectSublist x) {
            this.inSelSubList = true;
        }

        public void visitSelectSublist(SelectSublist x) {
            this.inSelSubList = false;
        }

        public void visitSetFunctionBefore(SetFunction x) {
            this.inSet = true;
        }

        public void visitSetFunction(SetFunction x) {
            this.inSet = false;
        }

        public void visitColumnReference(ColumnReference x) {
            if (this.inSet && this.inSubQ == 0 && !this.inSelSubList) {
                this.subQSet.add(x);
            }
        }

        public ArrayList getQuerySets() {
            return this.subQSet;
        }
    }

    class HavingCollector
    extends SQLVisitor {
        int inSubQ = 0;
        boolean inSetFunc = false;
        ArrayList dirhavlist = new ArrayList();
        ArrayList subhavlist = new ArrayList();

        HavingCollector() {
        }

        public void visitQuerySpecificationBefore(QuerySpecification x) {
            ++this.inSubQ;
        }

        public void visitQuerySpecification(QuerySpecification x) {
            --this.inSubQ;
        }

        public void visitSetFunctionBefore(SetFunction x) {
            this.inSetFunc = true;
        }

        public void visitSetFunction(SetFunction x) {
            this.inSetFunc = false;
        }

        public void visitColumnReference(ColumnReference x) {
            if (this.inSubQ == 0 && !this.inSetFunc) {
                this.dirhavlist.add(x);
            } else if (this.inSubQ == 1) {
                this.subhavlist.add(x);
            }
        }

        public ArrayList getHavCols(boolean direct) {
            if (direct) {
                return this.dirhavlist;
            }
            return this.subhavlist;
        }
    }

    class QuDes {
        QuDes parent;
        ArrayList grplist = new ArrayList();
        ArrayList sellist = new ArrayList();
        ArrayList setfunclist = new ArrayList();
        ArrayList havlistdir = new ArrayList();
        ArrayList havlistsub = new ArrayList();
        ArrayList querySets = new ArrayList();
        ArrayList tablist = new ArrayList();
        boolean countAll = false;

        QuDes(QuDes pa) {
            this.parent = pa;
        }
    }
}

