/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.security.http;

import com.sap.engine.lib.security.Base64;
import com.sap.engine.lib.security.http.DigestUtil;
import java.security.MessageDigest;

public class DigestChallenge {
    private String realm;
    private String algorithm;
    private String domain;
    private String qop = "auth";
    private String nonce;
    private String opaque;
    private boolean stale;
    private static String remoteAddr;
    private static final int USE_ONCE = 1;
    private static final int USE_NEVER_EXPIRES = Integer.MAX_VALUE;
    private static final int TIMEOUT_INFINITE = Integer.MAX_VALUE;
    private long nonceTimeout = Integer.MAX_VALUE;
    private int nonceUses = 1;
    private static MessageDigest mDigest;
    private static String key;

    public String getRemoteAddr() {
        return remoteAddr;
    }

    public void setRemoteAddr(String address) {
        remoteAddr = address;
    }

    public void setDigestAlgorithm(String alg) {
        this.algorithm = alg;
        mDigest = DigestUtil.messageDigest();
    }

    public String getDigestAlgorithm() {
        return this.algorithm;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setMessageQOP(String qop) {
        this.qop = qop;
    }

    public String getMessageQOP() {
        return this.qop;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setOpaque(String opaque) {
        this.opaque = opaque;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }

    public boolean getStale() {
        return this.stale;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        byte[] buffer = mDigest.digest(this.nonce.getBytes());
        String authenticateHeader = "Digest realm=\"" + this.realm + "\", " + "qop=\"" + this.qop + "\", nonce=\"" + this.nonce + "\", " + "opaque=\"" + DigestUtil.md5Encode(buffer) + "\"";
        return authenticateHeader;
    }

    public static String generateNonce(String remoteAddress) {
        try {
            long currentTime = System.currentTimeMillis();
            String nonceValue = remoteAddress + ":" + currentTime + ":" + key;
            return new String(Base64.encode(nonceValue.getBytes()));
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        mDigest = DigestUtil.messageDigest();
        key = "InQMy";
    }
}

