/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LoggingHelper {
    private static final Category SYSTEM = Category.getCategory((String)"/System");
    public static final Category SYS_DATABASE = Category.getCategory((Category)SYSTEM, (String)"Database");
    public static final Category SYS_NETWORK = Category.getCategory((Category)SYSTEM, (String)"Network");
    public static final Category SYS_SERVER = Category.getCategory((Category)SYSTEM, (String)"Server");
    public static final Category SYS_SECURITY = Category.getCategory((Category)SYSTEM, (String)"Security");

    public static void logThrowable(int severity, Category category, Location location, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        category.logT(severity, location, method, throwable.getMessage());
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }

    public static void logThrowable(int severity, Category category, Location location, String method, String message, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        category.logT(severity, location, method, message + " " + throwable.getMessage());
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }

    public static void traceThrowable(int severity, Location location, String method, Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        throwable.printStackTrace(wrapper);
        location.logT(severity, method, throwable.toString());
        location.logT(severity, method, writer.toString());
    }
}

