/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.lang;

import com.sap.engine.lib.lang.MonitorWithInterrupts;

public final class MonitorWithInterruptsPool {
    private int initialSize = 20;
    private int resizeStep = 20;
    private int pos = 0;
    private MonitorWithInterrupts[] arrayOfMonitorWithInterruptss;

    public MonitorWithInterruptsPool(int initialSize, int resizeStep) {
        if (resizeStep < 1 || initialSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initialSize;
        this.resizeStep = resizeStep;
        this.arrayOfMonitorWithInterruptss = new MonitorWithInterrupts[initialSize];
        int i = 0;
        while (i < initialSize) {
            this.arrayOfMonitorWithInterruptss[i] = new MonitorWithInterrupts();
            ++i;
        }
        this.pos = initialSize - 1;
    }

    public MonitorWithInterruptsPool() {
        this(20, 20);
    }

    public synchronized MonitorWithInterrupts getMonitorWithInterrupts() {
        if (this.pos < 0) {
            this.incrementArray();
        }
        return this.arrayOfMonitorWithInterruptss[this.pos--];
    }

    public synchronized void releaseMonitorWithInterrupts(MonitorWithInterrupts mon) {
        if (this.pos < this.arrayOfMonitorWithInterruptss.length - 1) {
            ++this.pos;
            this.arrayOfMonitorWithInterruptss[this.pos] = mon;
        }
    }

    public synchronized void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException("Wrong value of resizeStep parameter");
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public synchronized void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initSize parameter");
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void resize() {
        int usedElements = this.arrayOfMonitorWithInterruptss.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfMonitorWithInterruptss = new MonitorWithInterrupts[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfMonitorWithInterruptss.length != this.initialSize) {
            MonitorWithInterrupts[] tempArr = new MonitorWithInterrupts[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfMonitorWithInterruptss, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfMonitorWithInterruptss, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new MonitorWithInterrupts();
                    ++i;
                }
            }
            this.arrayOfMonitorWithInterruptss = tempArr;
            this.pos = newPos;
        }
    }

    private void incrementArray() {
        MonitorWithInterrupts[] tempArr = new MonitorWithInterrupts[this.arrayOfMonitorWithInterruptss.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new MonitorWithInterrupts();
            ++i;
        }
        this.arrayOfMonitorWithInterruptss = tempArr;
        this.pos = this.resizeStep - 1;
    }
}

