/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;

public class SerializableFile
implements Serializable {
    static final long serialVersionUID = -88711905566661953L;
    protected byte[] fileData;
    protected String fileName;
    protected String absolutePath;
    protected String workingDir = ".";

    public SerializableFile() {
    }

    public SerializableFile(String fileName) {
        this.initData(new File(fileName));
    }

    public SerializableFile(File file) {
        this.initData(file);
    }

    /*
     * Loose catch block
     */
    protected void initData(File file) {
        block9: {
            if (file == null) {
                this.fileData = null;
                return;
            }
            this.fileName = file.getName();
            this.absolutePath = file.getAbsolutePath();
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            this.fileData = new byte[(int)file.length()];
            fis.read(this.fileData);
            Object var5_3 = null;
            try {
                fis.close();
            }
            catch (Throwable th) {}
            break block9;
            {
                catch (Exception ex) {
                    this.fileData = null;
                    Object var5_4 = null;
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    fis.close();
                }
                catch (Throwable th) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public File getAsFile() {
        File theFile = null;
        theFile = new File(this.absolutePath);
        if (!theFile.exists()) {
            theFile = new File(this.workingDir + File.separator + this.fileName);
        }
        return theFile;
    }

    public File getFile(String fileName) {
        this.initData(new File(fileName));
        if (this.fileData != null) {
            return this.getAsFile();
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAbsoluteFilePath() {
        return this.absolutePath;
    }

    public void setAbsoluteFilePath(String name) {
        this.absolutePath = name;
    }

    public byte[] getBytes() {
        return this.fileData;
    }

    public void setWorkDirectory(String dir) {
        this.workingDir = dir;
    }

    public void delete() {
        File file = new File(this.workingDir + File.separator + this.fileName);
        if (file.exists() && !file.isDirectory()) {
            file.delete();
        }
    }

    public Object clone() {
        SerializableFile newFile = new SerializableFile();
        newFile.fileName = this.fileName;
        newFile.absolutePath = this.absolutePath;
        newFile.workingDir = this.workingDir;
        if (this.fileData == null) {
            newFile.fileData = null;
        } else {
            newFile.fileData = new byte[this.fileData.length];
            System.arraycopy(this.fileData, 0, newFile.fileData, 0, this.fileData.length);
        }
        return newFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SerializableFile)) return false;
        SerializableFile file = (SerializableFile)obj;
        if (this.fileName != null) {
            if (file.fileName == null) return false;
            if (!this.fileName.equals(file.fileName)) {
                return false;
            }
        } else if (file.fileName != null) {
            return false;
        }
        if (this.absolutePath != null) {
            if (file.absolutePath == null) return false;
            if (!this.absolutePath.equals(file.absolutePath)) {
                return false;
            }
        } else if (file.absolutePath != null) {
            return false;
        }
        if (this.fileData != null) {
            if (file.fileData == null) return false;
            if (this.fileData.length != file.fileData.length) {
                return false;
            }
            int i = 0;
            while (i < this.fileData.length) {
                if (this.fileData[i] != file.fileData[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (file.fileData == null) return true;
            return false;
        }
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setBytes(byte[] fileData) {
        this.fileData = fileData;
    }
}

