/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.basesrvc.util;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class IOUtil {
    private static final Location logger = Location.getLocation((String)"com.sap.tc.webdynpro.basesrvc.util.IOUtil");
    private static Vector byteArrays;
    private static Vector digestArray;
    private static final int BYTE_ARRAY_SIZE = 10240;
    private static String ALGORITHM;
    private static byte[] base64EncodeMap;

    private static byte[] getByteArray() {
        byte[] cache = null;
        Vector vector = byteArrays;
        synchronized (vector) {
            int index = byteArrays.size() - 1;
            if (index >= 0) {
                cache = (byte[])byteArrays.remove(index);
            }
        }
        if (cache == null) {
            cache = new byte[10240];
        }
        return cache;
    }

    private static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        MessageDigest digest = null;
        Vector vector = digestArray;
        synchronized (vector) {
            int index = digestArray.size() - 1;
            if (index >= 0) {
                digest = (MessageDigest)digestArray.remove(index);
            }
        }
        if (digest == null) {
            digest = MessageDigest.getInstance(ALGORITHM);
        }
        return digest;
    }

    private static void releaseByteArray(byte[] byteArray) {
        byteArrays.add(byteArray);
    }

    private static void releaseDigestArray(MessageDigest digest) {
        digestArray.add(digest);
    }

    public static int write(InputStream input, OutputStream out) throws IOException {
        int length = 0;
        int sum_length = 0;
        byte[] part = IOUtil.getByteArray();
        try {
            while ((length = input.read(part)) != -1) {
                out.write(part, 0, length);
                sum_length += length;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtil.releaseByteArray(part);
            throw throwable;
        }
        IOUtil.releaseByteArray(part);
        return sum_length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StreamInfo writeEncrypted(InputStream input, OutputStream out) throws IOException {
        int length = 0;
        int sum_length = 0;
        byte[] part = IOUtil.getByteArray();
        StreamInfo info = null;
        try {
            try {
                MessageDigest digest = IOUtil.getMessageDigest();
                while (true) {
                    if ((length = input.read(part)) == -1) {
                        String encryptKey = new String(IOUtil.encodeBase64(digest.digest()));
                        info = new StreamInfo(length, encryptKey);
                        IOUtil.releaseDigestArray(digest);
                        break;
                    }
                    out.write(part, 0, length);
                    digest.update(part, 0, length);
                    sum_length += length;
                }
            }
            catch (NoSuchAlgorithmException exp) {
                if (Category.SYS_USER_INTERFACE.beFatal()) {
                    Category.SYS_USER_INTERFACE.logThrowableT(600, logger, "writeEncrypted", "", (Throwable)exp);
                }
                Object var9_10 = null;
                IOUtil.releaseByteArray(part);
                return info;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            IOUtil.releaseByteArray(part);
            throw throwable;
        }
        IOUtil.releaseByteArray(part);
        return info;
    }

    public static void write(InputStream input, IOutputStream out) throws IOException {
        int length = 0;
        byte[] part = IOUtil.getByteArray();
        try {
            while ((length = input.read(part)) != -1) {
                out.write(part, 0, length);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtil.releaseByteArray(part);
            throw throwable;
        }
        IOUtil.releaseByteArray(part);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StreamInfo writeEncrypted(InputStream input, IOutputStream out) throws IOException {
        int length = 0;
        int sum_length = 0;
        byte[] part = IOUtil.getByteArray();
        StreamInfo info = null;
        try {
            try {
                MessageDigest digest = IOUtil.getMessageDigest();
                while (true) {
                    if ((length = input.read(part)) == -1) {
                        String encryptKey = new String(IOUtil.encodeBase64(digest.digest()));
                        info = new StreamInfo(length, encryptKey);
                        IOUtil.releaseDigestArray(digest);
                        break;
                    }
                    out.write(part, 0, length);
                    digest.update(part, 0, length);
                    sum_length += length;
                }
            }
            catch (NoSuchAlgorithmException exp) {
                Category.SYS_USER_INTERFACE.logThrowableT(400, logger, "No algorithm found for calculating an MD5 key! Please check the JDK Version. Version 1.4 or higher is necessary.", (Throwable)exp);
                Object var9_10 = null;
                IOUtil.releaseByteArray(part);
                return info;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            IOUtil.releaseByteArray(part);
            throw throwable;
        }
        IOUtil.releaseByteArray(part);
        return info;
    }

    public static byte[] encodeBase64(byte[] data) {
        byte[] dest = new byte[]{};
        if (data != null) {
            try {
                dest = new byte[(data.length + 2) / 3 * 4];
                int sidx = 0;
                int didx = 0;
                while (sidx < data.length - 2) {
                    dest[didx++] = base64EncodeMap[data[sidx] >>> 2 & 0x3F];
                    dest[didx++] = base64EncodeMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                    dest[didx++] = base64EncodeMap[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F];
                    dest[didx++] = base64EncodeMap[data[sidx + 2] & 0x3F];
                    sidx += 3;
                }
                if (sidx < data.length) {
                    dest[didx++] = base64EncodeMap[data[sidx] >>> 2 & 0x3F];
                    if (sidx < data.length - 1) {
                        dest[didx++] = base64EncodeMap[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F];
                        dest[didx++] = base64EncodeMap[data[sidx + 1] << 2 & 0x3F];
                    } else {
                        dest[didx++] = base64EncodeMap[data[sidx] << 4 & 0x3F];
                    }
                }
                while (didx < dest.length) {
                    dest[didx] = 61;
                    ++didx;
                }
            }
            catch (Exception e) {
                dest = new byte[]{};
            }
        }
        return dest;
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.webdynpro.basesrvc.util.IOUtil").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_basesrvc/java/com/sap/tc/webdynpro/basesrvc/util/IOUtil.java#4 $");
        byteArrays = new Vector(10);
        digestArray = new Vector(10);
        ALGORITHM = "MD5";
        char[] char_base64EncodeMap = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '_'};
        base64EncodeMap = new byte[char_base64EncodeMap.length];
        int n = 0;
        while (n < char_base64EncodeMap.length) {
            IOUtil.base64EncodeMap[n] = (byte)char_base64EncodeMap[n];
            ++n;
        }
    }

    public static class StreamInfo {
        private final String uid;
        private final int length;

        private StreamInfo(int length, String uid) {
            this.uid = uid;
            this.length = length;
        }

        public String getUid() {
            return this.uid;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static interface IOutputStream {
        public void write(int var1);

        public void write(byte[] var1, int var2, int var3);

        public void write(byte[] var1);
    }
}

