/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.window;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.WebDynproVisitor;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.component.NavigationLinks;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.navigation.NavigationLink;
import com.sap.ide.metamodel.webdynpro.component.navigation.NavigationTargetReference;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.ViewContainer;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewArea;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewContainerAssignment;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewUsage;
import com.sap.ide.metamodel.webdynpro.component.viewset.Viewset;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewsetProperty;
import com.sap.ide.metamodel.webdynpro.enum.InboundPlugTypeEnum;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.controller.ViewControllerChecker;
import com.sap.ide.webdynpro.checklayer.window.WindowChecker;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class WindowVisitor
extends WebDynproVisitor {
    CheckResult mCheckResult;

    public void setCheckResult(CheckResult checkResult) {
        this.mCheckResult = checkResult;
    }

    public CheckResult getCheckResult() {
        return this.mCheckResult;
    }

    public void visitNavigationLink(NavigationLink navigationLink) {
        if (navigationLink.getSource() == null) {
            this.mCheckResult.addEntry((DevelopmentObject)navigationLink, 0, "", "Link has no source", "Repair Window");
        }
        if (navigationLink.getSourceViewUsage() == null) {
            this.mCheckResult.addEntry((DevelopmentObject)navigationLink, 0, "", "Link has no sourceViewUsage", "Repair Window");
        }
    }

    public void visitNavigationLinks(NavigationLinks object) {
    }

    public void visitNavigationTargetReference(NavigationTargetReference targetReference) {
        NavigationLink navigationLink;
        NavigationLinks container;
        InboundPlug inboundPlug = targetReference.getTarget();
        if (inboundPlug == null) {
            this.mCheckResult.addEntry((DevelopmentObject)targetReference, 0, "", "Link has no target", "Repair Window");
        } else if (inboundPlug.getType() == InboundPlugTypeEnum.STARTUP) {
            ViewUsage viewUsage;
            String inboundPlugLocation = "";
            if (targetReference.getTargetViewUsage() != null && (viewUsage = targetReference.getTargetViewUsage()) != null && viewUsage.getView() != null) {
                inboundPlugLocation = viewUsage.getView().getName() + "." + inboundPlug.getName();
            }
            String message = "Target Inbound Plug " + inboundPlugLocation + " of Link has Type startup. Do not navigate to Inbound Plugs with type startup. The behaviour of this plug type will change.";
            this.mCheckResult.addEntry((DevelopmentObject)targetReference, 1, "", message, "");
        }
        if (targetReference.getTargetViewUsage() == null) {
            this.mCheckResult.addEntry((DevelopmentObject)targetReference, 0, "", "Link has no targetViewUsage", "Repair Window");
        }
        if ((container = (navigationLink = targetReference.getNavigationLink()).getContainer()) == null) {
            return;
        }
        Window window = container.getWindow();
        if (window == null) {
            return;
        }
        OutboundPlug outboundPlug = navigationLink.getSource();
        if (outboundPlug != null && inboundPlug != null) {
            AbstractView sourceView = outboundPlug.getView();
            AbstractView targetView = inboundPlug.getView();
            if (sourceView == null || targetView == null) {
                return;
            }
            Vector errors = ViewControllerChecker.arePlugsParameterCompatible(outboundPlug, inboundPlug);
            if (errors != null) {
                String source = "(" + sourceView.getName() + "," + outboundPlug.getName() + ")";
                String target = "(" + targetView.getName() + "," + inboundPlug.getName() + ")";
                String message = "Link from " + source + " to " + target + ": Plug Parameters are not compatible";
                this.mCheckResult.addEntry((DevelopmentObject)window, 0, "", message, "");
                Iterator it = ((AbstractList)errors).iterator();
                while (it.hasNext()) {
                    Object object = it.next();
                    if (!(object instanceof Parameter)) continue;
                    Parameter parameter = (Parameter)object;
                    this.mCheckResult.addEntry((DevelopmentObject)window, 0, "", "Parameter " + parameter.getName() + "(" + parameter.getType().getName() + ") cannot be supplied", "");
                }
            }
        }
    }

    public void visitViewArea(ViewArea object) {
    }

    public void visitViewContainerAssignment(ViewContainerAssignment object) {
        if (object.getViewContainer() == null) {
            this.mCheckResult.addEntry((DevelopmentObject)object, 0, "", "ViewContainer is missing in embedded View", "Repair Window");
        }
    }

    public void visitViewUsage(ViewUsage viewUsage) {
        AbstractView abstractView = viewUsage.getView();
        if (abstractView == null) {
            this.mCheckResult.addEntry((DevelopmentObject)viewUsage, 0, "", "Embedded View/InterfaceView is missing", "Repair Window");
            return;
        }
        if (abstractView instanceof InterfaceView) {
            if (viewUsage.getComponentUsage() == null) {
                this.mCheckResult.addEntry((DevelopmentObject)viewUsage, 0, "", "Component Instance is missing", "");
            }
        } else if (abstractView instanceof View) {
            View view = (View)abstractView;
            ViewContainer[] viewContainers = view.getViewContainers();
            int i = 0;
            while (i < viewContainers.length) {
                ViewContainer viewContainer = viewContainers[i];
                if (!WindowChecker.hasViewContainerAssignment(viewUsage, viewContainer)) {
                    String message = "ViewContainerAssignment is missing for ViewContainer " + viewContainer.getName();
                    this.mCheckResult.addEntry((DevelopmentObject)viewUsage, 0, "", message, "Repair Window");
                }
                ++i;
            }
        }
    }

    public void visitViewset(Viewset object) {
    }

    public void visitViewsetProperty(ViewsetProperty object) {
    }

    public void visitWindow(Window window) {
        if (window.getDefaultViewsetHierarchyRootNode() == null && window.getViewsetHierarchyRootNodeCount() > 0) {
            this.mCheckResult.addEntry((DevelopmentObject)window, 1, "", "None of the embedded objects has default property", "");
        }
        if (window.getInterfaceView() == null) {
            this.mCheckResult.addEntry((DevelopmentObject)window, 0, "", "window has no InterfaceView", "");
        }
    }
}

