/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.view;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.component.view.ViewContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Label;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.metamodel.webdynpro.enum.LabelSupportEnum;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementLibrary;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.MDOChecker;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.ide.webdynpro.checklayer.view.LabelChecker;
import com.sap.ide.webdynpro.checklayer.view.ViewElementChecker;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ViewChecker
extends MDOChecker {
    static ViewChecker mInstance = new ViewChecker();
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$view$ViewChecker == null ? (class$com$sap$ide$webdynpro$checklayer$view$ViewChecker = ViewChecker.class$("com.sap.ide.webdynpro.checklayer.view.ViewChecker")) : class$com$sap$ide$webdynpro$checklayer$view$ViewChecker).getName());
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$view$ViewChecker;

    public static ViewChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        long startingTime = System.currentTimeMillis();
        if (!(developmentObject instanceof View)) {
            return;
        }
        super.check(developmentObject, fullCheck, checkResult);
        ViewChecker.check((View)developmentObject, fullCheck, checkResult);
        Utils.traceTime(sLocation, developmentObject, startingTime);
    }

    private static void check(View view, boolean fullCheck, CheckResult checkResult) {
        Controller viewController = view.getViewController();
        if (viewController == null) {
            checkResult.addEntry((DevelopmentObject)view, 0, "", "View has no Controller", "");
        }
        ViewContainer[] viewContainers = view.getViewContainers();
        int i = 0;
        while (i < viewContainers.length) {
            if (viewContainers[i].getViewContainerUIElement() == null) {
                checkResult.addEntry((DevelopmentObject)view, 0, "", "Internal Error: ViewContainer has no ViewContainerUIElement", "");
            }
            ++i;
        }
        HashMap lDefinitions = new HashMap();
        HashMap lLabels = new HashMap();
        Vector lElements = LabelChecker.getInputElementsAndLabels(view, lDefinitions, lLabels);
        ViewChecker.checkViewElements(view, lElements, lDefinitions, lLabels, false, checkResult);
        checkResult.addCheckedMDO((MainDevelopmentObject)view);
    }

    public static void checkViewElements(View view, Vector elements, HashMap definitions, HashMap labels, boolean repair, CheckResult checkResult) {
        Vector<UIElementLibrary> libraries = new Vector<UIElementLibrary>();
        UIElementLibrary[] libraryarray = view.getComponent().getUsedUIELibraries();
        if (libraryarray.length > 0) {
            int i = 0;
            while (i < libraryarray.length) {
                libraries.add(libraryarray[i]);
                ++i;
            }
        } else {
            try {
                UIElementLibrary[] UILibraries = ((WebDynproRoot)view.getRoot()).getUIElementLibraries();
                int i = 0;
                while (i < UILibraries.length) {
                    if (UILibraries[i].getName().equals("Standard")) {
                        libraries.add(UILibraries[i]);
                    } else if (UILibraries[i].getName().equals("BusinessGraphics")) {
                        libraries.add(UILibraries[i]);
                    }
                    ++i;
                }
            }
            catch (LoadException e) {
                // empty catch block
            }
        }
        ViewElementChecker.check((ViewElement)view.getRootUIElementContainer(), elements, libraries, checkResult);
        int i = 0;
        while (i < elements.size()) {
            boolean found = ViewChecker.findLabelFor(labels, (UIElement)elements.get(i));
            UIElementDefinition definition = (UIElementDefinition)LabelChecker.getDefinitionAll((ViewElement)elements.get(i), definitions);
            if (!found && definition.getLabelSupport() == LabelSupportEnum.LABEL_MANDATORY) {
                checkResult.addEntry((DevelopmentObject)((UIElement)elements.get(i)), 1, "", "UIElement does not have a label", "");
            } else if (!found && definition.getLabelSupport() == LabelSupportEnum.LABEL_ALLOWED) {
                checkResult.addEntry((DevelopmentObject)((UIElement)elements.get(i)), 2, "", "UIElement does not have a label", "");
            }
            ++i;
        }
    }

    public static boolean findLabelFor(HashMap labels, UIElement element) {
        Iterator it = labels.values().iterator();
        Label lViewElement = null;
        while (it.hasNext()) {
            lViewElement = (Label)it.next();
            if (lViewElement.getLabelFor() == null || !lViewElement.getLabelFor().equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

