/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.model;

import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import java.util.ArrayList;
import java.util.List;

public final class ModelHelper {
    public static final int TYPE_INTERFACE = 0;
    public static final int TYPE_MODELCLASS = 1;
    public static final int TYPE_MODELCLASS_OR_INTERFACE = 2;

    public static ModelRelation[] getModelRelations(Model model, boolean queryUsedModels) {
        ArrayList relations = new ArrayList(model.getModelRelationCount());
        ModelHelper.addModelRelationsOfModel(model, relations, queryUsedModels);
        return relations.toArray(new ModelRelation[relations.size()]);
    }

    public static ModelClass[] getInterfaces(Model model, boolean queryUsedModels) {
        return ModelHelper.getInterfaces(model, queryUsedModels, null);
    }

    public static ModelClass[] getInterfaces(Model model, boolean queryUsedModels, ModelClass[] filter) {
        ArrayList interfaces = new ArrayList(model.getModelClassCount());
        ModelHelper.addModelClassesOfModel(model, interfaces, 0, queryUsedModels);
        ModelHelper.filterModelClasses(interfaces, filter);
        return interfaces.toArray(new ModelClass[interfaces.size()]);
    }

    public static ModelClass[] getModelClasses(Model model, boolean queryUsedModels) {
        return ModelHelper.getModelClasses(model, queryUsedModels, null);
    }

    public static ModelClass[] getModelClasses(Model model, boolean queryUsedModels, ModelClass[] filter) {
        ArrayList modelClasses = new ArrayList(model.getModelClassCount());
        ModelHelper.addModelClassesOfModel(model, modelClasses, 1, queryUsedModels);
        ModelHelper.filterModelClasses(modelClasses, filter);
        return modelClasses.toArray(new ModelClass[modelClasses.size()]);
    }

    public static ModelClass[] getModelClassesAndInterfaces(Model model, boolean queryUsedModels) {
        return ModelHelper.getModelClassesAndInterfaces(model, queryUsedModels, null);
    }

    public static ModelClass[] getModelClassesAndInterfaces(Model model, boolean queryUsedModels, ModelClass[] filter) {
        ArrayList modelClasses = new ArrayList(model.getModelClassCount());
        ModelHelper.addModelClassesOfModel(model, modelClasses, 2, queryUsedModels);
        ModelHelper.filterModelClasses(modelClasses, filter);
        return modelClasses.toArray(new ModelClass[modelClasses.size()]);
    }

    public static String[] getQualifiedModelClassNames(ModelClass[] modelClasses) {
        String[] modelClassNames = new String[modelClasses.length];
        int i = 0;
        while (i < modelClasses.length) {
            modelClassNames[i] = modelClasses[i].getQualifiedName();
            ++i;
        }
        return modelClassNames;
    }

    public static void addModelClassesOfModel(Model model, List allModelClasses, int modelClassType, boolean queryUsedModels) {
        int i;
        if (queryUsedModels && model.getUsedModelCount() > 0) {
            Model[] models = model.getUsedModels();
            i = 0;
            while (i < models.length) {
                ModelHelper.addModelClassesOfModel(models[i], allModelClasses, modelClassType, queryUsedModels);
                ++i;
            }
        }
        ModelClass[] modelClasses = model.getModelClasses();
        i = 0;
        while (i < modelClasses.length) {
            if ((modelClasses[i].getIsInterface() && modelClassType == 0 || !modelClasses[i].getIsInterface() && modelClassType == 1 || modelClassType == 2) && !allModelClasses.contains(modelClasses[i])) {
                allModelClasses.add(modelClasses[i]);
            }
            ++i;
        }
    }

    public static Model[] getUsedModels(Model model, boolean queryUsedModels) {
        if (model.getUsedModelCount() > 0) {
            ArrayList usedModels = new ArrayList();
            ModelHelper.addUsedModelsOfModel(model, usedModels, queryUsedModels);
            return usedModels.toArray(new Model[usedModels.size()]);
        }
        return new Model[0];
    }

    public static boolean isRelationBidirectional(ModelRelationRole target) {
        ModelRelationRole[] roles;
        if (target != null && (roles = target.getModelRelation().getModelRelationRoles()).length == 2) {
            return roles[0].getNavigable() && roles[1].getNavigable();
        }
        return false;
    }

    public static String getModelSettingDefinitionValue(Model model, String settingName) {
        ModelSetting setting = model.getSetting(settingName);
        if (setting != null) {
            return setting.getValue();
        }
        return null;
    }

    public static boolean getStructureBindingEnabled(Model model) {
        ModelType modelType;
        if (model != null && (modelType = model.getModelType()) != null) {
            return modelType.getStructureBindingEnabled();
        }
        return false;
    }

    public static boolean getStructureBindingEnabled(ModelClass modelClass) {
        if (modelClass != null) {
            return ModelHelper.getStructureBindingEnabled(modelClass.getModel());
        }
        return false;
    }

    public static boolean getStructureBindingEnabled(ModelClassProperty modelClassProperty) {
        if (modelClassProperty != null) {
            return ModelHelper.getStructureBindingEnabled(((ModelClass)modelClassProperty.getParent()).getModel());
        }
        return false;
    }

    public static ModelClass getModelClass(Model model, String fullyQualifiedName, boolean queryUsedModels) {
        String packageName = fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(46) != -1 ? fullyQualifiedName.lastIndexOf(46) : 0);
        String className = packageName.length() > 0 ? fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1, fullyQualifiedName.length()) : fullyQualifiedName;
        return ModelHelper.getModelClass(model, packageName, className, queryUsedModels);
    }

    public static ModelClass getModelClass(Model model, String packageName, String className, boolean queryUsedModels) {
        if (model.hasModelClass(packageName, className)) {
            return model.getModelClass(packageName, className);
        }
        Model[] models = ModelHelper.getUsedModels(model, queryUsedModels);
        int i = 0;
        while (i < models.length) {
            if (models[i].hasModelClass(packageName, className)) {
                return models[i].getModelClass(packageName, className);
            }
            ++i;
        }
        return null;
    }

    private static void addModelRelationsOfModel(Model model, List allModelRelations, boolean queryUsedModels) {
        int i;
        if (queryUsedModels && model.getUsedModelCount() > 0) {
            Model[] models = model.getUsedModels();
            i = 0;
            while (i < models.length) {
                ModelHelper.addModelRelationsOfModel(models[i], allModelRelations, queryUsedModels);
                ++i;
            }
        }
        ModelRelation[] relations = model.getModelRelations();
        i = 0;
        while (i < relations.length) {
            if (!allModelRelations.contains(relations[i])) {
                allModelRelations.add(relations[i]);
            }
            ++i;
        }
    }

    private static void addUsedModelsOfModel(Model model, List usedModels, boolean queryUsedModels) {
        block6: {
            block4: {
                block5: {
                    if (!queryUsedModels) break block4;
                    if (model.getUsedModelCount() <= 0) break block5;
                    Model[] models = model.getUsedModels();
                    int i = 0;
                    while (i < models.length) {
                        ModelHelper.addUsedModelsOfModel(models[i], usedModels, queryUsedModels);
                        ++i;
                    }
                    break block6;
                }
                if (usedModels.contains(model)) break block6;
                usedModels.add(model);
                break block6;
            }
            if (model.getUsedModelCount() > 0) {
                Model[] models = model.getUsedModels();
                int i = 0;
                while (i < models.length) {
                    if (!usedModels.contains(models[i])) {
                        usedModels.add(models[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private static void filterModelClasses(List allModelClasses, ModelClass[] filter) {
        int j = 0;
        while (filter != null && j < filter.length) {
            int i = 0;
            while (i < allModelClasses.size()) {
                ModelClass modelClass = (ModelClass)allModelClasses.get(i);
                if (filter[j] != null && filter[j].equals(modelClass)) {
                    allModelClasses.remove(i);
                    break;
                }
                ++i;
            }
            ++j;
        }
    }
}

