/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.model;

import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethod;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelClassHelper {
    public static Model getModel(ModelClassProperty property) {
        if (property != null) {
            return ((ModelClass)property.getParent()).getModel();
        }
        return null;
    }

    public static ModelClass[] getInterfaces(ModelClass modelClass) {
        return ModelClassHelper.getInterfaces(modelClass, true);
    }

    public static ModelClass[] getInterfaces(ModelClass modelClass, boolean querySuperClasses) {
        ArrayList interfaces = new ArrayList();
        if (modelClass != null) {
            ModelClassHelper.addInterfaces(modelClass, querySuperClasses, interfaces);
        }
        return interfaces.toArray(new ModelClass[interfaces.size()]);
    }

    public static ModelClass[] getSuperClasses(ModelClass modelClass) {
        return ModelClassHelper.getSuperClasses(modelClass, true);
    }

    public static ModelClass[] getSuperClasses(ModelClass modelClass, boolean querySuperClasses) {
        ModelClass superClass;
        ArrayList<ModelClass> superClasses = new ArrayList<ModelClass>();
        if (modelClass != null && (superClass = (ModelClass)modelClass.getSuperClass()) != null) {
            do {
                superClasses.add(superClass);
                superClass = (ModelClass)superClass.getSuperClass();
            } while (querySuperClasses && superClass != null);
        }
        return superClasses.toArray(new ModelClass[superClasses.size()]);
    }

    public static ModelClassProperty[] getProperties(ModelClass modelClass) {
        return ModelClassHelper.getProperties(modelClass, true);
    }

    public static ModelClassProperty[] getProperties(ModelClass modelClass, boolean querySuperClasses) {
        HashMap properties = new HashMap();
        ModelClassHelper.addProperties(modelClass, querySuperClasses, properties);
        return properties.values().toArray(new ModelClassProperty[properties.size()]);
    }

    public static ModelClassMethod[] getMethods(ModelClass modelClass) {
        return ModelClassHelper.getMethods(modelClass, true);
    }

    public static ModelClassMethod[] getMethods(ModelClass modelClass, boolean querySuperClasses) {
        HashMap methods = new HashMap();
        ModelClassHelper.addMethods(modelClass, querySuperClasses, methods);
        return methods.values().toArray(new ModelClassMethod[methods.size()]);
    }

    public static ModelRelationRole[] getNavigableTargetModelRelationRoles(ModelClass modelClass) {
        return ModelClassHelper.getNavigableTargetModelRelationRoles(modelClass, true);
    }

    public static ModelRelationRole[] getNavigableTargetModelRelationRoles(ModelClass modelClass, boolean querySuperClasses) {
        ModelRelationRole[] sourceRoles = ModelClassHelper.getSourceRoles(modelClass, querySuperClasses);
        ArrayList<ModelRelationRole> targetRoles = new ArrayList<ModelRelationRole>();
        int i = 0;
        while (i < sourceRoles.length) {
            ModelRelationRole[] roles = sourceRoles[i].getModelRelation().getModelRelationRoles();
            if (roles.length == 2) {
                ModelRelationRole target = roles[0];
                if (roles[0] == sourceRoles[i]) {
                    target = roles[1];
                }
                if (target.getNavigable()) {
                    targetRoles.add(target);
                }
                if (sourceRoles[i].getNavigable() && target.getNavigable() && modelClass.equals(sourceRoles[i].getModelClass()) && modelClass.equals(target.getModelClass())) {
                    targetRoles.add(sourceRoles[i]);
                }
            }
            ++i;
        }
        ModelRelationRole[] array = new ModelRelationRole[targetRoles.size()];
        return targetRoles.toArray(array);
    }

    public static ModelRelationRole[] getSourceRoles(ModelClass modelClass) {
        return ModelClassHelper.getSourceRoles(modelClass, true);
    }

    public static ModelRelationRole[] getSourceRoles(ModelClass modelClass, boolean querySuperClasses) {
        ModelRelation[] relations = ModelHelper.getModelRelations(modelClass.getModel(), querySuperClasses);
        ArrayList<ModelRelationRole> sourceRoles = new ArrayList<ModelRelationRole>();
        int i = 0;
        while (i < relations.length) {
            if (relations[i] != null) {
                ModelRelationRole[] roles = relations[i].getModelRelationRoles();
                int j = 0;
                while (j < roles.length && roles.length == 2) {
                    if (modelClass.equals(roles[j].getModelClass()) || querySuperClasses && ModelClassHelper.isAssignableFrom(roles[j].getModelClass(), modelClass)) {
                        if (j == 0 && (ModelClassHelper.isAssignableFrom(roles[1].getModelClass(), roles[0].getModelClass()) && !roles[1].getNavigable() || ModelClassHelper.isAssignableFrom(roles[0].getModelClass(), modelClass) && ModelClassHelper.isAssignableFrom(roles[1].getModelClass(), modelClass) && !roles[1].getNavigable())) {
                            sourceRoles.add(roles[1]);
                            break;
                        }
                        sourceRoles.add(roles[j]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return sourceRoles.toArray(new ModelRelationRole[sourceRoles.size()]);
    }

    public static ModelRelationRole getTargetRole(ModelClass sourceModelClass, String roleName) {
        if (sourceModelClass != null && roleName != null) {
            ModelRelationRole[] roles = ModelClassHelper.getNavigableTargetModelRelationRoles(sourceModelClass);
            int i = 0;
            while (i < roles.length) {
                if (roleName.equals(roles[i].getName())) {
                    return roles[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean isSuperInterfaceOf(ModelClass modelClass, ModelClass someInterface) {
        ModelClass[] interfaces = ModelClassHelper.getInterfaces(modelClass);
        int i = 0;
        while (i < interfaces.length) {
            if (someInterface.equals(interfaces[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSuperClassOf(ModelClass modelClass, ModelClass someSuperClass) {
        ModelClass theClass = (ModelClass)modelClass.getSuperClass();
        while (theClass != null && someSuperClass != null) {
            if (theClass.equals(someSuperClass)) {
                return true;
            }
            theClass = (ModelClass)theClass.getSuperClass();
        }
        return false;
    }

    public static boolean isAssignableFrom(ModelClass modelClass, ModelClass someModelClass) {
        if (modelClass == someModelClass) {
            return true;
        }
        if (someModelClass.getIsInterface()) {
            return ModelClassHelper.isSuperInterfaceOf(someModelClass, modelClass);
        }
        return ModelClassHelper.isSuperClassOf(someModelClass, modelClass);
    }

    public static boolean hasModelClassProperty(ModelClass modelClass, Property property) {
        ModelClassProperty[] properties = ModelClassHelper.getProperties(modelClass);
        int i = 0;
        while (i < properties.length) {
            if (properties[i].equals(property)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static DevelopmentObject getType(ModelClassProperty property) {
        if (property != null) {
            if (property.hasStructureElement()) {
                DevelopmentObject field = property.getStructureElement();
                if (field instanceof DtField) {
                    return ((DtField)field).getReferencedType();
                }
            } else {
                return property.getType();
            }
        }
        return null;
    }

    public static void sort(ModelClass modelClass, ModelClassMethod[] methods) {
        ArrayList<ModelClassMethod> sortedMembers = new ArrayList<ModelClassMethod>(methods.length);
        DevelopmentObjectNameComparator comparator = new DevelopmentObjectNameComparator();
        ModelClassHelper.sort(modelClass, (DevelopmentObject[])methods, sortedMembers, comparator);
        Arrays.sort(methods, comparator);
        int i = 0;
        while (i < methods.length) {
            if (methods[i] != null) {
                sortedMembers.add(methods[i]);
            }
            ++i;
        }
        sortedMembers.toArray(methods);
    }

    public static void sort(ModelClass modelClass, ModelClassProperty[] properties) {
        ArrayList<ModelClassProperty> sortedMembers = new ArrayList<ModelClassProperty>(properties.length);
        DevelopmentObjectNameComparator comparator = new DevelopmentObjectNameComparator();
        Arrays.sort(properties, comparator);
        ModelClassHelper.sort(modelClass, (DevelopmentObject[])properties, sortedMembers, comparator);
        int i = 0;
        while (i < properties.length) {
            if (properties[i] != null) {
                sortedMembers.add(properties[i]);
            }
            ++i;
        }
        sortedMembers.toArray(properties);
    }

    public static void sort(ModelClass modelClass, ModelClass[] interfaces) {
        ArrayList<ModelClass> sortedMembers = new ArrayList<ModelClass>(interfaces.length);
        DevelopmentObjectNameComparator comparator = new DevelopmentObjectNameComparator();
        Arrays.sort(interfaces, comparator);
        ModelClassHelper.sort(modelClass, interfaces, sortedMembers, comparator);
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i] != null) {
                sortedMembers.add(interfaces[i]);
            }
            ++i;
        }
        sortedMembers.toArray(interfaces);
    }

    private static void addMethods(ModelClass modelClass, boolean querySuperClasses, Map methods) {
        if (modelClass != null) {
            Object curClass = modelClass;
            do {
                Method[] curMethods = curClass.getMethods();
                int i = 0;
                while (i < curMethods.length) {
                    String name = curMethods[i].getName();
                    if (methods.get(name) == null) {
                        methods.put(name, curMethods[i]);
                    }
                    ++i;
                }
                ModelClass[] curInterfaces = curClass.getInterfaces();
                int i2 = 0;
                while (i2 < curInterfaces.length) {
                    ModelClassHelper.addMethods(curInterfaces[i2], querySuperClasses, methods);
                    ++i2;
                }
            } while ((curClass = querySuperClasses || curClass.getIsInterface() ? (ModelClass)curClass.getSuperClass() : null) != null);
        }
    }

    private static void addProperties(ModelClass modelClass, boolean querySuperClasses, Map properties) {
        if (modelClass != null) {
            Object curClass = modelClass;
            do {
                Property[] curProperties = curClass.getProperties();
                int i = 0;
                while (i < curProperties.length) {
                    String name = curProperties[i].getName();
                    if (properties.get(name) == null) {
                        properties.put(name, curProperties[i]);
                    }
                    ++i;
                }
                ModelClass[] curInterfaces = curClass.getInterfaces();
                int i2 = 0;
                while (i2 < curInterfaces.length) {
                    ModelClassHelper.addProperties(curInterfaces[i2], querySuperClasses, properties);
                    ++i2;
                }
            } while ((curClass = querySuperClasses || curClass.getIsInterface() ? (ModelClass)curClass.getSuperClass() : null) != null);
        }
    }

    private static void addInterfaces(ModelClass modelClass, boolean querySuperClasses, List interfaces) {
        if (querySuperClasses && modelClass.getSuperClass() != null) {
            ModelClassHelper.addInterfaces((ModelClass)modelClass.getSuperClass(), querySuperClasses, interfaces);
        }
        if (modelClass.getInterfaceCount() > 0) {
            ModelClass[] curInterfaces = modelClass.getInterfaces();
            int i = 0;
            while (i < curInterfaces.length) {
                if (!interfaces.contains(curInterfaces[i])) {
                    interfaces.add(curInterfaces[i]);
                    if (curInterfaces[i].getInterfaceCount() > 0) {
                        ModelClassHelper.addInterfaces(curInterfaces[i], querySuperClasses, interfaces);
                    }
                }
                ++i;
            }
        }
    }

    private static void sort(ModelClass modelClass, DevelopmentObject[] members, List sortedMembers, DevelopmentObjectNameComparator comparator) {
        if (!modelClass.getIsInterface() && modelClass.getSuperClass() != null) {
            ModelClassHelper.sort((ModelClass)modelClass.getSuperClass(), members, sortedMembers, comparator);
        }
        if (modelClass.getInterfaceCount() > 0) {
            ModelClass[] interfaces = modelClass.getInterfaces();
            Arrays.sort(interfaces, comparator);
            int i = 0;
            while (i < interfaces.length) {
                ModelClassHelper.sort(interfaces[i], members, sortedMembers, comparator);
                ++i;
            }
        }
        int i = 0;
        while (i < members.length) {
            if (members[i] != null && members[i].getParent().equals(modelClass)) {
                sortedMembers.add(members[i]);
                members[i] = null;
            }
            ++i;
        }
    }

    private static void sort(ModelClass modelClass, ModelClass[] allInterfaces, List sortedInterfaces, DevelopmentObjectNameComparator comparator) {
        if (!modelClass.getIsInterface() && modelClass.getSuperClass() != null) {
            ModelClassHelper.sort((ModelClass)modelClass.getSuperClass(), allInterfaces, sortedInterfaces, comparator);
        }
        if (modelClass.getInterfaceCount() > 0) {
            ModelClass[] interfaces = modelClass.getInterfaces();
            Arrays.sort(interfaces, comparator);
            int i = 0;
            while (i < interfaces.length) {
                ModelClassHelper.sort(interfaces[i], allInterfaces, sortedInterfaces, comparator);
                ++i;
            }
        }
        int i = 0;
        while (i < allInterfaces.length) {
            if (modelClass.getIsInterface() && allInterfaces[i] != null && allInterfaces[i].equals(modelClass)) {
                sortedInterfaces.add(allInterfaces[i]);
                allInterfaces[i] = null;
            }
            ++i;
        }
    }

    private static class DevelopmentObjectNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((DevelopmentObject)o1).getName().compareTo(((DevelopmentObject)o2).getName());
        }
    }
}

