/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.controller;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.checklayer.CheckResult;

public class ComponentControllerChecker {
    static ComponentControllerChecker mInstance = new ComponentControllerChecker();

    public static ComponentControllerChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        if (!(developmentObject instanceof Controller)) {
            return;
        }
        ComponentControllerChecker.check((Controller)developmentObject, fullCheck, checkResult);
    }

    public static void check(Controller controller, boolean fullCheck, CheckResult checkResult) {
        if (!controller.getType().equals(ControllerTypeEnum.COMPONENT)) {
            checkResult.addEntry((DevelopmentObject)controller, 0, "", "Controller is no component controller", "");
        } else {
            DevelopmentObject parent = controller.getParent();
            if (parent == null || !(parent instanceof Component)) {
                checkResult.addEntry((DevelopmentObject)controller, 0, "", "Controller has no component", "");
            } else {
                Component component = (Component)parent;
                ComponentUsage[] usages = component.getComponentUsages();
                int i = 0;
                while (i < usages.length) {
                    if (!usages[i].hasUsedComponent()) {
                        checkResult.addEntry((DevelopmentObject)component, 0, usages[i].getName(), "Component usage has no used component", "");
                    }
                    ++i;
                }
                Model[] models = component.getUsedModels();
                int i2 = 0;
                while (i2 < models.length) {
                    if (models[i2] == null) {
                        checkResult.addEntry((DevelopmentObject)component, 0, "", "Component uses invalid model", "");
                    }
                    ++i2;
                }
            }
        }
    }
}

