/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.componentif;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.MDOChecker;
import com.sap.ide.webdynpro.checklayer.componentif.ComponentInterfaceImplementationImplementationChecker;
import com.sap.ide.webdynpro.checklayer.controller.ControllerChecker;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.tc.logging.Location;

public class ComponentInterfaceChecker
extends MDOChecker {
    static ComponentInterfaceChecker mInstance = new ComponentInterfaceChecker();
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$componentif$ComponentInterfaceChecker == null ? (class$com$sap$ide$webdynpro$checklayer$componentif$ComponentInterfaceChecker = ComponentInterfaceChecker.class$("com.sap.ide.webdynpro.checklayer.componentif.ComponentInterfaceChecker")) : class$com$sap$ide$webdynpro$checklayer$componentif$ComponentInterfaceChecker).getName());
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$componentif$ComponentInterfaceChecker;

    public static ComponentInterfaceChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        long startingTime = System.currentTimeMillis();
        if (!(developmentObject instanceof ComponentInterface)) {
            return;
        }
        super.check(developmentObject, fullCheck, checkResult);
        ComponentInterfaceChecker.check((ComponentInterface)developmentObject, fullCheck, checkResult);
        Utils.traceTime(sLocation, developmentObject, startingTime);
    }

    private static void check(ComponentInterface componentInterface, boolean fullCheck, CheckResult checkResult) {
        boolean isImplementation = false;
        if (componentInterface instanceof ComponentInterfaceDefinition) {
            checkResult.addCheckedMDO((MainDevelopmentObject)((ComponentInterfaceDefinition)componentInterface));
        } else if (componentInterface instanceof ComponentInterfaceImplementation) {
            isImplementation = true;
            checkResult.addCheckedMDO((MainDevelopmentObject)((ComponentInterfaceImplementation)componentInterface));
        }
        Controller interfaceController = componentInterface.getInterfaceController();
        Controller configurationController = componentInterface.getConfigurationController();
        if (interfaceController == null) {
            checkResult.addEntry((DevelopmentObject)componentInterface, 0, "", "Interface Controller is missing", "");
        }
        ComponentInterfaceChecker.checkControllerExistence(componentInterface, checkResult);
        if (isImplementation) {
            ComponentInterfaceImplementationImplementationChecker.check((ComponentInterfaceImplementation)componentInterface, fullCheck, checkResult);
        }
        if (!fullCheck) {
            return;
        }
        Controller[] controllers = componentInterface.getControllers();
        int i = 0;
        while (i < controllers.length) {
            ControllerChecker.getInstance().check((DevelopmentObject)controllers[i], true, checkResult);
            ++i;
        }
    }

    static void checkControllerExistence(ComponentInterface componentInterface, CheckResult checkResult) {
        InterfaceView[] interfaceViews = componentInterface.getInterfaceViews();
        int i = 0;
        while (i < interfaceViews.length) {
            InterfaceView interfaceView = interfaceViews[i];
            if (!interfaceView.hasViewController()) {
                String message = "InterfaceView " + interfaceView.getQualifiedName() + " has no controller";
                checkResult.addEntry((DevelopmentObject)componentInterface, 0, "", message, "");
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

