/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.component;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.MDOChecker;
import com.sap.ide.webdynpro.checklayer.componentcontrollerusage.ComponentControllerUsageChecker;
import com.sap.ide.webdynpro.checklayer.componentif.ComponentInterfaceChecker;
import com.sap.ide.webdynpro.checklayer.controller.ControllerChecker;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.ide.webdynpro.checklayer.window.WindowChecker;
import com.sap.tc.logging.Location;

public class ComponentChecker
extends MDOChecker {
    static ComponentChecker mInstance = new ComponentChecker();
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$component$ComponentChecker == null ? (class$com$sap$ide$webdynpro$checklayer$component$ComponentChecker = ComponentChecker.class$("com.sap.ide.webdynpro.checklayer.component.ComponentChecker")) : class$com$sap$ide$webdynpro$checklayer$component$ComponentChecker).getName());
    public static final String NAME_FOR_INTERFACE_CONTROLLER = "Interface";
    public static final String NAME_FOR_CONFIGURATION_CONTROLLER = "Configuration";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$component$ComponentChecker;

    public static ComponentChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        if (!(developmentObject instanceof Component)) {
            return;
        }
        long startingTime = System.currentTimeMillis();
        super.check(developmentObject, fullCheck, checkResult);
        ComponentChecker.check((Component)developmentObject, fullCheck, checkResult);
        Utils.traceTime(sLocation, developmentObject, startingTime);
    }

    static void checkControllerExistence(Component component, CheckResult checkResult) {
        View[] views = component.getViews();
        int i = 0;
        while (i < views.length) {
            View view = views[i];
            if (!view.hasViewController()) {
                String message = "View " + view.getQualifiedName() + " has no controller";
                checkResult.addEntry((DevelopmentObject)component, 0, "", message, "");
            }
            ++i;
        }
    }

    private static void check(Component component, boolean fullCheck, CheckResult checkResult) {
        checkResult.addCheckedMDO((MainDevelopmentObject)component);
        ComponentChecker.checkControllerExistence(component, checkResult);
        if (!component.hasEmptyView()) {
            checkResult.addEntry((DevelopmentObject)component, 0, "", "EmptyView is missing", "Repair Component");
        }
        ComponentInterfaceImplementation componentInterfaceImplementation = component.getComponentInterface();
        Controller componentController = component.getComponentController();
        if (componentInterfaceImplementation == null) {
            checkResult.addEntry((DevelopmentObject)component, 0, "", "Component Interface is missing", "");
        } else if (!componentInterfaceImplementation.hasInterfaceController()) {
            checkResult.addEntry((DevelopmentObject)component, 0, "", "Component Interface has no Interface Controller", "");
        }
        if (componentController == null) {
            checkResult.addEntry((DevelopmentObject)component, 0, "", "Component Controller is missing", "");
        }
        Component[] visitedComponents = new Component[]{component};
        ComponentUsage[] usages = component.getComponentUsages();
        ComponentChecker.checkComponentUsageCycles(visitedComponents, usages, checkResult);
        usages = component.getComponentUsages();
        int i = 0;
        while (i < usages.length) {
            ComponentControllerUsage componentControllerUsage = usages[i].getComponentControllerUsage(NAME_FOR_INTERFACE_CONTROLLER);
            if (componentControllerUsage == null) {
                checkResult.addEntry((DevelopmentObject)component, 0, usages[i].getName(), "Component controller usage for the interface controller is missing.", "Please use 'Repair' on the Web Dynpro Explorer entry for the used Web Dynpro Component (in the tree under 'Used Web Dynpro Components').");
            } else {
                ComponentControllerUsageChecker.check(componentControllerUsage, fullCheck, checkResult);
            }
            componentControllerUsage = usages[i].getComponentControllerUsage(NAME_FOR_CONFIGURATION_CONTROLLER);
            if (componentControllerUsage == null) {
                checkResult.addEntry((DevelopmentObject)component, 0, usages[i].getName(), "Component controller usage for the configuration controller is missing.", "Please use 'Repair' on the Web Dynpro Explorer entry for the used Web Dynpro Component.");
            } else {
                ComponentControllerUsageChecker.check(componentControllerUsage, fullCheck, checkResult);
            }
            ++i;
        }
        Window[] windows = component.getWindows();
        int i2 = 0;
        while (i2 < windows.length) {
            WindowChecker.getInstance().check((DevelopmentObject)windows[i2], true, checkResult);
            ++i2;
        }
        if (!fullCheck) {
            return;
        }
        if (componentInterfaceImplementation != null) {
            ComponentInterfaceChecker.getInstance().check((DevelopmentObject)componentInterfaceImplementation, true, checkResult);
        }
        if (componentController != null) {
            ControllerChecker.getInstance().check((DevelopmentObject)componentController, true, checkResult);
        }
        Controller[] controllers = component.getControllers();
        int i3 = 0;
        while (i3 < controllers.length) {
            if (controllers[i3].getType() == ControllerTypeEnum.CUSTOM) {
                ControllerChecker.getInstance().check((DevelopmentObject)controllers[i3], true, checkResult);
            } else if (controllers[i3].getType() == ControllerTypeEnum.VIEW) {
                ControllerChecker.getInstance().check((DevelopmentObject)controllers[i3], true, checkResult);
            }
            ++i3;
        }
    }

    private static void checkComponentUsageCycles(Component[] visitedComponents, ComponentUsage[] usages, CheckResult checkResult) {
        int i = 0;
        while (i < visitedComponents.length) {
            if (visitedComponents[i] != null) {
                int j = 0;
                while (j < usages.length) {
                    if (usages[j] != null && usages[j].getUsedComponent() != null) {
                        if (visitedComponents[i].equals(usages[j].getUsedComponent().getParent())) {
                            int severity = 0;
                            if (usages[j].getUsedComponent().getParent() != null && usages[j].getUsedComponent().getParent().equals(usages[j].getUsingComponent())) {
                                severity = 1;
                            }
                            checkResult.addEntry((DevelopmentObject)visitedComponents[0], severity, "", "Cycle in component usage definitions: " + usages[j].getUsingComponent().getName(), "");
                            return;
                        }
                    } else {
                        String usageName = "<ERROR>";
                        if (usages[j] != null) {
                            usageName = usages[j].getName();
                        }
                        checkResult.addEntry((DevelopmentObject)visitedComponents[0], 0, "", "Has invalid component usage '" + usageName + "'", "");
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < usages.length) {
            if (usages[i2].getUsedComponent() != null && usages[i2].getUsedComponent() instanceof ComponentInterfaceImplementation && !usages[i2].getUsedComponent().originatesInArchive()) {
                Component[] newVisitedComponents = new Component[visitedComponents.length + 1];
                int j = 0;
                while (j < visitedComponents.length) {
                    newVisitedComponents[j] = visitedComponents[j];
                    ++j;
                }
                newVisitedComponents[visitedComponents.length] = (Component)usages[i2].getUsedComponent().getParent();
                ComponentUsage[] newUsages = ((Component)usages[i2].getUsedComponent().getParent()).getComponentUsages();
                ComponentChecker.checkComponentUsageCycles(newVisitedComponents, newUsages, checkResult);
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

