/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.application;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinitionSet;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.MDOChecker;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.tc.logging.Location;

public class ApplicationChecker
extends MDOChecker {
    public static final String STANDARD_APPLICATION_PROPERTY_DEFINITION_SET_NAME = "Standard";
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$application$ApplicationChecker == null ? (class$com$sap$ide$webdynpro$checklayer$application$ApplicationChecker = ApplicationChecker.class$("com.sap.ide.webdynpro.checklayer.application.ApplicationChecker")) : class$com$sap$ide$webdynpro$checklayer$application$ApplicationChecker).getName());
    private static ApplicationChecker mInstance = null;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$application$ApplicationChecker;

    public static ApplicationChecker getInstance() {
        if (mInstance == null) {
            mInstance = new ApplicationChecker();
        }
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        long startingTime = System.currentTimeMillis();
        if (!(developmentObject instanceof Application)) {
            return;
        }
        super.check(developmentObject, fullCheck, checkResult);
        ApplicationChecker.check((Application)developmentObject, fullCheck, checkResult);
        Utils.traceTime(sLocation, developmentObject, startingTime);
    }

    private static void check(Application application, boolean fullCheck, CheckResult checkResult) {
        checkResult.addCheckedMDO((MainDevelopmentObject)application);
        if (application.getComponent() == null) {
            checkResult.addEntry((DevelopmentObject)application, 0, "", "Component is missing", "");
        }
        if (application.getStartupPlug() == null) {
            checkResult.addEntry((DevelopmentObject)application, 0, "", "Startup plug is missing", "");
        }
        ApplicationPropertyDefinitionSet[] definitionSets = application.getPropertyDefinitionSets();
        int i = 0;
        while (i < definitionSets.length) {
            ApplicationPropertyDefinition[] definitions = definitionSets[i].getPropertyDefinitions();
            int j = 0;
            while (j < definitions.length) {
                if (definitions[j].getIsMandatory() && !application.hasApplicationProperty(definitions[j].getQualifiedName())) {
                    checkResult.addEntry((DevelopmentObject)application, 0, definitions[j].getName(), "Mandatory application property '" + definitions[j].getQualifiedName() + "' is missing", "");
                }
                ++j;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

