/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.DefaultLogger;
import com.sapportals.portal.transport.ILogger;
import java.util.Hashtable;

public abstract class Logger {
    protected static final String PRT_LOGGER_CLASS = "com.sapportals.portal.transport.PrtLogger";
    protected static final String PCDSTANDALONE_LOGGER_CLASS = "com.sapportals.portal.transport.PcdStandaloneLogger";
    protected static final int MSG_BUFSIZE = 200;
    protected static final String DEFAULT_LOGGER_NAME = "__DEFAULT__";
    protected static Hashtable loggerInstances = new Hashtable();
    protected StringBuffer msgBuffer = new StringBuffer(200);
    protected int classNameLength = 0;
    static /* synthetic */ Class class$com$sapportals$portal$transport$Logger;

    public static synchronized ILogger getLogger() {
        Logger logger = (Logger)loggerInstances.get(DEFAULT_LOGGER_NAME);
        if (logger == null) {
            logger = Logger.getNewLoggerInstance();
            loggerInstances.put(DEFAULT_LOGGER_NAME, logger);
        }
        return (ILogger)((Object)logger);
    }

    public static synchronized ILogger getLogger(String aClassName) {
        Logger logger = (Logger)loggerInstances.get(aClassName);
        if (logger == null) {
            logger = Logger.getNewLoggerInstance();
            logger.setClassName(aClassName);
            loggerInstances.put(aClassName, logger);
        }
        return (ILogger)((Object)logger);
    }

    protected static Logger getNewLoggerInstance() {
        Class<?> implClass = null;
        try {
            implClass = Class.forName(PRT_LOGGER_CLASS);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (implClass == null) {
            try {
                implClass = Class.forName(PCDSTANDALONE_LOGGER_CLASS);
            }
            catch (ClassNotFoundException ex2) {
                // empty catch block
            }
        }
        if (implClass != null) {
            try {
                return (Logger)implClass.newInstance();
            }
            catch (Exception ex) {
                System.err.println("[" + (class$com$sapportals$portal$transport$Logger == null ? (class$com$sapportals$portal$transport$Logger = Logger.class$("com.sapportals.portal.transport.Logger")) : class$com$sapportals$portal$transport$Logger).getName() + ":findLoggerImpl] failed to instantiate logger implementation class " + implClass.getName() + ":");
                ex.printStackTrace();
            }
        }
        return new DefaultLogger();
    }

    protected Logger() {
    }

    protected void setClassName(String aClassName) {
        this.msgBuffer.append(" [").append(aClassName).append("] ");
        this.classNameLength = this.msgBuffer.length();
    }

    protected String getCompleteMsg(String aMsg) {
        String completeMsg;
        StringBuffer stringBuffer = this.msgBuffer;
        synchronized (stringBuffer) {
            this.msgBuffer.append(aMsg);
            completeMsg = this.msgBuffer.toString();
            this.msgBuffer.setLength(this.classNameLength);
        }
        return completeMsg;
    }

    protected String getCompleteMsg(String aMethodName, String aMsg) {
        String completeMsg;
        StringBuffer stringBuffer = this.msgBuffer;
        synchronized (stringBuffer) {
            this.msgBuffer.append(aMethodName).append(":").append(aMsg);
            completeMsg = this.msgBuffer.toString();
            this.msgBuffer.setLength(this.classNameLength);
        }
        return completeMsg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

