/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.EptCatalogHandler;
import com.sapportals.portal.transport.EptEntryOutputStream;
import com.sapportals.portal.transport.EptManifest;
import com.sapportals.portal.transport.EptObjectDescriptorHandler;
import com.sapportals.portal.transport.IEptFileConstants;
import com.sapportals.portal.transport.IObjectDescriptor;
import com.sapportals.portal.transport.ITransportDataOutput;
import com.sapportals.portal.transport.TransportDataEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EptOutput
implements ITransportDataOutput,
IEptFileConstants {
    private ZipOutputStream zipOs;
    private boolean isClosed = false;
    private boolean isFinished = false;
    private IObjectDescriptor objectDescriptor;
    private EptObjectDescriptorHandler odHandler;
    private EptCatalogHandler catalogHandler;

    public EptOutput(OutputStream aOutputStream, IObjectDescriptor aObjectDescriptor) throws IOException {
        Manifest eptManifest = null;
        Manifest ocManifest = aObjectDescriptor.getManifest();
        eptManifest = ocManifest == null ? new EptManifest() : (ocManifest instanceof EptManifest ? ocManifest : new EptManifest(ocManifest));
        this.zipOs = new JarOutputStream(aOutputStream, eptManifest);
        this.objectDescriptor = aObjectDescriptor;
        this.catalogHandler = new EptCatalogHandler();
        this.odHandler = new EptObjectDescriptorHandler(aObjectDescriptor);
    }

    private EptOutput() {
    }

    public OutputStream putNextEntry(TransportDataEntry aDataEntry) throws IOException {
        this.ensureOpen();
        this.catalogHandler.addEntry(aDataEntry);
        return new EptEntryOutputStream(this.zipOs, aDataEntry);
    }

    public void finish() throws IOException {
        if (this.isFinished) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry("TRANSPORT-INF/ObjectDescriptor.properties");
        this.zipOs.putNextEntry(zipEntry);
        this.odHandler.write(this.zipOs);
        this.zipOs.closeEntry();
        zipEntry = new ZipEntry("TRANSPORT-INF/Catalog");
        this.zipOs.putNextEntry(zipEntry);
        this.catalogHandler.writeCatalog(this.zipOs);
        this.zipOs.closeEntry();
        this.zipOs.finish();
        this.isFinished = true;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (!this.isFinished) {
            this.finish();
        }
        this.zipOs.close();
        this.isClosed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed.");
        }
        if (this.isFinished) {
            throw new IOException("Stream finished.");
        }
    }
}

