/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.BasicObjectDescriptor;
import com.sapportals.portal.transport.IObjectDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class EptObjectDescriptorHandler {
    private BasicObjectDescriptor objectDescriptor = null;

    public EptObjectDescriptorHandler() {
    }

    public EptObjectDescriptorHandler(IObjectDescriptor aObjectDescriptor) {
        this.objectDescriptor = aObjectDescriptor instanceof BasicObjectDescriptor ? (BasicObjectDescriptor)aObjectDescriptor : new BasicObjectDescriptor(aObjectDescriptor);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.objectDescriptor == null) {
            throw new IllegalStateException("EptObjectDescriptorHandler: must be initialized with non-null object descriptor before calling write()");
        }
        Properties properties = new Properties();
        Enumeration keys = this.objectDescriptor.getKeys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            properties.setProperty(key, this.objectDescriptor.getValue(key));
        }
        properties.store(outputStream, "EPT Object Descriptor");
    }

    public BasicObjectDescriptor read(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        BasicObjectDescriptor anObjectDescriptor = new BasicObjectDescriptor();
        Enumeration keys = ((Hashtable)properties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            anObjectDescriptor.setValue(key, properties.getProperty(key));
        }
        this.objectDescriptor = anObjectDescriptor;
        return anObjectDescriptor;
    }
}

