/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.ILogger;
import com.sapportals.portal.transport.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class EptManifest
extends Manifest {
    private static ILogger logger = Logger.getLogger((class$com$sapportals$portal$transport$EptManifest == null ? (class$com$sapportals$portal$transport$EptManifest = EptManifest.class$("com.sapportals.portal.transport.EptManifest")) : class$com$sapportals$portal$transport$EptManifest).getName());
    public static final String CREATION_DATE = "Creation-Date";
    public static final String CREATION_TIME = "Creation-Time";
    public static final String CREATION_TIMEZONE = "Creation-TimeZone";
    public static final String CREATED_BY = "Created-By";
    public static final String BASICTRANSPORT_VERSION = "BasicTransport-Version";
    public static final String JAVA_VERSION = "Java-Version";
    public static final String JAVA_VM = "Java-VM";
    public static final String OS_NAME = "OS-Name";
    private static final DateFormat DATE_DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat TIME_DATEFORMAT = new SimpleDateFormat("HHmmss");
    private static final DateFormat DATETIME_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String VAL_JAVA_VERSION = System.getProperty("java.version", "");
    private static final String VAL_JAVA_VM;
    private static final String VAL_OS_NAME;
    private static final NumberFormat TZ_HOURS_NUMBERFORMAT;
    private static final NumberFormat TZ_MINUTES_NUMBERFORMAT;
    static /* synthetic */ Class class$com$sapportals$portal$transport$EptManifest;

    public EptManifest() {
        this.addEptManifestAttributes(this.getMainAttributes());
    }

    public EptManifest(InputStream aInputStream) throws IOException {
        super(aInputStream);
    }

    public EptManifest(Manifest aManifest) {
        super(aManifest);
        this.addEptManifestAttributes(this.getMainAttributes());
    }

    private void addEptManifestAttributes(Attributes theAttributes) {
        theAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Date now = new Date();
        theAttributes.putValue(CREATION_DATE, DATE_DATEFORMAT.format(now));
        theAttributes.putValue(CREATION_TIME, TIME_DATEFORMAT.format(now));
        Calendar calendarNow = Calendar.getInstance();
        calendarNow.setTime(now);
        String timeZoneString = EptManifest.timeZoneToString(TimeZone.getDefault(), calendarNow);
        theAttributes.putValue(CREATION_TIMEZONE, timeZoneString);
        String basicTransportVersion = this.getBasicTransportVersion();
        if (basicTransportVersion != null) {
            theAttributes.putValue(BASICTRANSPORT_VERSION, basicTransportVersion);
        }
        theAttributes.putValue(CREATED_BY, "Portal Export");
        theAttributes.putValue(JAVA_VERSION, VAL_JAVA_VERSION);
        theAttributes.putValue(JAVA_VM, VAL_JAVA_VM);
        theAttributes.putValue(OS_NAME, VAL_OS_NAME);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getBasicTransportVersion() {
        InputStream is;
        String basicTransportVersion;
        block9: {
            Manifest mf;
            Attributes mainAttributes;
            basicTransportVersion = null;
            Package basicTransportPackage = this.getClass().getPackage();
            if (basicTransportPackage != null) {
                basicTransportVersion = basicTransportPackage.getImplementationVersion();
                if (!logger.isDebug()) return basicTransportVersion;
                logger.fine("Got basictransport version from package: " + basicTransportVersion);
                return basicTransportVersion;
            }
            is = null;
            is = this.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
            if (is == null || (mainAttributes = (mf = new Manifest(is)).getMainAttributes()) == null) break block9;
            basicTransportVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            if (!logger.isDebug()) break block9;
            logger.fine("Got basictransport version from manifest: " + basicTransportVersion);
        }
        Object var7_7 = null;
        if (is == null) return basicTransportVersion;
        try {
            is.close();
            return basicTransportVersion;
        }
        catch (IOException ioEx) {
            logger.warning("getBasicTransportVersion(): could not close stream of manifest.", ioEx);
        }
        return basicTransportVersion;
        {
            catch (IOException ex) {
                logger.warning("Failed to read basictransport version from manifest.", ex);
                Object var7_8 = null;
                if (is == null) return basicTransportVersion;
                try {
                    is.close();
                    return basicTransportVersion;
                }
                catch (IOException ioEx) {
                    logger.warning("getBasicTransportVersion(): could not close stream of manifest.", ioEx);
                }
                return basicTransportVersion;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioEx) {
                logger.warning("getBasicTransportVersion(): could not close stream of manifest.", ioEx);
            }
            throw throwable;
        }
    }

    private static String timeZoneToString(TimeZone aTimeZone, Calendar aCalendar) {
        StringBuffer sb = new StringBuffer(100);
        TimeZone tz = null;
        tz = aTimeZone == null ? TimeZone.getDefault() : aTimeZone;
        String tzId = tz.getID();
        if (tzId != null) {
            sb.append(tzId);
            sb.append(" ");
        }
        int offsetMillis = tz.getOffset(aCalendar.get(0), aCalendar.get(1), aCalendar.get(2), aCalendar.get(5), aCalendar.get(7), EptManifest.getMillisInDay(aCalendar));
        int offsetHours = offsetMillis / 3600000;
        int offsetMinutes = offsetMillis % 3600000 / 60000;
        sb.append("[GMT");
        sb.append(TZ_HOURS_NUMBERFORMAT.format(offsetHours));
        if (offsetMinutes > 0) {
            sb.append(":");
            sb.append(TZ_MINUTES_NUMBERFORMAT.format(offsetMinutes));
        }
        sb.append("]");
        return sb.toString();
    }

    private static int getMillisInDay(Calendar aCalendar) {
        return aCalendar.get(11) * 3600000 + aCalendar.get(12) * 60000 + aCalendar.get(13) * 1000 + aCalendar.get(14);
    }

    public static void main(String[] args) {
        TimeZone defaultTz = TimeZone.getDefault();
        Calendar now = Calendar.getInstance();
        Calendar summerDay = Calendar.getInstance();
        summerDay.set(1, 2003);
        summerDay.set(2, 6);
        summerDay.set(5, 1);
        Calendar winterDay = Calendar.getInstance();
        winterDay.set(1, 2003);
        winterDay.set(2, 10);
        winterDay.set(5, 24);
        System.out.println("Default timezone: " + defaultTz.toString());
        System.out.print("Timezone for summer day: ");
        System.out.println(EptManifest.timeZoneToString(defaultTz, summerDay));
        System.out.print("Timezone for winter day: ");
        System.out.println(EptManifest.timeZoneToString(defaultTz, winterDay));
        System.out.println();
        System.out.println();
        String[] availableTimeZoneIds = TimeZone.getAvailableIDs();
        int i = 0;
        while (i < availableTimeZoneIds.length) {
            TimeZone tz = TimeZone.getTimeZone(availableTimeZoneIds[i]);
            System.out.println("------  Timezone: " + tz.toString() + " ------------");
            System.out.print("Timezone for summer day: ");
            System.out.println(EptManifest.timeZoneToString(tz, summerDay));
            System.out.print("Timezone for winter day: ");
            System.out.println(EptManifest.timeZoneToString(tz, winterDay));
            System.out.println();
            System.out.println();
            ++i;
        }
        System.out.println();
        System.out.println("Parse test for non-existing TZ:");
        TimeZone gibtsnet = TimeZone.getTimeZone("XXXXX");
        System.out.println(gibtsnet);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sb = new StringBuffer(200);
        sb.append(System.getProperty("java.vm.name", ""));
        sb.append(" (");
        sb.append(System.getProperty("java.vm.version", ""));
        sb.append(") ");
        sb.append(System.getProperty("java.vm.vendor", ""));
        VAL_JAVA_VM = sb.toString();
        sb.setLength(0);
        sb.append(System.getProperty("os.name", ""));
        sb.append(" (");
        sb.append(System.getProperty("os.version", ""));
        sb.append(") ");
        sb.append(System.getProperty("os.arch", ""));
        VAL_OS_NAME = sb.toString();
        Object var0 = null;
        TZ_HOURS_NUMBERFORMAT = new DecimalFormat("+00;-00");
        TZ_MINUTES_NUMBERFORMAT = new DecimalFormat("00");
    }
}

