/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.BasicObjectDescriptor;
import com.sapportals.portal.transport.EptCatalogHandler;
import com.sapportals.portal.transport.EptEntry;
import com.sapportals.portal.transport.EptObjectDescriptorHandler;
import com.sapportals.portal.transport.IEptFileConstants;
import com.sapportals.portal.transport.ILogger;
import com.sapportals.portal.transport.IObjectDescriptor;
import com.sapportals.portal.transport.ITransportDataInput;
import com.sapportals.portal.transport.Logger;
import com.sapportals.portal.transport.SystemAccessControlException;
import com.sapportals.portal.transport.TransportDataEntry;
import com.sapportals.portal.transport.TransportFileException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class EptFile
implements ITransportDataInput,
IEptFileConstants {
    private static final String CLASSNAME = "[" + (class$com$sapportals$portal$transport$EptFile == null ? (class$com$sapportals$portal$transport$EptFile = EptFile.class$("com.sapportals.portal.transport.EptFile")) : class$com$sapportals$portal$transport$EptFile).getName() + "]";
    private static ILogger logger = Logger.getLogger((class$com$sapportals$portal$transport$EptFile == null ? (class$com$sapportals$portal$transport$EptFile = EptFile.class$("com.sapportals.portal.transport.EptFile")) : class$com$sapportals$portal$transport$EptFile).getName());
    private JarFile jarFile;
    private File file;
    private boolean isClosed;
    private boolean isInitialized;
    private List entryList;
    private Map entryMap;
    private BasicObjectDescriptor objectDescriptor;
    static /* synthetic */ Class class$com$sapportals$portal$transport$EptFile;

    public EptFile(File aEptFile) throws IOException {
        try {
            if (!aEptFile.exists()) {
                throw new FileNotFoundException(CLASSNAME + "<init>: transport file not found: " + aEptFile);
            }
            if (!aEptFile.canRead()) {
                throw new TransportFileException(CLASSNAME + "<init>: cannot read file: " + aEptFile);
            }
        }
        catch (SecurityException sEx) {
            throw new SystemAccessControlException(CLASSNAME + "<init>: access to transport file " + aEptFile + " denied by security manager.", (Throwable)sEx);
        }
        this.file = aEptFile;
        this.isClosed = false;
        this.isInitialized = false;
        this.entryList = null;
        this.entryMap = null;
        this.objectDescriptor = null;
    }

    private EptFile() {
    }

    public TransportDataEntry getEntry(String aEntryName) throws IOException {
        this.ensureOpen();
        return (TransportDataEntry)this.entryMap.get(aEntryName);
    }

    public List getEntryList() throws IOException {
        this.ensureOpen();
        return this.entryList;
    }

    public InputStream getInputStream(TransportDataEntry aDataEntry) throws IOException {
        this.ensureOpen();
        EptEntry eptEntry = null;
        if (aDataEntry instanceof EptEntry) {
            eptEntry = (EptEntry)aDataEntry;
        } else {
            eptEntry = this.getEptEntry(aDataEntry.getName());
            if (eptEntry == null) {
                throw new TransportFileException(CLASSNAME + "getInputStream(): data entry not found: " + aDataEntry.getName());
            }
        }
        return this.jarFile.getInputStream(eptEntry.getZipEntry());
    }

    public String getName() {
        return this.file.getName();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.entryList = null;
            this.entryMap = null;
            this.objectDescriptor = null;
            if (this.jarFile != null) {
                this.jarFile.close();
                this.jarFile = null;
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new TransportFileException("Transport file " + this.getAbsolutePath() + " is already closed.");
        }
        if (!this.isInitialized) {
            this.init();
        }
    }

    private void init() throws IOException {
        Manifest manifest;
        try {
            this.jarFile = new JarFile(this.file, false);
        }
        catch (SecurityException sEx) {
            throw new SystemAccessControlException(CLASSNAME + "<init>: access to transport file " + this.file + " denied by security manager.", (Throwable)sEx);
        }
        EptObjectDescriptorHandler ocHandler = new EptObjectDescriptorHandler();
        ZipEntry zipEntry = this.jarFile.getEntry("TRANSPORT-INF/ObjectDescriptor.properties");
        if (zipEntry == null) {
            throw new TransportFileException(CLASSNAME + "init(): object descriptor entry " + "TRANSPORT-INF/ObjectDescriptor.properties" + " missing in transport file: " + this.getAbsolutePath());
        }
        InputStream is = null;
        try {
            is = this.jarFile.getInputStream(zipEntry);
            this.objectDescriptor = ocHandler.read(is);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            block20: {
                Object var5_6 = null;
                try {
                    is.close();
                }
                catch (IOException ioEx) {
                    if (!logger.isWarning()) break block20;
                    logger.warning("Failed to close object descriptor entry TRANSPORT-INF/ObjectDescriptor.properties in file " + this.getAbsolutePath(), ioEx);
                }
            }
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException ioEx) {
            if (logger.isWarning()) {
                logger.warning("Failed to close object descriptor entry TRANSPORT-INF/ObjectDescriptor.properties in file " + this.getAbsolutePath(), ioEx);
            }
        }
        if ((manifest = this.jarFile.getManifest()) != null) {
            this.objectDescriptor.setManifest(manifest);
            if (logger.isDebug()) {
                logger.fine("init(): got manifest file.");
            }
        }
        EptCatalogHandler catalogHandler = new EptCatalogHandler();
        zipEntry = this.jarFile.getEntry("TRANSPORT-INF/Catalog");
        if (zipEntry == null) {
            throw new TransportFileException(CLASSNAME + "init(): catalog entry " + "TRANSPORT-INF/Catalog" + " missing in transport file: " + this.getAbsolutePath());
        }
        try {
            is = this.jarFile.getInputStream(zipEntry);
            catalogHandler.readCatalog(is);
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            block22: {
                Object var8_12 = null;
                try {
                    is.close();
                }
                catch (IOException ioEx) {
                    if (!logger.isWarning()) break block22;
                    logger.warning("Failed to close catalog entry TRANSPORT-INF/Catalog in file " + this.getAbsolutePath(), ioEx);
                }
            }
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException ioEx) {
            if (logger.isWarning()) {
                logger.warning("Failed to close catalog entry TRANSPORT-INF/Catalog in file " + this.getAbsolutePath(), ioEx);
            }
        }
        int entrySize = this.jarFile.size();
        this.entryList = new ArrayList(entrySize);
        this.entryMap = new HashMap(entrySize);
        String entryName = null;
        EptEntry eptEntry = null;
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            entryName = zipEntry.getName();
            if (entryName.startsWith("META-INF") || entryName.startsWith("TRANSPORT-INF")) continue;
            eptEntry = new EptEntry(zipEntry);
            eptEntry.setQualifier(catalogHandler.getQualifier(entryName));
            this.entryList.add(eptEntry);
            this.entryMap.put(entryName, eptEntry);
        }
        this.isInitialized = true;
    }

    protected EptEntry getEptEntry(String aEntryName) throws IOException {
        return (EptEntry)this.getEntry(aEntryName);
    }

    public IObjectDescriptor getObjectDescriptor() throws IOException {
        this.ensureOpen();
        return this.objectDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

