/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.TransportDataEntry;
import com.sapportals.portal.transport.TransportFileException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EptEntryOutputStream
extends OutputStream {
    private ZipOutputStream zipOs;
    private boolean isClosed;

    private EptEntryOutputStream() {
    }

    public EptEntryOutputStream(ZipOutputStream aZipOutputStream, TransportDataEntry aDataEntry) throws IOException {
        this.zipOs = aZipOutputStream;
        this.zipOs.putNextEntry(this.createZipEntry(aDataEntry));
        this.isClosed = false;
    }

    public void write(int b) throws IOException {
        this.ensureOpen();
        this.zipOs.write(b);
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.zipOs.closeEntry();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        this.zipOs.write(b, off, len);
    }

    private void ensureOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed.");
        }
    }

    private ZipEntry createZipEntry(TransportDataEntry aDataEntry) throws IOException {
        try {
            ZipEntry zipEntry = new ZipEntry(aDataEntry.getName());
            return zipEntry;
        }
        catch (Exception ex) {
            throw new TransportFileException("Failed to create ZIP entry for data entry " + aDataEntry.getName());
        }
    }
}

