/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.TransportDataEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EptCatalogHandler {
    protected static final int INITIAL_LIST_CAPACITY = 20;
    private static final int STRINGBUFFER_SIZE = 100;
    public static final String EPT_DELIM = "|_EPT_|";
    public static final String EPT_CATALOG_ENCODING = "UTF-8";
    protected static final char NEWLINE = '\n';
    private List dataEntries = new ArrayList(20);
    private Map nameQualifierMap = new HashMap();

    public void addEntry(TransportDataEntry aDataEntry) {
        this.dataEntries.add(aDataEntry);
        this.nameQualifierMap.put(aDataEntry.getName(), aDataEntry.getQualifier());
    }

    public Iterator getEntryNames() {
        return this.nameQualifierMap.keySet().iterator();
    }

    public String getQualifier(String aEntryName) {
        return (String)this.nameQualifierMap.get(aEntryName);
    }

    public void writeCatalog(OutputStream outputStream) throws IOException, UnsupportedEncodingException {
        OutputStreamWriter osWriter = new OutputStreamWriter(outputStream, EPT_CATALOG_ENCODING);
        StringBuffer sb = new StringBuffer(100);
        char[] charBuffer = new char[100];
        String name = null;
        String qualifier = null;
        Iterator it = this.dataEntries.iterator();
        while (it.hasNext()) {
            TransportDataEntry entry = (TransportDataEntry)it.next();
            name = entry.getName();
            qualifier = entry.getQualifier();
            sb.append(name);
            if (qualifier != null) {
                sb.append(EPT_DELIM).append(qualifier);
            }
            sb.append('\n');
            if (sb.length() > charBuffer.length) {
                charBuffer = new char[sb.length()];
            }
            sb.getChars(0, sb.length(), charBuffer, 0);
            osWriter.write(charBuffer, 0, sb.length());
            sb.setLength(0);
        }
        sb = null;
        charBuffer = null;
        osWriter.flush();
    }

    public void readCatalog(InputStream anInputStream) throws IOException {
        InputStreamReader isReader = new InputStreamReader(anInputStream, EPT_CATALOG_ENCODING);
        LineNumberReader lineNumberReader = new LineNumberReader(isReader);
        String currentLine = null;
        int beginIdx = 0;
        int endIdx = 0;
        String entryName = null;
        String qualifier = null;
        while ((currentLine = lineNumberReader.readLine()) != null) {
            endIdx = currentLine.indexOf(EPT_DELIM);
            if (endIdx <= 0) {
                entryName = currentLine;
            } else {
                entryName = currentLine.substring(0, endIdx);
                beginIdx = endIdx + EPT_DELIM.length();
                if (beginIdx < currentLine.length()) {
                    qualifier = currentLine.substring(beginIdx);
                }
            }
            this.nameQualifierMap.put(entryName, qualifier);
            qualifier = null;
        }
    }
}

