/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.transport;

import com.sapportals.portal.transport.ILogger;
import com.sapportals.portal.transport.Logger;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultLogger
extends Logger
implements ILogger {
    public static final String LOGLEVEL_PROPERTY = "com.sapportals.portal.transport.DefaultLogger.Level";
    public static final int LEVEL_OFF = 0;
    public static final int LEVEL_SEVERE = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_FINE = 4;
    public static final int LEVEL_ALL = 5;
    public static final String LEVEL_NAME_OFF = "OFF";
    public static final String LEVEL_NAME_SEVERE = "SEVERE";
    public static final String LEVEL_NAME_WARNING = "WARNING";
    public static final String LEVEL_NAME_INFO = "INFO";
    public static final String LEVEL_NAME_FINE = "FINE";
    public static final String LEVEL_NAME_DEBUG = "DEBUG";
    public static final String LEVEL_NAME_ALL = "ALL";
    protected static final DateFormat DEFAULT_DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected int currentLevel;

    public DefaultLogger() {
        String levelName = System.getProperty(LOGLEVEL_PROPERTY);
        if (levelName != null) {
            if (levelName.equalsIgnoreCase(LEVEL_NAME_OFF)) {
                this.currentLevel = 0;
            } else if (levelName.equalsIgnoreCase(LEVEL_NAME_SEVERE)) {
                this.currentLevel = 1;
            } else if (levelName.equalsIgnoreCase(LEVEL_NAME_WARNING)) {
                this.currentLevel = 2;
            } else if (levelName.equalsIgnoreCase(LEVEL_NAME_INFO)) {
                this.currentLevel = 3;
            } else if (levelName.equalsIgnoreCase(LEVEL_NAME_FINE) || levelName.equalsIgnoreCase(LEVEL_NAME_DEBUG)) {
                this.currentLevel = 4;
            } else if (levelName.equalsIgnoreCase(LEVEL_NAME_ALL)) {
                this.currentLevel = 5;
            }
        } else {
            this.currentLevel = 1;
        }
    }

    public boolean isInfo() {
        return this.currentLevel >= 3;
    }

    public boolean isDebug() {
        return this.currentLevel >= 4;
    }

    public boolean isWarning() {
        return this.currentLevel >= 2;
    }

    public boolean isSevere() {
        return this.currentLevel >= 1;
    }

    public void info(String aMsg) {
        this.log(3, aMsg);
    }

    public void warning(String aMsg) {
        this.log(2, aMsg);
    }

    public void warning(String aMsg, Throwable aThrowable) {
        this.log(2, aMsg, aThrowable);
    }

    public void severe(String aMsg) {
        this.log(1, aMsg);
    }

    public void severe(String aMsg, Throwable aThrowable) {
        this.log(1, aMsg, aThrowable);
    }

    public void fine(String aMsg) {
        this.log(4, aMsg);
    }

    public void throwing(String aMsg, Throwable aThrowable) {
        this.log(4, aMsg, aThrowable);
    }

    public void entering(String aMethodName) {
        this.log(4, "Entering method", aMethodName);
    }

    public void exiting(String aMethodName) {
        this.log(4, "Exiting method", aMethodName);
    }

    protected String getCompleteMsg(String aMsg) {
        String completeMsg;
        String timeStamp = DEFAULT_DATEFORMAT.format(new Date());
        String threadId = Thread.currentThread().toString();
        StringBuffer stringBuffer = this.msgBuffer;
        synchronized (stringBuffer) {
            this.msgBuffer.append(" ").append(timeStamp).append("  ").append(threadId).append(":").append(aMsg);
            completeMsg = this.msgBuffer.toString();
            this.msgBuffer.setLength(this.classNameLength);
        }
        return completeMsg;
    }

    protected String getCompleteMsg(String aMethodName, String aMsg) {
        String completeMsg;
        String timeStamp = DEFAULT_DATEFORMAT.format(new Date());
        String threadId = Thread.currentThread().toString();
        StringBuffer stringBuffer = this.msgBuffer;
        synchronized (stringBuffer) {
            this.msgBuffer.append(" ").append(timeStamp).append("  ").append(threadId).append(":").append(aMethodName).append(":").append(aMsg);
            completeMsg = this.msgBuffer.toString();
            this.msgBuffer.setLength(this.classNameLength);
        }
        return completeMsg;
    }

    public void log(int aLevel, String aMsg) {
        if (aLevel <= this.currentLevel) {
            System.err.println(this.getCompleteMsg(aMsg));
        }
    }

    public void log(int aLevel, String aMsg, Throwable aThrowable) {
        if (aLevel <= this.currentLevel) {
            String completeMsg = this.getCompleteMsg(aMsg);
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(completeMsg);
                aThrowable.printStackTrace(System.err);
            }
        }
    }

    public void log(int aLevel, String aMethodName, String aMsg) {
        if (aLevel <= this.currentLevel) {
            System.err.println(this.getCompleteMsg(aMethodName, aMsg));
        }
    }
}

