/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xslt.QName;

public final class DTMToDocHandler {
    private DTM dtm;
    private DocHandler h;

    public void process(DTM dtm, DocHandler h) throws Exception {
        this.dtm = dtm;
        h.startDocument();
        this.process(0);
        h.endDocument();
    }

    private void process(int x) throws Exception {
        byte t = this.dtm.nodeType[x];
        switch (t) {
            case 1: {
                QName q = this.dtm.name[x];
                this.h.startElementStart(q.uri, q.localname, q.rawname);
                ++x;
                while (x < this.dtm.size && (this.dtm.nodeType[x] == 2 || this.dtm.nodeType[x] == 13)) {
                    QName q2 = this.dtm.name[x];
                    this.h.addAttribute(q2.uri, q2.prefix, q2.localname, q2.rawname, null, this.dtm.getStringValue(x));
                    ++x;
                }
                this.h.startElementEnd(false);
                int y = this.dtm.firstChild[x];
                while (y != -1) {
                    this.process(y);
                    y = this.dtm.nextSibling[y];
                }
                this.h.endElement(q.uri, q.localname, q.rawname, false);
                return;
            }
            case 8: {
                this.h.onComment(this.dtm.getStringValue(x));
                return;
            }
            case 9: 
            case 11: {
                this.process(x + 1);
                return;
            }
            case 7: {
                this.h.onPI(this.dtm.name[x].rawname, this.dtm.getStringValue(x));
                return;
            }
            case 3: {
                this.h.charData(this.dtm.getStringValue(x), false);
                return;
            }
        }
        throw new RuntimeException("");
    }
}

