/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms;

import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;

public class AES_Transporter
extends KeyTransporter {
    public String algorithmURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    static byte[] testIV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90, -90};

    public AES_Transporter() {
    }

    public AES_Transporter(String algorithm) {
        this.algorithmURI = algorithm;
    }

    public byte[] encrypt(Key wrapping, Key wrapped) throws SignatureException {
        Cipher cipher = null;
        try {
            try {
                cipher = SignatureContext.getCryptographicPool().getCipherFromPool(Configurator.getCipherAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
                cipher.init(3, wrapping);
                byte[] B = new byte[16];
                byte[] encoded = wrapped.getEncoded();
                byte[] result = new byte[encoded.length + 8];
                Arrays.fill(B, 0, 8, (byte)-90);
                if (encoded.length % 8 != 0 || 6 * encoded.length > 255) {
                    throw new SignatureException("Not supported wrapping size:" + result.length);
                }
                System.arraycopy(encoded, 0, result, 8, encoded.length);
                int t = 0;
                int N = encoded.length / 8;
                int j = 0;
                while (j <= 5) {
                    int startIndex = 8;
                    int i = 1;
                    while (i <= N) {
                        t = (byte)(t + 1);
                        System.arraycopy(result, startIndex, B, 8, 8);
                        cipher.update(B, 0, 16, B, 0);
                        B[7] = (byte)(B[7] ^ t);
                        System.arraycopy(B, 8, result, startIndex, 8);
                        startIndex += 8;
                        ++i;
                    }
                    ++j;
                }
                System.arraycopy(B, 0, result, 0, 8);
                byte[] byArray = result;
                Object var13_15 = null;
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                return byArray;
            }
            catch (SignatureException sig) {
                throw sig;
            }
            catch (Exception ex) {
                throw new SignatureException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            SignatureContext.getCryptographicPool().releaseCipher(cipher);
            throw throwable;
        }
    }

    public byte[] decrypt(Key wrapping, byte[] wrapped) throws SignatureException {
        Cipher cipher = null;
        try {
            try {
                cipher = SignatureContext.getCryptographicPool().getCipherFromPool(Configurator.getCipherAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
                cipher.init(4, wrapping);
                byte[] B = new byte[16];
                byte[] result = new byte[wrapped.length - 8];
                if (result.length % 8 != 0 || 6 * result.length > 255) {
                    throw new SignatureException("Not supported wrapping size:" + result.length);
                }
                int N = result.length / 8;
                byte t = (byte)(6 * N);
                System.arraycopy(wrapped, 0, B, 0, 8);
                int j = 5;
                while (j >= 0) {
                    int startIndex = 8 * N;
                    int i = N;
                    while (i > 0) {
                        B[7] = (byte)(B[7] ^ t);
                        System.arraycopy(wrapped, startIndex, B, 8, 8);
                        cipher.update(B, 0, 16, B, 0);
                        System.arraycopy(B, 8, wrapped, startIndex, 8);
                        startIndex -= 8;
                        t = (byte)(t - 1);
                        --i;
                    }
                    --j;
                }
                int i = 0;
                while (i < 8) {
                    if (B[i] != -90) {
                        throw new SignatureException("Unable to unwrap key with algorithm " + this.algorithmURI, new Object[]{wrapping.getEncoded(), wrapped});
                    }
                    ++i;
                }
                System.arraycopy(wrapped, 8, result, 0, result.length);
                byte[] byArray = result;
                Object var12_14 = null;
                SignatureContext.getCryptographicPool().releaseCipher(cipher);
                return byArray;
            }
            catch (SignatureException sig) {
                throw sig;
            }
            catch (Exception ex) {
                throw new SignatureException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            SignatureContext.getCryptographicPool().releaseCipher(cipher);
            throw throwable;
        }
    }
}

