/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.validator.Validator;
import com.sap.engine.lib.schema.validator.tokenizer.XMLSAXTokenizer;
import com.sap.engine.lib.xml.parser.ActiveXMLParser;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class Parser
implements Constants {
    protected static final String SCHEMA_LOCATION_ATTRIB_NAME = "schemaLocation";
    protected static final String NO_NS_SCHEMA_LOCATION_ATTRIB_NAME = "noNamespaceSchemaLocation";
    protected XMLParser xmlParser;
    protected String schemaLanguage;
    protected Object schemaSourceObj;
    protected ErrorHandler errorHandler;
    protected boolean apacheSchemaValidationFeature;
    protected boolean schemaAwareFeature;
    protected boolean validationFeature;
    protected boolean dynamicValidationFeature;
    protected boolean validateSchemaDOM;
    protected Object schemaSource;
    protected Schema externalSchema;
    protected LoaderImpl loader;
    protected Validator validator;

    public Parser() throws ParserException {
        this(new XMLParser());
    }

    public Parser(XMLParser xmlParser) throws ParserException {
        this.xmlParser = xmlParser;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/features/validation/schema")) {
            this.apacheSchemaValidationFeature = value;
        } else if (name.equals("http://sap.com/xml/schema-awareness")) {
            this.schemaAwareFeature = value;
        } else if (name.equals("http://sap.com/xml/schemaDOMValidation")) {
            this.validateSchemaDOM = value;
        } else {
            if (name.equals("http://xml.org/sax/features/validation")) {
                this.validationFeature = value;
            } else if (name.equals("http://apache.org/xml/features/validation/dynamic")) {
                this.dynamicValidationFeature = value;
            }
            this.xmlParser.setFeature(name, value);
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/features/validation/schema")) {
            return this.apacheSchemaValidationFeature;
        }
        if (name.equals("http://sap.com/xml/schema-awareness")) {
            return this.schemaAwareFeature;
        }
        if (name.equals("http://xml.org/sax/features/validation")) {
            return this.validationFeature;
        }
        if (name.equals("http://apache.org/xml/features/validation/dynamic")) {
            return this.dynamicValidationFeature;
        }
        return this.xmlParser.getFeature(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
            throw new SAXNotSupportedException("");
        }
        if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
            throw new SAXNotSupportedException("");
        }
        if (name.equals("http://apache.org/xml/properties/schema/schemaObject")) {
            return this.externalSchema;
        }
        if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaLanguage")) {
            return this.schemaLanguage;
        }
        if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
            return this.schemaSourceObj;
        }
        return this.xmlParser.getProperty(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
            this.checkForceSchemaValidation();
            this.externalSchema = null;
            if (value == null) {
                this.schemaSource = null;
            } else {
                this.checkStringValue(name, value);
                String targetNsesAndLocations = (String)value;
                StringTokenizer tokenizer = new StringTokenizer(targetNsesAndLocations);
                int toukensCount = tokenizer.countTokens();
                if (toukensCount % 2 != 0) {
                    throw new SAXNotSupportedException("The value property 'http://apache.org/xml/properties/schema/external-schemaLocation' must contain taget namespaces and schema locations, separated with white spaces.");
                }
                int count = toukensCount / 2;
                this.schemaSource = new String[2][count];
                int index = 0;
                while (tokenizer.hasMoreTokens()) {
                    ((String[][])this.schemaSource)[0][index] = tokenizer.nextToken();
                    ((String[][])this.schemaSource)[1][index++] = tokenizer.nextToken();
                }
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
            this.checkForceSchemaValidation();
            this.externalSchema = null;
            if (value == null) {
                this.schemaSource = null;
            } else {
                this.checkStringValue(name, value);
                this.schemaSource = new String[2][1];
                ((String[][])this.schemaSource)[0][0] = "";
                ((String[][])this.schemaSource)[1][0] = (String)value;
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/schemaObject")) {
            this.checkForceSchemaValidation();
            this.schemaSource = null;
            if (value == null) {
                this.externalSchema = null;
            } else {
                if (!(value instanceof Schema)) {
                    throw new SAXNotSupportedException("Attempting to set property '" + name + "' to an object, which class is not com.sap.engine.lib.schema.components.Schema.");
                }
                this.externalSchema = (Schema)value;
            }
        } else if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaLanguage")) {
            if (value == null) {
                this.schemaLanguage = null;
            } else {
                this.checkStringValue(name, value);
                this.schemaLanguage = (String)value;
            }
        } else if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
            if (this.schemaLanguage == null || !this.schemaLanguage.equals("http://www.w3.org/2001/XMLSchema")) {
                throw new SAXNotSupportedException("Attempting to set property 'http://java.sun.com/xml/jaxp/properties/schemaSource' without setting property 'http://java.sun.com/xml/jaxp/properties/schemaLanguage' to value 'http://www.w3.org/2001/XMLSchema'.");
            }
            this.externalSchema = null;
            if (value == null) {
                this.schemaSourceObj = null;
                this.schemaSource = null;
            } else {
                this.schemaSource = this.schemaSourceObj = value;
            }
        } else {
            this.xmlParser.setProperty(name, value);
        }
    }

    private Schema loadSchema(String[] targetNamespaces, String[] locations) throws SAXNotSupportedException {
        try {
            LoaderImpl loader = this.determineLoader();
            return loader.load(targetNamespaces, locations);
        }
        catch (Exception exc) {
            throw new SAXNotSupportedException(exc.getMessage());
        }
    }

    private Schema loadSchema(Object schemaSource) throws SAXNotSupportedException {
        try {
            LoaderImpl loader = this.determineLoader();
            return loader.load(schemaSource);
        }
        catch (Exception exc) {
            throw new SAXNotSupportedException(exc.getMessage());
        }
    }

    private LoaderImpl determineLoader() {
        if (this.loader == null) {
            this.loader = new LoaderImpl();
            this.loader.setEntityResolver(this.xmlParser.getEntityResolver());
        }
        this.loader.setValidateSchemaDOM(this.validateSchemaDOM);
        return this.loader;
    }

    private Validator determineValidator() throws SchemaException {
        if (this.validator == null) {
            this.validator = new Validator();
            this.validator.setEntityResolver(this.xmlParser.getEntityResolver());
        }
        this.validator.setValidateSchemaDOM(this.validateSchemaDOM);
        return this.validator;
    }

    private void checkStringValue(String name, Object value) throws SAXNotSupportedException {
        if (!(value instanceof String)) {
            throw new SAXNotSupportedException("Attempting to set property '" + name + "' to an object, which class is not java.lang.String.");
        }
    }

    private void checkForceSchemaValidation() throws SAXNotSupportedException {
        if (!(this.schemaLanguage != null && this.schemaLanguage.equals("http://www.w3.org/2001/XMLSchema") || this.apacheSchemaValidationFeature || this.schemaAwareFeature)) {
            throw new SAXNotSupportedException("Attempting to set an external schema without setting any of the features : 'http://apache.org/xml/features/validation/schema'; 'http://sap.com/xml/schema-awareness or property 'http://java.sun.com/xml/jaxp/properties/schemaLanguage' to value 'http://www.w3.org/2001/XMLSchema'.");
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.xmlParser.setEntityResolver(resolver);
        if (this.loader != null) {
            this.loader.setEntityResolver(resolver);
        }
        if (this.validator != null) {
            this.validator.setEntityResolver(resolver);
        }
    }

    public EntityResolver getEntityResolver() {
        return this.xmlParser.getEntityResolver();
    }

    protected void parseAndProcessSchemaValidation(InputSource input, DocHandler handler) throws Exception {
        this.xmlParser.setValidation(false);
        if (this.dynamicValidationFeature && this.externalSchema == null && this.schemaSource == null && !this.scanXmlForIncludedSchemas(input)) {
            this.xmlParser.parse(input, handler);
            return;
        }
        ActiveXMLParser activeParser = new ActiveXMLParser(input);
        activeParser.setParser(this.xmlParser);
        activeParser.setDocHandler(handler);
        XMLSAXTokenizer tokenizer = new XMLSAXTokenizer(activeParser);
        Validator validator = this.determineValidator();
        validator.setExternalSchema(this.determineExternalSchema());
        if (!validator.validate(tokenizer)) {
            throw new ParserException(validator.getErrorsRepresentation(), -1, -1);
        }
    }

    private Schema determineExternalSchema() throws SchemaException {
        if (this.externalSchema != null) {
            return this.externalSchema;
        }
        if (this.schemaSource == null) {
            return null;
        }
        LoaderImpl loader = this.determineLoader();
        this.externalSchema = loader.load(this.schemaSource);
        return this.externalSchema;
    }

    private void parseWithoutSchemaValidationProcessing(InputSource input, DocHandler handler) throws Exception {
        this.xmlParser.setValidation(this.validationFeature);
        this.xmlParser.setDynamicValidation(this.dynamicValidationFeature);
        this.xmlParser.setActiveParse(false);
        this.xmlParser.parse(input, handler);
    }

    protected boolean scanXmlForIncludedSchemas(InputSource input) throws ParserException, FileNotFoundException, IOException {
        boolean result = false;
        InputStream inputStream = input.getByteStream();
        Reader reader = input.getCharacterStream();
        String systemId = input.getSystemId();
        BufferedInputStream bufferedStream = null;
        BufferedReader bufferedReader = null;
        if (inputStream != null) {
            bufferedStream = new BufferedInputStream(inputStream);
        } else if (reader != null) {
            bufferedReader = new BufferedReader(reader);
        } else if (systemId != null) {
            bufferedStream = new BufferedInputStream(new FileInputStream(systemId));
        } else {
            throw new IllegalArgumentException();
        }
        ActiveXMLParser activeParser = null;
        if (bufferedStream != null) {
            bufferedStream.mark(10000);
            activeParser = new ActiveXMLParser(bufferedStream);
        } else {
            bufferedReader.mark(10000);
            activeParser = new ActiveXMLParser(bufferedReader);
        }
        activeParser.begin();
        activeParser.getParser().setReadDTD(false);
        while (activeParser.next() != 1) {
        }
        Attributes attribs = activeParser.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            if (attribs.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance")) {
                String localName = attribs.getLocalName(i);
                if (localName.equals(SCHEMA_LOCATION_ATTRIB_NAME)) {
                    result = true;
                    break;
                }
                if (localName.equals(NO_NS_SCHEMA_LOCATION_ATTRIB_NAME)) {
                    result = true;
                    break;
                }
            }
            ++i;
        }
        if (bufferedStream != null) {
            bufferedStream.reset();
            input.setByteStream(bufferedStream);
        } else {
            bufferedReader.reset();
            input.setCharacterStream(bufferedReader);
        }
        return result;
    }

    protected void parse(InputSource input, DocHandler handler) throws Exception {
        if (this.validationFeature) {
            if (this.schemaLanguage != null && this.schemaLanguage.equals("http://www.w3.org/2001/XMLSchema") || this.apacheSchemaValidationFeature || this.schemaAwareFeature) {
                this.parseAndProcessSchemaValidation(input, handler);
            } else {
                this.parseWithoutSchemaValidationProcessing(input, handler);
            }
        } else {
            this.parseWithoutSchemaValidationProcessing(input, handler);
        }
    }
}

