/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.Features;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.URLLoaderBase;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.dtd.XMLValidator;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.handlers.NamespaceHandlerEx;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.IXMLStream;
import com.sap.engine.lib.xml.util.ReaderInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class AbstractXMLParser
implements Locator {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    protected XMLValidator xmlValidator = new XMLValidator(this);
    protected String systemId = null;
    protected String publicId = null;
    protected IXMLStream is = null;
    public URLLoaderBase urlLoader = new URLLoaderBase();
    protected boolean bValidation = false;
    protected boolean bDynamicValidation = false;
    protected boolean bNamespaces = true;
    protected boolean bWellformed = true;
    protected boolean bNamespacePrefixes = true;
    protected boolean alternativeDTD = false;
    protected boolean bDOMTrimWhiteSpaces = false;
    protected INamespaceHandler namespaceHandler = null;
    protected boolean bCloseStreams = true;
    protected boolean bUseAlternativeDTD = false;
    protected CharArray caAlternativeDTD = new CharArray();
    protected boolean bScanContentOnly = false;
    protected boolean bActiveParse = false;
    protected boolean bExpandingReferences = true;
    protected boolean bHTMLMode = false;
    protected HashSet HTML_OPEN_TAGS = null;
    protected boolean bExternalGeneralEntities = true;
    protected boolean bReadDTD = true;
    private InputSource additionalDTDLocation = null;
    protected boolean initializeNamespaceHandler = true;
    protected boolean backwardsCompatibilityMode = false;
    public static int id = 0;
    public boolean bSoapProcessing = false;
    public boolean bScanOnlyRoot = false;

    public AbstractXMLParser() {
        try {
            this.loadProperties();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    protected abstract void parse0(InputStream var1, String var2, DocHandler var3) throws Exception;

    public abstract void init() throws ParserException;

    public abstract void onDocumentEOF() throws ParserException;

    public final void activeParse(InputSource source, DocHandler handler) throws Exception {
        this.setActiveParse(true);
        this.parse(source, handler);
    }

    public void finalizeActiveParse() {
        if (!this.bSoapProcessing) {
            this.urlLoader.init();
        }
        this.setActiveParse(false);
    }

    private final void parseAndCatchException(InputStream inputStream, String sourceId, DocHandler docHandler) throws Exception {
        try {
            this.parse0(inputStream, sourceId, docHandler);
            Object var5_4 = null;
            if (!this.bSoapProcessing) {
                this.urlLoader.init();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!this.bSoapProcessing) {
                this.urlLoader.init();
            }
            throw throwable;
        }
    }

    public final void parse(InputStream inputStream, String systemId, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(inputStream, systemId, docHandler);
    }

    public final void parse(Reader reader, String systemId, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(new ReaderInputStream(reader), systemId, docHandler);
    }

    public final void parse(InputStream inputStream, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(inputStream, ":main:", docHandler);
    }

    public final void parse(Reader reader, DocHandler docHandler) throws Exception {
        this.parseAndCatchException(new ReaderInputStream(reader), ":main:", docHandler);
    }

    public final void parse(String s, DocHandler docHandler) throws Exception {
        s.replace('\\', '/');
        InputStream is = this.urlLoader.loadAndPush(s).openStream();
        docHandler.onCustomEvent(1001, this.urlLoader.peek());
        this.parseAndCatchException(is, s, docHandler);
        if (!this.bActiveParse) {
            is.close();
        }
    }

    public final void parse(InputSource input, DocHandler handler) throws Exception {
        Reader reader = input.getCharacterStream();
        InputStream inputStream = input.getByteStream();
        this.systemId = input.getSystemId();
        this.publicId = input.getPublicId();
        if (reader != null) {
            if (this.systemId != null && this.systemId.length() > 0) {
                try {
                    this.urlLoader.push(new URL(this.systemId));
                }
                catch (Exception e) {
                    this.urlLoader.push(new URL("http://localhost/"));
                }
            }
            if (this.systemId == null) {
                this.systemId = ":main:";
            }
            this.parse(reader, this.systemId, handler);
        } else if (inputStream != null) {
            if (this.systemId != null && this.systemId.length() > 0) {
                try {
                    this.urlLoader.push(new URL(this.systemId));
                }
                catch (Exception e) {
                    this.urlLoader.push(new URL("http://localhost/"));
                }
            }
            if (this.systemId == null) {
                this.systemId = ":main:";
            }
            this.parse(inputStream, this.systemId, handler);
        } else {
            this.parse(this.systemId, handler);
        }
    }

    public final void loadProperties() throws ParserException {
        String s = null;
        try {
            s = SystemProperties.getProperty(HTTP_PROXY_HOST);
        }
        catch (SecurityException se) {
            s = "proxy";
        }
        if (s != null) {
            this.setUseProxy(true);
            this.setProxyURL(s);
        }
        try {
            s = SystemProperties.getProperty(HTTP_PROXY_PORT);
        }
        catch (SecurityException se) {
            s = "8080";
        }
        if (s != null) {
            this.setUseProxy(true);
            try {
                this.setProxyPort(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                this.setProxyPort(8080);
            }
        }
        String propertiesFile = null;
        try {
            propertiesFile = SystemProperties.getProperty("xmlparser.properties.file");
        }
        catch (Exception e) {
            return;
        }
        if (propertiesFile == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesFile));
            this.setProperties(properties);
        }
        catch (Exception e) {
            throw new ParserException("Unable to load properties file, '" + propertiesFile + "'", 0, 0);
        }
        if (this.getUseCaches() && this.getCacheDir() == null) {
            throw new ParserException("XMLParser: 'xmlparser.use-cache = 1' property detected, but no 'xmlparser.cache-dir'", 0, 0);
        }
        if (this.getUseProxy()) {
            if (this.getProxyURL() == null) {
                throw new ParserException("XMLParser: 'xmlparser.use-proxy = 1' system property detected, but no 'xmlparser.proxy-host'", 0, 0);
            }
            if (this.getProxyPort() == -1) {
                throw new ParserException("XMLParser: 'xmlparser.use-proxy = 1' system property detected, but no 'xmlparser.proxy-port'", 0, 0);
            }
        }
    }

    public final void setProperties(Properties p) throws SAXNotRecognizedException, SAXNotSupportedException {
        Enumeration e = ((Hashtable)p).keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            this.setProperty(k, p.getProperty(k));
        }
    }

    public final void setProperty(String key, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (Features.RECOGNIZED.contains(key) && !key.equals("http://sap.com/xml/add-ns-mappings")) {
            this.setFeature(key, Features.createBooleanValue(value));
        } else if (key.equals("xmlparser.use-proxy")) {
            this.setUseProxy(Features.createBooleanValue(value));
        } else if (key.equals("xmlparser.proxy-host")) {
            this.setProxyURL((String)value);
        } else if (key.equals("xmlparser.proxy-port")) {
            this.setProxyPort(Integer.parseInt((String)value));
        } else if (key.equals("xmlparser.cache-dir")) {
            this.setCacheDir((String)value);
        } else if (key.equals("xmlparser.use-cache")) {
            this.setUseCaches(Features.createBooleanValue(value));
        } else if (key.equals("xmlparser.alternate-dtd")) {
            this.setAlternativeDTD((String)value);
        } else if (key.equals("xmlparser.use-alternate-dtd")) {
            this.setUseAlternativeDTD(Features.createBooleanValue(value));
        } else if (key.equals("http://inqmy.org/sax/properties/proxy-host")) {
            this.setProxyURL((String)value);
        } else if (key.equals("http://inqmy.org/sax/properties/proxy-port")) {
            this.setProxyPort(this.determineIntValue(value));
        } else if (key.equals("http://inqmy.org/sax/properties/alternative-dtd")) {
            this.setAlternativeDTD((String)value);
        } else if (key.equals("http://apache.org/xml/properties/schema/additionalDTD")) {
            if (!(value instanceof InputSource)) {
                throw new SAXNotSupportedException("The value of property http://apache.org/xml/properties/schema/additionalDTD must be of type org.xml.sax.InputSource.");
            }
            this.setAdditionalDTDLocation((InputSource)value);
        } else if (key.equals("http://sap.com/xml/add-ns-mappings")) {
            this.setInitializeNamespaceHandler(false);
            INamespaceHandler nh = ((XMLParser)this).getNamespaceHandler();
            Hashtable h = (Hashtable)value;
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String pref = (String)e.nextElement();
                nh.add(new CharArray(pref), new CharArray((String)h.get(pref)));
            }
        } else {
            throw new SAXNotRecognizedException("Unable to set property '" + key + "'");
        }
    }

    private int determineIntValue(Object value) throws SAXNotSupportedException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException exc) {
                throw new SAXNotSupportedException("Attempting to determine an int value from incorrect string value '" + value.toString() + "'.");
            }
        }
        throw new SAXNotSupportedException("Attempting to determine an int value from incorrect object with class '" + value.getClass().getName() + "'. Only java.lang.String and java.lang.Integer classes are supported.");
    }

    public final Object getProperty(String key) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (Features.RECOGNIZED.contains(key)) {
            return new Boolean(this.getFeature(key));
        }
        if (key.equals("xmlparser.use-proxy")) {
            return new Boolean(this.getUseProxy());
        }
        if (key.equals("xmlparser.proxy-host")) {
            return this.getProxyURL();
        }
        if (key.equals("xmlparser.proxy-port")) {
            return new Integer(this.getProxyPort());
        }
        if (key.equals("xmlparser.cache-dir")) {
            return this.getCacheDir();
        }
        if (key.equals("xmlparser.use-cache")) {
            return new Boolean(this.getUseCaches());
        }
        if (key.equals("xmlparser.alternate-dtd")) {
            return new Boolean(this.getAlternativeDTD());
        }
        if (key.equals("xmlparser.use-alternate-dtd")) {
            return new Boolean(this.getUseAlternativeDTD());
        }
        if (key.equals("http://inqmy.org/sax/properties/proxy-host")) {
            return this.getProxyURL();
        }
        if (key.equals("http://inqmy.org/sax/properties/proxy-port")) {
            return new Integer(this.getProxyPort());
        }
        throw new SAXNotRecognizedException("Unable to set property '" + key + "'");
    }

    public final void setFeature(String key, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!Features.RECOGNIZED.contains(key)) {
            throw new SAXNotRecognizedException(key);
        }
        if (!Features.SUPPORTED.contains(key)) {
            throw new SAXNotSupportedException(key);
        }
        if (key.startsWith("http://inqmy.com/dtd-validation/")) {
            this.xmlValidator.setFeature(key, value);
            return;
        }
        if (key.equals("http://xml.org/sax/features/validation")) {
            this.setValidation(value);
        } else if (key.equals("http://xml.org/sax/features/namespaces")) {
            this.setNamespaces(value);
        } else if (key.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.setNamespacePrefixes(value);
        } else if (key.equals("http://xml.org/sax/features/external-general-entities")) {
            this.setExternalGeneralEntities(value);
        } else if (key.equals("http://sap.com/xml/soap-input")) {
            this.setSoapProcessing(value);
        } else if (key.equals("http://inqmy.org/sax/features/read-dtd")) {
            this.setReadDTD(value);
        } else if (key.equals("http://apache.org/xml/features/validation/dynamic")) {
            this.setDynamicValidation(value);
        } else if (key.equals("http://sap.com/xml/html-mode")) {
            this.setHTMLMode(value);
        } else if (key.equals("http://inqmy.org/dom/features/trim-white-spaces")) {
            this.setDOMTrimWhiteSpaces(value);
        } else if (key.equals("http://inqmy.com/dom/expanding-references")) {
            this.setExpandingReferences(value);
        } else if (key.equals("http://sap.com/xml/features/scan-only-root")) {
            this.setScanOnlyRoot(value);
        } else if (key.equals("http://inqmy.org/sax/features/use-proxy")) {
            this.setUseProxy(value);
        } else if (key.equals("http://inqmy.org/xml/features/close-streams")) {
            this.setCloseStreams(value);
        } else if (key.equals("http://sap.com/xml/features/backwards-compatibility-mode")) {
            this.setBackwardsCompatibilityMode(true);
        } else {
            throw new SAXNotRecognizedException("Unable to set feature '" + key + "'");
        }
    }

    public final boolean getFeature(String key) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!Features.RECOGNIZED.contains(key)) {
            throw new SAXNotRecognizedException(key);
        }
        if (!Features.SUPPORTED.contains(key)) {
            throw new SAXNotSupportedException(key);
        }
        if (key.startsWith("http://inqmy.com/dtd-validation/")) {
            return this.xmlValidator.getFeature(key);
        }
        if (key.equals("http://xml.org/sax/features/validation")) {
            return this.getValidation();
        }
        if (key.equals("http://xml.org/sax/features/namespaces")) {
            return this.getNamespaces();
        }
        if (key.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this.getNamespacePrefixes();
        }
        if (key.equals("http://xml.org/sax/features/external-general-entities")) {
            return this.getExternalGeneralEntities();
        }
        if (key.equals("http://sap.com/xml/soap-input")) {
            return this.getSoapProcessing();
        }
        if (key.equals("http://sap.com/xml/html-mode")) {
            return this.getHTMLMode();
        }
        if (key.equals("http://inqmy.org/dom/features/trim-white-spaces")) {
            return this.getDOMTrimWhiteSpaces();
        }
        if (key.equals("http://inqmy.com/dom/expanding-references")) {
            return this.getExpandingReferences();
        }
        if (key.equals("http://sap.com/xml/features/scan-only-root")) {
            return this.getScanOnlyRoot();
        }
        if (key.equals("http://inqmy.org/sax/features/use-proxy")) {
            return this.getUseProxy();
        }
        if (key.equals("http://inqmy.org/xml/features/close-streams")) {
            return this.getCloseStreams();
        }
        throw new RuntimeException("Unable to get feature '" + key + "'");
    }

    public final void setProxyPort(int value) {
        this.urlLoader.setProxyPort(value);
    }

    public final int getProxyPort() {
        return this.urlLoader.getProxyPort();
    }

    public final void setProxyURL(String value) {
        this.urlLoader.setProxyHost(value);
    }

    public final String getProxyURL() {
        return this.urlLoader.getProxyHost();
    }

    public final void setUseProxy(boolean value) {
        this.urlLoader.setUseProxy(value);
    }

    public final boolean getUseProxy() {
        return this.urlLoader.getUseProxy();
    }

    public final void setUseAlternativeDTD(boolean value) {
        this.bUseAlternativeDTD = value;
    }

    public final boolean getUseAlternativeDTD() {
        return this.bUseAlternativeDTD;
    }

    public final void setCacheDir(String value) {
        this.urlLoader.setCacheDir(value);
    }

    public final String getCacheDir() {
        return this.urlLoader.getCacheDir();
    }

    public final void setUseCaches(boolean value) {
        this.urlLoader.setUseCache(value);
    }

    public final boolean getUseCaches() {
        return this.urlLoader.getUseCache();
    }

    public final void setValidation(boolean b) {
        this.bValidation = b;
    }

    public final void setDynamicValidation(boolean b) {
        this.bDynamicValidation = b;
    }

    public final boolean getValidation() {
        return this.bValidation;
    }

    public final boolean getNamespaces() {
        return this.bNamespaces;
    }

    public final void setNamespaces(boolean bNamespaces) {
        this.bNamespaces = bNamespaces;
    }

    public final void setWellformed(boolean bWellformed) {
        this.bWellformed = bWellformed;
    }

    public final boolean getWellformed() {
        return this.bWellformed;
    }

    public final boolean getNamespacePrefixes() {
        return this.bNamespacePrefixes;
    }

    public final void setNamespacePrefixes(boolean b) {
        this.bNamespacePrefixes = b;
    }

    protected void setXMLValidator(XMLValidator x) {
        this.xmlValidator = x;
    }

    public final XMLValidator getXMLValidator() {
        return this.xmlValidator;
    }

    public final boolean getDOMTrimWhiteSpaces() {
        return this.bDOMTrimWhiteSpaces;
    }

    public final void setDOMTrimWhiteSpaces(boolean v) {
        this.bDOMTrimWhiteSpaces = v;
    }

    public final void setAlternativeDTD(String value) {
        this.caAlternativeDTD.clear();
        this.caAlternativeDTD.set(value);
        this.alternativeDTD = true;
    }

    public boolean getAlternativeDTD() {
        return this.alternativeDTD;
    }

    public abstract void onWarning(String var1) throws Exception;

    public boolean getCloseStreams() {
        return this.bCloseStreams;
    }

    public void setCloseStreams(boolean bCloseStreams) {
        this.bCloseStreams = bCloseStreams;
    }

    public void setScanContentOnly(boolean value) {
        this.bScanContentOnly = value;
    }

    public boolean getScanContentOnly() {
        return this.bScanContentOnly;
    }

    public boolean getActiveParse() {
        return this.bActiveParse;
    }

    public void setActiveParse(boolean value) {
        this.bActiveParse = value;
    }

    public void setExpandingReferences(boolean value) {
        this.bExpandingReferences = value;
    }

    public boolean getExpandingReferences() {
        return this.bExpandingReferences;
    }

    public boolean getHTMLMode() {
        return this.bHTMLMode;
    }

    public void setHTMLMode(boolean bHTMLMode) {
        this.bHTMLMode = bHTMLMode;
        this.getHTMLOpenTags();
        this.bWellformed = !bHTMLMode;
        this.setExpandingReferences(false);
    }

    public HashSet getHTMLOpenTags() {
        if (this.HTML_OPEN_TAGS == null) {
            this.HTML_OPEN_TAGS = new HashSet();
        }
        return this.HTML_OPEN_TAGS;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        if (this.is == null) {
            return 0;
        }
        return this.is.getRow();
    }

    public int getColumnNumber() {
        if (this.is == null) {
            return 0;
        }
        return this.is.getCol() - 1;
    }

    void setPublicId(String id) {
        this.publicId = id;
    }

    void setSystemId(String id) {
        this.systemId = id;
    }

    public boolean getExternalGeneralEntities() {
        return this.bExternalGeneralEntities;
    }

    public void setExternalGeneralEntities(boolean bExternalGeneralEntities) {
        this.bExternalGeneralEntities = bExternalGeneralEntities;
    }

    public boolean getSoapProcessing() {
        return this.bSoapProcessing;
    }

    public void setSoapProcessing(boolean bSoapProcessing) {
        this.bSoapProcessing = bSoapProcessing;
        if (bSoapProcessing) {
            this.namespaceHandler = new NamespaceHandlerEx(null);
        }
    }

    public boolean getScanOnlyRoot() {
        return this.bScanOnlyRoot;
    }

    public void setScanOnlyRoot(boolean bScanOnlyRoot) {
        this.bScanOnlyRoot = bScanOnlyRoot;
    }

    public void setReadDTD(boolean value) {
        this.bReadDTD = value;
    }

    public boolean getReadDTD() {
        return this.bReadDTD;
    }

    public InputSource getAdditionalDTDLocation() {
        return this.additionalDTDLocation;
    }

    public void setAdditionalDTDLocation(InputSource string) {
        this.additionalDTDLocation = string;
    }

    public boolean isInitializeNamespaceHandler() {
        return this.initializeNamespaceHandler;
    }

    public void setInitializeNamespaceHandler(boolean b) {
        this.initializeNamespaceHandler = b;
    }

    public boolean isBackwardsCompatibilityMode() {
        return this.backwardsCompatibilityMode;
    }

    public void setBackwardsCompatibilityMode(boolean b) {
        this.backwardsCompatibilityMode = b;
    }
}

