/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.xpath.matcher;

import com.sap.engine.lib.schema.util.LexicalTokenizer;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.xpath.matcher.AttributeSet;
import com.sap.engine.lib.schema.validator.xpath.matcher.ContextElementSet;
import com.sap.engine.lib.schema.validator.xpath.matcher.DescendentAttributesSet;
import com.sap.engine.lib.schema.validator.xpath.matcher.DescendentElementsSet;
import com.sap.engine.lib.schema.validator.xpath.matcher.NodesSet;
import java.util.Hashtable;

public class NodesSetFactory {
    protected static NodesSet create(String xPathExpression, Hashtable prefixesMapping) {
        return NodesSetFactory.create(new LexicalTokenizer(xPathExpression, new String[]{"//", "/"}), prefixesMapping);
    }

    private static NodesSet create(LexicalTokenizer tokenizer, Hashtable prefixesMapping) {
        String token = null;
        while ((token = tokenizer.next()) != null) {
            if (token.equals("/") || token.equals(".")) continue;
            if (token.equals("//")) {
                token = tokenizer.next();
                if (token.equals(".")) continue;
                if (token.startsWith("@")) {
                    if ((token = token.substring(1)).equals("*")) {
                        return new AttributeSet();
                    }
                    String[] uriAndName = NodesSetFactory.parseQName(token, prefixesMapping);
                    return new DescendentAttributesSet(uriAndName[0], uriAndName[1]);
                }
                if (token.equals("*")) {
                    return new ContextElementSet(NodesSetFactory.create(tokenizer, prefixesMapping));
                }
                String[] uriAndName = NodesSetFactory.parseQName(token, prefixesMapping);
                return new DescendentElementsSet(uriAndName[0], uriAndName[1], NodesSetFactory.create(tokenizer, prefixesMapping));
            }
            if (token.startsWith("@")) {
                if ((token = token.substring(1)).equals("*")) {
                    return new AttributeSet();
                }
                String[] uriAndName = NodesSetFactory.parseQName(token, prefixesMapping);
                return new AttributeSet(uriAndName[0], uriAndName[1]);
            }
            if (token.equals("*")) {
                return new ContextElementSet(NodesSetFactory.create(tokenizer, prefixesMapping));
            }
            String[] uriAndName = NodesSetFactory.parseQName(token, prefixesMapping);
            return new ContextElementSet(uriAndName[0], uriAndName[1], NodesSetFactory.create(tokenizer, prefixesMapping));
        }
        return null;
    }

    private static String[] parseQName(String qName, Hashtable prefixesMapping) {
        String[] prefixAndName = Tools.parseQName(qName);
        String prefix = prefixAndName[0];
        String uri = null;
        if (prefix == null || prefix.equals("")) {
            uri = "";
        } else {
            uri = (String)prefixesMapping.get(prefix);
            if (uri == null) {
                uri = "";
            }
        }
        String name = prefixAndName[1];
        return new String[]{uri, name};
    }
}

