/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.QualifiedBase;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.automat.DescendentMappingStructure;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class State
implements Constants {
    private Hashtable qualifiedDescendentCollector = new Hashtable();
    private Vector redirectedDescendentCollector = new Vector();
    private static int idCounter;
    private int id = idCounter++;

    State() {
    }

    void addDescendent(Base base, State descendentState, boolean isSubstitution, ModelGroup scopeModelGroupAll) {
        this.addDescendent(this.createRib(base), new DescendentMappingStructure(base, descendentState, isSubstitution, scopeModelGroupAll));
    }

    void addDescendent(String rib, State descendentState) {
        this.addDescendent(rib, new DescendentMappingStructure(descendentState));
    }

    void addDescendent(String rib, DescendentMappingStructure structure) {
        if (rib.equals("redirect.automat.rib")) {
            if (!this.redirectedDescendentCollector.contains(structure) && this != structure.getState()) {
                this.redirectedDescendentCollector.add(structure);
            }
        } else {
            this.qualifiedDescendentCollector.put(rib, structure);
        }
    }

    void addAllDescendents(State state) {
        this.qualifiedDescendentCollector.putAll(state.qualifiedDescendentCollector);
        int i = 0;
        while (i < state.redirectedDescendentCollector.size()) {
            DescendentMappingStructure structure = (DescendentMappingStructure)state.redirectedDescendentCollector.get(i);
            if (!this.redirectedDescendentCollector.contains(structure) && this != structure.getState()) {
                this.redirectedDescendentCollector.add(structure);
            }
            ++i;
        }
    }

    void addQualifiedDescendents(State state) {
        this.qualifiedDescendentCollector.putAll(state.qualifiedDescendentCollector);
    }

    void addAllDescendents(Hashtable qualifiedDescendentCollector) {
        this.qualifiedDescendentCollector.putAll(qualifiedDescendentCollector);
    }

    DescendentMappingStructure getDescendent(String uri, String name) {
        return this.getDescendent(Tools.generateKey(uri, name));
    }

    DescendentMappingStructure getDescendent(String rib) {
        return this.getDescendent(rib, new Vector());
    }

    private DescendentMappingStructure getDescendent(String rib, Vector processedForRedirectionStatesCollector) {
        DescendentMappingStructure structure = (DescendentMappingStructure)this.qualifiedDescendentCollector.get(rib);
        if (structure != null) {
            return structure;
        }
        structure = (DescendentMappingStructure)this.qualifiedDescendentCollector.get("any.state.automat.rib");
        if (structure != null) {
            return structure;
        }
        if (!processedForRedirectionStatesCollector.contains(this)) {
            processedForRedirectionStatesCollector.add(this);
            int i = 0;
            while (i < this.redirectedDescendentCollector.size()) {
                structure = (DescendentMappingStructure)this.redirectedDescendentCollector.get(i);
                State redirectedState = structure.getState();
                if ((structure = redirectedState.getDescendent(rib, processedForRedirectionStatesCollector)) != null && structure.getBase() != null) {
                    return structure;
                }
                ++i;
            }
        }
        return null;
    }

    DescendentMappingStructure getDescendent(Base base) {
        return this.getDescendent(this.createRib(base));
    }

    private String createRib(Base base) {
        if (base instanceof QualifiedBase) {
            return ((QualifiedBase)base).getQualifiedKey();
        }
        return "any.state.automat.rib";
    }

    boolean redirectToState(State state) {
        return this.redirectToState(state, new Vector());
    }

    private boolean redirectToState(State state, Vector processedForRedirectionStatesCollector) {
        if (!processedForRedirectionStatesCollector.contains(this)) {
            processedForRedirectionStatesCollector.add(this);
            int i = 0;
            while (i < this.redirectedDescendentCollector.size()) {
                DescendentMappingStructure structure = (DescendentMappingStructure)this.redirectedDescendentCollector.get(i);
                State redirectedState = structure.getState();
                if (redirectedState == state || redirectedState.redirectToState(state, processedForRedirectionStatesCollector)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    void display() {
        this.display(new Vector());
    }

    String getId() {
        return "" + this.id;
    }

    private void display(Vector displaydStatesCollector) {
        State state;
        DescendentMappingStructure structure;
        DescendentMappingStructure structure2;
        displaydStatesCollector.add(this);
        System.out.println("=====================================================================================");
        System.out.println("State : " + this.getId());
        System.out.println("Descendents :");
        Enumeration keys = this.qualifiedDescendentCollector.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            structure2 = (DescendentMappingStructure)this.qualifiedDescendentCollector.get(key);
            System.out.println("Rib : " + key + " State : " + structure2.getState().getId());
        }
        int i = 0;
        while (i < this.redirectedDescendentCollector.size()) {
            structure2 = (DescendentMappingStructure)this.redirectedDescendentCollector.get(i);
            System.out.println("Rib : redirect.automat.rib State : " + structure2.getState().getId());
            ++i;
        }
        System.out.println("=====================================================================================");
        System.out.println();
        keys = this.qualifiedDescendentCollector.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            structure = (DescendentMappingStructure)this.qualifiedDescendentCollector.get(key);
            state = structure.getState();
            if (displaydStatesCollector.contains(state)) continue;
            state.display(displaydStatesCollector);
        }
        int i2 = 0;
        while (i2 < this.redirectedDescendentCollector.size()) {
            structure = (DescendentMappingStructure)this.redirectedDescendentCollector.get(i2);
            state = structure.getState();
            if (!displaydStatesCollector.contains(state)) {
                state.display(displaydStatesCollector);
            }
            ++i2;
        }
    }
}

