/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import java.util.GregorianCalendar;

public class Duration {
    public static final int COMPARE_LESS = -1;
    public static final int COMPARE_EQUAL = 0;
    public static final int COMPARE_GREATER = 1;
    public static final int COMPARE_NOT_SUPPORTED = 2;
    private int yearsDuration;
    private int monthsDuration;
    private int daysDuration;
    private int hoursDuration;
    private int minutesDuration;
    private double secondsDuration;
    private boolean isPositiveDuration;
    private GregorianCalendar calendar;

    public void setYearsDuration(int yearsDuration) {
        this.yearsDuration = yearsDuration;
    }

    public void setMonthsDuration(int monthsDuration) {
        this.monthsDuration = monthsDuration;
    }

    public void setDaysDuration(int daysDuration) {
        this.daysDuration = daysDuration;
    }

    public void setHoursDuration(int hoursDuration) {
        this.hoursDuration = hoursDuration;
    }

    public void setMinutesDuration(int minutesDuration) {
        this.minutesDuration = minutesDuration;
    }

    public void setSecondsDuration(double secondsDuration) {
        this.secondsDuration = secondsDuration;
    }

    public void setPositiveDuration(boolean isPositiveDuration) {
        this.isPositiveDuration = isPositiveDuration;
    }

    public int getYearsDuration() {
        return this.yearsDuration;
    }

    public int getMonthsDuration() {
        return this.monthsDuration;
    }

    public int getDaysDuration() {
        return this.daysDuration;
    }

    public int getHoursDuration() {
        return this.hoursDuration;
    }

    public int getMinutesDuration() {
        return this.minutesDuration;
    }

    public double getSecondsDuration() {
        return this.secondsDuration;
    }

    public boolean isPositiveDuration() {
        return this.isPositiveDuration;
    }

    public int compare(Duration duration) {
        if (duration == null) {
            return 2;
        }
        if (this.isPositiveDuration && !duration.isPositiveDuration()) {
            return 1;
        }
        if (!this.isPositiveDuration && duration.isPositiveDuration()) {
            return -1;
        }
        this.calendar = this.getCalendar();
        GregorianCalendar cmpCalendar = duration.getCalendar();
        int compareResult = this.compareCalendars(this.calendar, cmpCalendar);
        if (compareResult == 0) {
            return 0;
        }
        if (this.isPositiveDuration) {
            return compareResult;
        }
        return compareResult == -1 ? 1 : -1;
    }

    private int compareCalendars(GregorianCalendar calendar1, GregorianCalendar calendar2) {
        if (calendar1.before(calendar2)) {
            return -1;
        }
        if (calendar1.after(calendar2)) {
            return 1;
        }
        return 0;
    }

    private void produceCalendar() {
        if (this.calendar == null) {
            int calendarYears;
            double carry = this.monthsDuration / 13;
            int calendarMonths = (int)((double)this.monthsDuration - carry * 12.0);
            if (calendarMonths == 0) {
                calendarMonths = 1;
            }
            if ((calendarYears = (int)((double)this.yearsDuration + carry)) == 0) {
                calendarYears = 1;
            }
            carry = (int)(this.secondsDuration / 60.0);
            int calendarSeconds = (int)(this.secondsDuration - carry * 60.0);
            double temp = (double)this.minutesDuration + carry;
            carry = (int)(temp / 60.0);
            int calendarMinutes = (int)(temp - carry * 60.0);
            temp = (double)this.hoursDuration + carry;
            carry = (int)(temp / 24.0);
            int calendarHours = (int)(temp - carry * 24.0);
            temp = (double)this.daysDuration + carry;
            double processingCalendarDays = 0.0;
            if (temp > 28.0) {
                while (true) {
                    int maxDaysOfMonth = 0;
                    maxDaysOfMonth = calendarMonths == 1 || calendarMonths == 3 || calendarMonths == 5 || calendarMonths == 7 || calendarMonths == 8 || calendarMonths == 10 || calendarMonths == 12 ? 31 : (calendarMonths == 4 || calendarMonths == 6 || calendarMonths == 9 || calendarMonths == 11 ? 30 : (calendarYears % 4 == 0 ? 29 : 28));
                    if (!((temp -= (double)maxDaysOfMonth) <= 0.0)) {
                        processingCalendarDays = temp;
                        if (++calendarMonths != 13) continue;
                        calendarMonths = 1;
                        ++calendarYears;
                        continue;
                    }
                    break;
                }
            } else {
                processingCalendarDays = temp;
            }
            int calendarDays = (int)processingCalendarDays;
            this.calendar = new GregorianCalendar();
            this.calendar.clear();
            this.calendar.set(13, calendarSeconds);
            this.calendar.set(12, calendarMinutes);
            this.calendar.set(11, calendarHours);
            this.calendar.set(5, calendarDays);
            this.calendar.set(2, calendarMonths);
            this.calendar.set(1, calendarYears);
        }
    }

    public GregorianCalendar getCalendar() {
        if (this.calendar == null) {
            this.produceCalendar();
        }
        return this.calendar;
    }

    public boolean isInitialized() {
        return this.yearsDuration != -1 || this.monthsDuration != -1 || this.daysDuration != -1 || this.hoursDuration != -1 || this.minutesDuration != -1 || this.secondsDuration != -1.0;
    }

    public String toString() {
        return "[years : " + (this.yearsDuration == -1 ? 0 : this.yearsDuration) + "; months : " + (this.monthsDuration == -1 ? 0 : this.monthsDuration) + "; days : " + (this.daysDuration == -1 ? 0 : this.daysDuration) + "; hours : " + (this.hoursDuration == -1 ? 0 : this.hoursDuration) + "; minutes : " + (this.minutesDuration == -1 ? 0 : this.minutesDuration) + "; seconds : " + (this.secondsDuration == -1.0 ? 0.0 : this.secondsDuration) + "]";
    }
}

