/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public final class ParticleImpl
extends BaseImpl
implements Particle {
    protected int minOccurs;
    protected int maxOccurs;
    protected BaseImpl term;

    public ParticleImpl() {
        this(null);
    }

    public ParticleImpl(BaseInfo baseInfo) {
        this(null, baseInfo);
    }

    public ParticleImpl(Node associatedNode, BaseInfo baseInfo) {
        super(associatedNode, baseInfo);
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public boolean isMaxOccursUnbounded() {
        return this.maxOccurs == Integer.MAX_VALUE;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public Base getTerm() {
        return this.term;
    }

    public int getTypeOfComponent() {
        return 9;
    }

    public boolean match(Base particle) {
        if (!super.match(particle)) {
            return false;
        }
        ParticleImpl targetParticle = (ParticleImpl)particle;
        return this.minOccurs == targetParticle.minOccurs && this.maxOccurs == targetParticle.maxOccurs && this.term.match(targetParticle.term);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            String localName;
            String minOccurseAttribValue;
            this.id = this.loadAttribsCollector.getProperty("id");
            String maxOccursAttribValue = this.loadAttribsCollector.getProperty("maxOccurs");
            if (maxOccursAttribValue != null) {
                int n = this.maxOccurs = maxOccursAttribValue.equals("unbounded") ? Integer.MAX_VALUE : this.processNumber(maxOccursAttribValue);
                if (this.maxOccurs < 1) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct. {max occurs} must greater than or equal to 1.");
                }
            } else {
                this.maxOccurs = 1;
            }
            if ((minOccurseAttribValue = this.loadAttribsCollector.getProperty("minOccurs")) != null) {
                this.minOccurs = this.processNumber(minOccurseAttribValue);
                if (this.minOccurs < 0) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct. {min occurs} must have a non negative value.");
                }
                if (this.minOccurs > this.maxOccurs) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct. {min occurs} must not be greater than {max occurs}.");
                }
            } else {
                this.minOccurs = 1;
            }
            if ((localName = this.associatedNode.getLocalName()).equals("element")) {
                this.term = SchemaStructuresFactory.createElementDeclaration(this.associatedNode, this.baseInfo);
            } else if (localName.equals("any") || localName.equals("anyAttribute")) {
                this.term = SchemaStructuresFactory.createWildcard(this.associatedNode, this.baseInfo);
            } else if (localName.equals("all") || localName.equals("sequence") || localName.equals("choice")) {
                this.term = SchemaStructuresFactory.createModelGroup(this.associatedNode, this.baseInfo);
            } else if (localName.equals("group")) {
                this.term = SchemaStructuresFactory.createModelGroupDefinition(this.associatedNode, this.baseInfo);
            }
            SchemaStructuresFactory.loadBase(this.term);
        }
    }

    private int processNumber(String value) throws SchemaComponentException {
        int result = -1;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormExc) {
            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct.A number format error occurs while processing {minOccurs} or {maxOccurs} value.");
        }
        return result;
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ParticleImpl result = (ParticleImpl)super.initializeBase(base, clonedCollector);
        result.minOccurs = this.minOccurs;
        result.maxOccurs = this.maxOccurs;
        result.term = this.term.clone(clonedCollector);
        return result;
    }
}

