/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.structures.AnnotationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeUseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ElementDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.FacetImpl;
import com.sap.engine.lib.schema.components.impl.structures.IdentityConstraintDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupImpl;
import com.sap.engine.lib.schema.components.impl.structures.NotationDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.ParticleImpl;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.WildcardImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaStructuresFactory
implements Constants {
    public static BaseImpl createBase(Node associatedNode, BaseInfo baseInfo, int type) throws SchemaComponentException {
        BaseImpl base = null;
        switch (type) {
            case 15: {
                base = new AnnotationImpl(associatedNode, baseInfo);
                break;
            }
            case 4: {
                base = SchemaStructuresFactory.getRefferedBase(associatedNode, baseInfo, type);
                if (base != null) break;
                base = new AttributeDeclarationImpl(associatedNode, baseInfo);
                break;
            }
            case 5: {
                base = SchemaStructuresFactory.getRefferedBase(associatedNode, baseInfo, type);
                if (base != null) break;
                base = new AttributeGroupDefinitionImpl(associatedNode, baseInfo);
                break;
            }
            case 6: {
                base = new AttributeUseImpl(associatedNode, baseInfo);
                break;
            }
            case 1: {
                base = new ComplexTypeDefinitionImpl(associatedNode, baseInfo);
                break;
            }
            case 3: {
                base = SchemaStructuresFactory.getRefferedBase(associatedNode, baseInfo, type);
                if (base != null) break;
                base = new ElementDeclarationImpl(associatedNode, baseInfo);
                break;
            }
            case 11: {
                base = new FacetImpl(associatedNode, baseInfo);
                break;
            }
            case 13: {
                base = new IdentityConstraintDefinitionImpl(associatedNode, baseInfo);
                break;
            }
            case 7: {
                base = new ModelGroupImpl(associatedNode, baseInfo);
                break;
            }
            case 8: {
                base = SchemaStructuresFactory.getRefferedBase(associatedNode, baseInfo, type);
                if (base != null) break;
                base = new ModelGroupDefinitionImpl(associatedNode, baseInfo);
                break;
            }
            case 14: {
                base = new NotationDeclarationImpl(associatedNode, baseInfo);
                break;
            }
            case 9: {
                base = new ParticleImpl(associatedNode, baseInfo);
                break;
            }
            case 2: {
                base = new SimpleTypeDefinitionImpl(associatedNode, baseInfo);
                break;
            }
            case 10: {
                base = new WildcardImpl(associatedNode, baseInfo);
            }
        }
        return base;
    }

    public static AnnotationImpl createAnnotation(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (AnnotationImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 15);
    }

    public static AttributeDeclarationImpl createAttributeDeclaration(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (AttributeDeclarationImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 4);
    }

    public static AttributeGroupDefinitionImpl createAttributeGroupDefinition(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (AttributeGroupDefinitionImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 5);
    }

    public static AttributeUseImpl createAttributeUse(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (AttributeUseImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 6);
    }

    public static ComplexTypeDefinitionImpl createComplexTypeDefinition(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (ComplexTypeDefinitionImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 1);
    }

    public static ElementDeclarationImpl createElementDeclaration(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (ElementDeclarationImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 3);
    }

    public static IdentityConstraintDefinitionImpl createIdentityConstraintDefinition(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (IdentityConstraintDefinitionImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 13);
    }

    public static FacetImpl createFacet(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (FacetImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 11);
    }

    public static ModelGroupImpl createModelGroup(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (ModelGroupImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 7);
    }

    public static ModelGroupDefinitionImpl createModelGroupDefinition(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (ModelGroupDefinitionImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 8);
    }

    public static NotationDeclarationImpl createNotationDeclaration(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (NotationDeclarationImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 14);
    }

    public static ParticleImpl createParticle(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (ParticleImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 9);
    }

    public static SimpleTypeDefinitionImpl createSimpleTypeDefinition(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (SimpleTypeDefinitionImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 2);
    }

    public static WildcardImpl createWildcard(Node associatedNode, BaseInfo baseInfo) throws SchemaComponentException {
        return (WildcardImpl)SchemaStructuresFactory.createBase(associatedNode, baseInfo, 10);
    }

    private static BaseImpl getRefferedBase(Node associatedNode, BaseInfo baseInfo, int type) throws SchemaComponentException {
        Element associatedElement = (Element)associatedNode;
        Attr refAttrib = associatedElement.getAttributeNode("ref");
        if (refAttrib != null) {
            return Tools.getTopLevelBase(baseInfo.getSchema(), baseInfo.getLoader(), associatedNode, refAttrib.getValue(), type, baseInfo.getLocation());
        }
        return null;
    }

    public static void loadBase(BaseImpl base) throws SchemaComponentException {
        if (!base.isLoaded() && !base.isLoading()) {
            base.setLoading(true);
            base.load();
            base.setLoading(false);
            base.setLoaded(true);
            base.destroy();
        }
    }
}

