/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser;

import com.inqmy.lib.schema.validator.Validator;
import com.inqmy.lib.xml.parser.ActiveXMLParser;
import com.inqmy.lib.xml.parser.DocHandler;
import com.inqmy.lib.xml.parser.ParserException;
import com.inqmy.lib.xml.parser.XMLParser;
import com.inqmy.lib.xml.parser.dtd.ValidationException;
import com.inqmy.lib.xml.parser.handlers.SAXDocHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Locale;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public class SAXParser
implements XMLReader,
Parser {
    private ContentHandler contentHandler = null;
    private DocumentHandler documentHandler = null;
    private ErrorHandler errorHandler = null;
    private DTDHandler dtdHandler = null;
    private DeclHandler declHandler = null;
    private LexicalHandler lexicalHandler = null;
    private Locale locale = null;
    private boolean forceSchema = false;
    private Validator schemaValidator = null;
    private boolean apacheUseSchema = false;
    private boolean apacheValidationDynamic = false;
    private String noNamespaceSchemaLocation = null;
    private String[] schemaLocations = new String[0];
    private String[] schemaNamespaces = new String[0];
    private SAXDocHandler saxHandler = null;
    private XMLParser xmlParser = null;

    public SAXParser() throws ParserException {
        this.xmlParser = new XMLParser();
    }

    public SAXParser(XMLParser p) {
        this.xmlParser = p;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlParser.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/features/validation/schema")) {
            this.apacheUseSchema = value;
            return;
        }
        if (name.equals("http://apache.org/xml/features/validation/dynamic")) {
            this.apacheValidationDynamic = value;
        }
        this.xmlParser.setFeature(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            return this.declHandler;
        }
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        if (name.equals("http://xml.org/sax/properties/xml-string")) {
            throw new SAXNotSupportedException("");
        }
        throw new SAXNotRecognizedException("");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            this.declHandler = (DeclHandler)value;
        } else if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
        } else {
            if (name.equals("http://xml.org/sax/properties/xml-string")) {
                throw new SAXNotSupportedException("");
            }
            if (name.equals("http://inqmy.org/sax/properties/proxy-host")) {
                this.xmlParser.setProxyURL((String)value);
            } else if (name.equals("http://inqmy.org/sax/properties/proxy-port")) {
                this.xmlParser.setProxyPort((Integer)value);
            } else if (name.equals("http://inqmy.org/sax/properties/alternative-dtd")) {
                this.xmlParser.setAlternativeDTD((String)value);
            } else if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
                if (!this.fillExternalSchemaLocations(value.toString())) {
                    this.schemaNamespaces = new String[0];
                    this.schemaLocations = new String[0];
                    throw new IllegalArgumentException("Incorrect proerty value - number of tokens not even!");
                }
            } else if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
                this.noNamespaceSchemaLocation = value.toString();
            } else if (name.equals("http://sap.com/xml/max-references")) {
                this.xmlParser.setMaximumProcessingReferences(value);
            } else if (value == null) {
                this.xmlParser.setProperty(name, null);
            } else {
                this.xmlParser.setProperty(name, value.toString());
            }
        }
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.xmlParser.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.xmlParser.getEntityResolver();
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDTDHandler(this.dtdHandler);
        }
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setContentHandler(handler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDocumentHandler(handler);
        }
    }

    public DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.xmlParser.setSystemId(input.getSystemId());
        this.xmlParser.setPublicId(input.getPublicId());
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(this.xmlParser);
        }
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(this.xmlParser);
        }
        try {
            this.saxHandler = new SAXDocHandler();
            this.saxHandler.setLexicalHandler(this.lexicalHandler);
            this.saxHandler.setDocumentHandler(this.documentHandler);
            this.saxHandler.setDeclHandler(this.declHandler);
            this.saxHandler.setContentHandler(this.contentHandler);
            this.saxHandler.setDTDHandler(this.dtdHandler);
            this.saxHandler.setErrorHandler(this.errorHandler);
            if (!this.forceSchema && this.apacheUseSchema) {
                input = this.scanXMLForSchemaReference(input, this.xmlParser);
            }
            if (this.getFeature("http://xml.org/sax/features/validation")) {
                if (!this.apacheUseSchema || this.apacheValidationDynamic && !this.forceSchema) {
                    this.xmlParser.parse(input, (DocHandler)this.saxHandler);
                } else {
                    this.setFeature("http://xml.org/sax/features/validation", false);
                    this.schemaValidator = new Validator();
                    this.schemaValidator.setParser(this.xmlParser);
                    this.schemaValidator.setDocHandler(this.saxHandler);
                    this.schemaValidator.setExternalSchemas(this.schemaNamespaces, this.schemaLocations);
                    this.schemaValidator.setExternalNoNamespaceSchema(this.noNamespaceSchemaLocation);
                    boolean result = this.schemaValidator.validate(input);
                    if (!result) {
                        throw new ParserException(this.schemaValidator.getErrors()[0], -1, -1);
                    }
                }
            } else if (this.apacheUseSchema && (this.forceSchema || !this.apacheValidationDynamic)) {
                this.setFeature("http://xml.org/sax/features/validation", false);
                this.schemaValidator = new Validator();
                this.schemaValidator.setParser(this.xmlParser);
                this.schemaValidator.setDocHandler(this.saxHandler);
                this.schemaValidator.setExternalSchemas(this.schemaNamespaces, this.schemaLocations);
                this.schemaValidator.setExternalNoNamespaceSchema(this.noNamespaceSchemaLocation);
                boolean result = this.schemaValidator.validate(input);
                if (!result) {
                    throw new ParserException(this.schemaValidator.getErrors()[0], -1, -1);
                }
            } else {
                this.xmlParser.parse(input, (DocHandler)this.saxHandler);
            }
        }
        catch (ParserException e) {
            LocatorImpl loc = new LocatorImpl();
            loc.setPublicId(input.getPublicId());
            loc.setSystemId(e.getSourceID());
            loc.setLineNumber(e.getRow());
            loc.setColumnNumber(e.getCol());
            if (this.errorHandler != null) {
                if (e instanceof ValidationException) {
                    this.errorHandler.error(new SAXParseException("Validation Error: " + e, loc, e));
                }
                this.errorHandler.fatalError(new SAXParseException("Fatal Error: " + e, loc, e));
                throw new SAXParseException(e.toString(), loc, e);
            }
            throw new SAXParseException(e.getMessage(), loc, e);
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            e.printStackTrace(pw);
            pw.flush();
            throw new SAXException("Generic Exception: " + w.toString());
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setHandler(Object h) {
        if (h instanceof ContentHandler) {
            this.setContentHandler((ContentHandler)h);
        }
        if (h instanceof DocumentHandler) {
            this.setDocumentHandler((DocumentHandler)h);
        }
        if (h instanceof DTDHandler) {
            this.setDTDHandler((DTDHandler)h);
        }
        if (h instanceof EntityResolver) {
            this.setEntityResolver((EntityResolver)h);
        }
        if (h instanceof ErrorHandler) {
            this.setErrorHandler((ErrorHandler)h);
        }
        if (h instanceof DeclHandler) {
            try {
                this.setProperty("http://xml.org/sax/properties/declaration-handler", h);
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
        }
        if (h instanceof LexicalHandler) {
            try {
                this.setProperty("http://xml.org/sax/properties/lexical-handler", h);
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
    }

    private boolean fillExternalSchemaLocations(String locator) throws IllegalArgumentException {
        StringTokenizer tok = new StringTokenizer(locator);
        boolean even = true;
        while (tok.hasMoreTokens()) {
            String[] temp;
            String t = tok.nextToken();
            if (even) {
                temp = new String[this.schemaNamespaces.length + 1];
                System.arraycopy(this.schemaNamespaces, 0, temp, 0, this.schemaNamespaces.length);
                temp[temp.length - 1] = t;
                this.schemaNamespaces = temp;
                even = false;
                continue;
            }
            temp = new String[this.schemaLocations.length + 1];
            System.arraycopy(this.schemaLocations, 0, temp, 0, this.schemaLocations.length);
            temp[temp.length - 1] = t;
            this.schemaLocations = temp;
            even = true;
        }
        return even;
    }

    private InputSource scanXMLForSchemaReference(InputSource is, XMLParser parser) throws ParserException, IOException, SAXNotRecognizedException, SAXNotSupportedException {
        int markAllowance = 10000;
        Reader r = is.getCharacterStream();
        InputStream inputStream = is.getByteStream();
        ActiveXMLParser aparser = null;
        BufferedReader reader = null;
        BufferedInputStream inStr = null;
        if (r != null) {
            reader = new BufferedReader(r);
            aparser = new ActiveXMLParser(reader);
        }
        if (inputStream != null) {
            inStr = new BufferedInputStream(inputStream);
            aparser = new ActiveXMLParser(inStr);
        }
        if (reader != null || inStr != null) {
            boolean validation = this.getFeature("http://xml.org/sax/features/validation");
            parser.setValidation(false);
            aparser.setParser(parser);
            if (reader != null) {
                reader.mark(markAllowance);
            } else {
                inStr.mark(markAllowance);
            }
            aparser.begin();
            int i = -1;
            while ((i = aparser.next()) != 1) {
            }
            parser.setValidation(validation);
            try {
                if (reader != null) {
                    reader.reset();
                } else {
                    inStr.reset();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException(SAXParser.constructException(e, "Start tag of root element ends after the" + markAllowance + "'th byte.  You have to specify the schema manually (e.g. through a property)."));
            }
            this.getAttribs(aparser);
            return inStr != null ? new InputSource(inStr) : new InputSource(reader);
        }
        aparser = new ActiveXMLParser(is);
        boolean validation = this.getFeature("http://xml.org/sax/features/validation");
        parser.setValidation(false);
        aparser.setParser(parser);
        aparser.begin();
        int i = -1;
        while ((i = aparser.next()) != 1) {
        }
        parser.setValidation(validation);
        this.getAttribs(aparser);
        return is;
    }

    private void getAttribs(ActiveXMLParser aparser) {
        Attributes attrs = aparser.getAttributes();
        int size = attrs.getLength();
        int j = 0;
        while (j < size) {
            if ("schemaLocation".equals(attrs.getLocalName(j)) && "http://www.w3.org/2001/XMLSchema-instance".equals(attrs.getURI(j))) {
                this.fillExternalSchemaLocations(attrs.getValue(j));
                this.forceSchema = true;
            }
            if ("noNamespaceSchemaLocation".equals(attrs.getLocalName(j)) && "http://www.w3.org/2001/XMLSchema-instance".equals(attrs.getURI(j)) && this.noNamespaceSchemaLocation == null) {
                this.noNamespaceSchemaLocation = attrs.getValue(j);
                this.forceSchema = true;
            }
            ++j;
        }
    }

    private static String constructException(Exception oldException, String explanation) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        oldException.printStackTrace(new PrintWriter(baos));
        return explanation + new String(baos.toByteArray());
    }
}

