/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.regular;

import com.inqmy.lib.schema.regular.InstructionSet;
import com.inqmy.lib.schema.regular.RegularExpressionException;
import com.inqmy.lib.schema.regular.Tools;

public final class RegularExpressionMachine
implements InstructionSet {
    private char[] code;
    private int[] stack = new int[256];
    private int nStack;
    private int[] threads = new int[256];
    private int nThreads;
    private int[] threadsOld = new int[256];
    private int nThreadsOld;
    private boolean finalStateReached;
    private boolean flag;
    private char current;

    public boolean process(char[] code, String s) throws RegularExpressionException {
        return this.process(code, 0, s.toCharArray(), 0, s.length());
    }

    public boolean process(char[] code, int start, String s) throws RegularExpressionException {
        return this.process(code, start, s.toCharArray(), 0, s.length());
    }

    public boolean process(char[] code, int start, char[] s, int offset, int length) throws RegularExpressionException {
        int j;
        int[] temp;
        this.code = code;
        this.nThreads = 0;
        this.addThread(start);
        int end = offset + length;
        int i = offset;
        while (i < end) {
            this.finalStateReached = false;
            temp = this.threadsOld;
            this.threadsOld = this.threads;
            this.threads = temp;
            this.nThreadsOld = this.nThreads;
            this.nThreads = 0;
            this.current = s[i];
            j = 0;
            while (j < this.nThreadsOld) {
                this.perform(this.threadsOld[j]);
                ++j;
            }
            ++i;
        }
        this.finalStateReached = false;
        temp = this.threadsOld;
        this.threadsOld = this.threads;
        this.threads = temp;
        this.nThreadsOld = this.nThreads;
        this.nThreads = 0;
        this.current = '\u0000';
        j = 0;
        while (j < this.nThreadsOld) {
            this.perform(this.threadsOld[j]);
            ++j;
        }
        return this.finalStateReached;
    }

    private void perform(int p) throws RegularExpressionException {
        char c;
        block15: while (true) {
            c = this.code[p];
            switch (c) {
                case '\u0001': {
                    return;
                }
                case '\u0002': {
                    this.finalStateReached = true;
                    return;
                }
                case '\u0003': {
                    p += (short)this.code[p + 1];
                    continue block15;
                }
                case '\u0004': {
                    this.addThread(p + (short)this.code[p + 1]);
                    p += 2;
                    continue block15;
                }
                case '\u0005': {
                    this.perform(p + (short)this.code[p + 1]);
                    p += 2;
                    continue block15;
                }
                case '\u0006': {
                    if (this.current == this.code[p + 1]) {
                        p += (short)this.code[p + 2];
                        continue block15;
                    }
                    p += 3;
                    continue block15;
                }
                case '\u0007': {
                    if (this.current != this.code[p + 1]) {
                        p += (short)this.code[p + 2];
                        continue block15;
                    }
                    p += 3;
                    continue block15;
                }
                case '\n': {
                    if (this.current > this.code[p + 1]) {
                        p += (short)this.code[p + 2];
                        continue block15;
                    }
                    p += 3;
                    continue block15;
                }
                case '\u000b': {
                    if (this.current <= this.code[p + 1]) {
                        p += (short)this.code[p + 2];
                        continue block15;
                    }
                    p += 3;
                    continue block15;
                }
                case '\b': {
                    if (this.current < this.code[p + 1]) {
                        p += (short)this.code[p + 2];
                        continue block15;
                    }
                    p += 3;
                    continue block15;
                }
                case '\t': {
                    if (this.current >= this.code[p + 1]) {
                        p += (short)this.code[p + 2];
                        continue block15;
                    }
                    p += 3;
                    continue block15;
                }
                case '\f': {
                    if (this.current >= this.code[p + 1] && this.current <= this.code[p + 2]) {
                        p += (short)this.code[p + 3];
                        continue block15;
                    }
                    p += 4;
                    continue block15;
                }
                case '\r': {
                    if (this.current < this.code[p + 1] || this.current > this.code[p + 2]) {
                        p += (short)this.code[p + 3];
                        continue block15;
                    }
                    p += 4;
                    continue block15;
                }
            }
            break;
        }
        throw new RegularExpressionException("Instruction not recognized, " + c);
    }

    private void addThread(int p) throws RegularExpressionException {
        if (Tools.contains(this.threads, this.nThreads, p)) {
            return;
        }
        this.threads = Tools.assertArrayLength(this.threads, this.nThreads + 1);
        this.threads[this.nThreads] = p;
        ++this.nThreads;
    }

    private void printThreads() throws RegularExpressionException {
        System.out.print(" Threads: {");
        int i = 0;
        while (i < this.nThreads) {
            System.out.print(" " + this.threads[i]);
            ++i;
        }
        System.out.println(" }");
    }
}

