/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.builtin;

import com.inqmy.lib.schema.SchemaException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public final class Hex {
    private static final char[] INT_TO_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] HEX_TO_INT = new int[256];

    private Hex() {
    }

    public static String encode(byte[] a, int start, int end) {
        if (a == null || start < 0 || end > a.length || start > end) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0) {
            return "0";
        }
        StringBuffer buffer = new StringBuffer();
        int i = start;
        while (i < end) {
            buffer.append(INT_TO_HEX[(a[i] & 0xF0) >> 4]);
            buffer.append(INT_TO_HEX[a[i] & 0xF]);
            ++i;
        }
        return buffer.toString();
    }

    public static String encode(byte[] a) {
        return Hex.encode(a, 0, a.length);
    }

    public static byte[] decode(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (s.equals("0")) {
            return new byte[0];
        }
        int ls = s.length();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        int modulus = ls & 1;
        int x = 0;
        while (i < ls) {
            char ch = s.charAt(i);
            if (ch < '\u0000' || ch > '\u00ff' || HEX_TO_INT[ch] == -1) {
                throw new SchemaException("Illegal character in hex binary, '" + ch + "'.");
            }
            if (modulus == 0) {
                x = HEX_TO_INT[ch] << 4;
                modulus = 1;
            } else {
                modulus = 0;
                out.write(x |= HEX_TO_INT[ch]);
            }
            ++i;
        }
        return out.toByteArray();
    }

    public static void main(String[] args) throws Exception {
        byte[] a = new byte[]{};
        int i = 0;
        while (i < a.length) {
            a[i] = (byte)Math.floor(Math.random() * 256.0);
            ++i;
        }
        System.out.println("DUMP 1");
        System.out.println(Hex.encode(a));
        System.out.println("DUMP 2");
        byte[] b = Hex.decode(Hex.encode(a));
        System.out.println("DUMP 3 -> " + b.length);
        System.out.println(Hex.encode(b));
        System.out.println("DUMP 4");
    }

    static {
        Arrays.fill(HEX_TO_INT, -1);
        Hex.HEX_TO_INT[48] = 0;
        Hex.HEX_TO_INT[49] = 1;
        Hex.HEX_TO_INT[50] = 2;
        Hex.HEX_TO_INT[51] = 3;
        Hex.HEX_TO_INT[52] = 4;
        Hex.HEX_TO_INT[53] = 5;
        Hex.HEX_TO_INT[54] = 6;
        Hex.HEX_TO_INT[55] = 7;
        Hex.HEX_TO_INT[56] = 8;
        Hex.HEX_TO_INT[57] = 9;
        Hex.HEX_TO_INT[97] = 10;
        Hex.HEX_TO_INT[98] = 11;
        Hex.HEX_TO_INT[99] = 12;
        Hex.HEX_TO_INT[100] = 13;
        Hex.HEX_TO_INT[101] = 14;
        Hex.HEX_TO_INT[102] = 15;
        Hex.HEX_TO_INT[65] = 10;
        Hex.HEX_TO_INT[66] = 11;
        Hex.HEX_TO_INT[67] = 12;
        Hex.HEX_TO_INT[68] = 13;
        Hex.HEX_TO_INT[69] = 14;
        Hex.HEX_TO_INT[70] = 15;
    }
}

