/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AnonymousFileSource {
    File fDirectory;

    public AnonymousFileSource(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        } else if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Directory arguments should be a directory.");
        }
        this.fDirectory = directory;
    }

    public synchronized RandomAccessFile allocateAnonymousFile() throws IOException {
        File file = this.getAnonymousFile();
        return new RandomAccessFile(file, "rw");
    }

    public synchronized URL allocateAnonymousURL(byte[] bytes) throws IOException {
        try {
            byte[] hasharray = MessageDigest.getInstance("SHA").digest(bytes);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < hasharray.length) {
                sb.append(Character.forDigit(hasharray[i] >> 4 & 0xF, 16));
                sb.append(Character.forDigit(hasharray[i] & 0xF, 16));
                ++i;
            }
            sb.append(".jnk");
            String fileName = sb.toString();
            File file = this.fileForName(fileName);
            if (!file.exists()) {
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                raf.write(bytes);
                raf.close();
            }
            return AnonymousFileSource.convertFileToURL(file);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static URL convertFileToURL(File file) {
        try {
            String path = file.getCanonicalPath().replace(File.separatorChar, '/');
            return new URL("file", "", "/" + path);
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    File fileForName(String fileName) {
        File dir;
        if (fileName.length() >= 1) {
            String dirName = Integer.toHexString(fileName.hashCode() % 255 & 0xFF);
            dir = new File(this.fDirectory, dirName);
            dir.mkdirs();
        } else {
            dir = this.fDirectory;
        }
        return new File(dir, fileName);
    }

    public synchronized File getAnonymousFile() {
        File file = this.fileForName(this.getAnonymousFileName());
        while (file.exists()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
            file = this.fileForName(this.getAnonymousFileName());
        }
        return file;
    }

    public synchronized String getAnonymousFileName() {
        return this.getAnonymousFileName(System.currentTimeMillis());
    }

    public synchronized String getAnonymousFileName(long l) {
        if (l < 0L) {
            l = -l;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Character.forDigit((int)(l % 26L + 10L), 36));
        l /= 26L;
        while (l != 0L) {
            sb.append(Character.forDigit((int)(l % 36L), 36));
            l /= 36L;
        }
        sb.append(".jnk");
        return sb.toString();
    }
}

