/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.WorkingCopy;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator2;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;

public class PotentialMatch
implements ICompilationUnit {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    private MatchLocator2 locator;
    public IResource resource;
    public Openable openable;
    public char[][] compoundName;
    MatchingNodeSet matchingNodeSet;
    private String sourceFileName;

    public PotentialMatch(MatchLocator2 locator, IResource resource, Openable openable) {
        this.locator = locator;
        this.resource = resource;
        this.openable = openable;
        this.matchingNodeSet = new MatchingNodeSet(locator);
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            this.compoundName = CharOperation.splitOn('.', qualifiedName);
        }
    }

    public boolean equals(Object obj) {
        if (this.compoundName == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof PotentialMatch)) {
            return false;
        }
        return CharOperation.equals(this.compoundName, ((PotentialMatch)obj).compoundName);
    }

    private char[] findClassFileSource() {
        String sourceFileName = this.getSourceFileName();
        if (sourceFileName == NO_SOURCE_FILE_NAME) {
            return null;
        }
        char[] source = null;
        try {
            SourceMapper sourceMapper = this.openable.getSourceMapper();
            if (sourceMapper != null) {
                IType type = ((ClassFile)this.openable).getType();
                source = sourceMapper.findSource(type, sourceFileName);
            }
        }
        catch (JavaModelException javaModelException) {}
        return source;
    }

    private String getSourceFileName() {
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        this.sourceFileName = NO_SOURCE_FILE_NAME;
        try {
            IType type;
            ClassFileReader reader;
            SourceMapper sourceMapper = this.openable.getSourceMapper();
            if (sourceMapper != null && (reader = this.locator.classFileReader(type = ((ClassFile)this.openable).getType())) != null) {
                this.sourceFileName = sourceMapper.findSourceFileName(type, reader);
            }
        }
        catch (JavaModelException javaModelException) {}
        return this.sourceFileName;
    }

    public char[] getContents() {
        char[] source = null;
        try {
            if (this.openable instanceof WorkingCopy) {
                IBuffer buffer = this.openable.getBuffer();
                if (buffer == null) {
                    return null;
                }
                source = buffer.getCharacters();
            } else if (this.openable instanceof CompilationUnit) {
                source = Util.getResourceContentsAsCharArray((IFile)this.resource);
            } else if (this.openable instanceof ClassFile) {
                source = this.findClassFileSource();
            }
        }
        catch (JavaModelException javaModelException) {}
        if (source == null) {
            return CharOperation.NO_CHAR;
        }
        return source;
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof CompilationUnit) {
            String fileName = this.resource.getFullPath().lastSegment();
            char[] mainTypeName = fileName.substring(0, fileName.length() - 5).toCharArray();
            CompilationUnit cu = (CompilationUnit)this.openable;
            return cu.getType(new String(mainTypeName)).getFullyQualifiedName().toCharArray();
        }
        if (this.openable instanceof ClassFile) {
            String sourceFileName = this.getSourceFileName();
            if (sourceFileName == NO_SOURCE_FILE_NAME) {
                try {
                    return ((ClassFile)this.openable).getType().getFullyQualifiedName('.').toCharArray();
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            String simpleName = sourceFileName.substring(0, sourceFileName.length() - 5);
            String pkgName = this.openable.getParent().getElementName();
            if (pkgName.length() == 0) {
                return simpleName.toCharArray();
            }
            return (String.valueOf(pkgName) + '.' + simpleName).toCharArray();
        }
        return null;
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int hashCode = 0;
        int i = 0;
        int length = this.compoundName.length;
        while (i < length) {
            hashCode += CharOperation.hashCode(this.compoundName[i]);
            ++i;
        }
        return hashCode;
    }

    public char[] getMainTypeName() {
        return null;
    }

    public char[][] getPackageName() {
        int length = this.compoundName.length;
        if (length > 1) {
            return CharOperation.subarray(this.compoundName, 0, length - 1);
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public void locateMatchesInClassFile() throws CoreException {
        IField fieldHandle;
        int i;
        IMethod methodHandle;
        Object[] methods;
        ClassFile classFile = (ClassFile)this.openable;
        IBinaryType info = this.locator.getBinaryInfo(classFile, this.resource);
        if (info == null) {
            return;
        }
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (this.locator.pattern.matchesBinary(info, null)) {
            this.locator.reportBinaryMatch(binaryType, info, 0);
        }
        boolean compilationAborted = false;
        if (this.locator.pattern.needsResolve) {
            BinaryTypeBinding binding = null;
            try {
                binding = this.locator.cacheBinaryType(binaryType);
                if (binding != null) {
                    if (!this.locator.typeInHierarchy(binding)) {
                        return;
                    }
                    methods = binding.methods();
                    int i2 = 0;
                    while (i2 < methods.length) {
                        Object method = methods[i2];
                        int level = this.locator.pattern.matchLevel((Binding)method);
                        switch (level) {
                            case 0: 
                            case 3: {
                                break;
                            }
                            default: {
                                methodHandle = binaryType.getMethod(new String(((MethodBinding)method).isConstructor() ? binding.compoundName[binding.compoundName.length - 1] : ((MethodBinding)method).selector), Signature.getParameterTypes(new String(((MethodBinding)method).signature()).replace('/', '.')));
                                this.locator.reportBinaryMatch(methodHandle, info, level == 2 ? 0 : 1);
                            }
                        }
                        ++i2;
                    }
                    FieldBinding[] fields = binding.fields();
                    i = 0;
                    while (i < fields.length) {
                        FieldBinding field = fields[i];
                        int level = this.locator.pattern.matchLevel(field);
                        switch (level) {
                            case 0: 
                            case 3: {
                                break;
                            }
                            default: {
                                fieldHandle = binaryType.getField(new String(field.name));
                                this.locator.reportBinaryMatch(fieldHandle, info, level == 2 ? 0 : 1);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (AbortCompilation abortCompilation) {
                binding = null;
            }
            boolean bl = compilationAborted = binding == null;
            if (!compilationAborted) {
                return;
            }
        }
        int accuracy = compilationAborted ? 1 : 0;
        methods = info.getMethods();
        int length = methods == null ? 0 : methods.length;
        i = 0;
        while (i < length) {
            Object method = methods[i];
            if (this.locator.pattern.matchesBinary(method, info)) {
                methodHandle = binaryType.getMethod(new String(method.isConstructor() ? info.getName() : method.getSelector()), Signature.getParameterTypes(new String(method.getMethodDescriptor()).replace('/', '.')));
                this.locator.reportBinaryMatch(methodHandle, info, accuracy);
            }
            ++i;
        }
        IBinaryField[] fields = info.getFields();
        length = fields == null ? 0 : fields.length;
        int i3 = 0;
        while (i3 < length) {
            IBinaryField field = fields[i3];
            if (this.locator.pattern.matchesBinary(field, info)) {
                fieldHandle = binaryType.getField(new String(field.getName()));
                this.locator.reportBinaryMatch(fieldHandle, info, accuracy);
            }
            ++i3;
        }
    }

    public String toString() {
        return this.openable == null ? "Fake PotentialMatch" : this.openable.toString();
    }

    public char[] getFileName() {
        return this.openable.getPath().toString().toCharArray();
    }
}

