/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;

public class MethodReferencePattern
extends MethodPattern {
    IType declaringType;
    public char[][][] allSuperDeclaringTypeNames;

    public MethodReferencePattern(char[] selector, int matchMode, boolean isCaseSensitive, char[] declaringQualification, char[] declaringSimpleName, char[] returnQualification, char[] returnSimpleName, char[][] parameterQualifications, char[][] parameterSimpleNames, IType declaringType) {
        super(matchMode, isCaseSensitive);
        this.selector = isCaseSensitive ? selector : CharOperation.toLowerCase(selector);
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = isCaseSensitive ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.returnQualification = isCaseSensitive ? returnQualification : CharOperation.toLowerCase(returnQualification);
        char[] cArray = this.returnSimpleName = isCaseSensitive ? returnSimpleName : CharOperation.toLowerCase(returnSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterQualifications = new char[parameterSimpleNames.length][];
            this.parameterSimpleNames = new char[parameterSimpleNames.length][];
            int i = 0;
            int max = parameterSimpleNames.length;
            while (i < max) {
                this.parameterQualifications[i] = isCaseSensitive ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = isCaseSensitive ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
                ++i;
            }
        }
        this.declaringType = declaringType;
        this.needsResolve = this.needsResolve();
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', word);
        this.decodedParameterCount = Integer.parseInt(new String(word, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.decodedSelector = CharOperation.subarray(word, IIndexConstants.METHOD_REF.length, lastSeparatorIndex);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptMethodReference(path, this.decodedSelector, this.decodedParameterCount);
            }
            ++i;
        }
    }

    public String getPatternName() {
        return "MethodReferencePattern: ";
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestMethodReferencePrefix(this.selector, this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length, this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 12;
    }

    public void initializePolymorphicSearch(MatchLocator locator, IProgressMonitor progressMonitor) {
        try {
            this.allSuperDeclaringTypeNames = new SuperTypeNamesCollector(this, this.declaringSimpleName, this.declaringQualification, locator, this.declaringType, progressMonitor).collect();
        }
        catch (JavaModelException javaModelException) {}
    }

    public boolean isPolymorphicSearch() {
        return true;
    }

    private boolean isVirtualInvoke(MethodBinding method, MessageSend messageSend) {
        return !method.isStatic() && !messageSend.isSuperAccess() && !method.isPrivate();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        int argumentCount;
        if (!(node instanceof MessageSend)) {
            return 0;
        }
        MessageSend messageSend = (MessageSend)node;
        if (resolve) {
            return this.matchLevel(messageSend.binding, messageSend);
        }
        if (this.selector != null && !this.matchesName(this.selector, messageSend.selector)) {
            return 0;
        }
        int n = argumentCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (argumentCount > -1) {
            int parameterCount;
            int n2 = parameterCount = messageSend.arguments == null ? 0 : messageSend.arguments.length;
            if (parameterCount != argumentCount) {
                return 0;
            }
        }
        return this.needsResolve ? 1 : 2;
    }

    public int matchLevel(Binding binding, MessageSend messageSend) {
        int argumentCount;
        int level;
        ReferenceBinding receiverType;
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        if (this.selector != null && !this.matchesName(this.selector, method.selector)) {
            return 0;
        }
        ReferenceBinding referenceBinding = receiverType = binding == null ? null : method.declaringClass;
        if (this.isVirtualInvoke(method, messageSend) && !(messageSend.receiverType instanceof ArrayBinding) ? (level = this.matchLevelAsSubtype(receiverType, this.declaringSimpleName, this.declaringQualification)) == 0 && (level = this.matchLevelForType(this.allSuperDeclaringTypeNames, receiverType)) == 0 : (level = this.matchLevelForType(this.declaringSimpleName, this.declaringQualification, receiverType)) == 0) {
            return 0;
        }
        if (this.declaringSimpleName == null) {
            int newLevel = this.matchLevelForType(this.returnSimpleName, this.returnQualification, method.returnType);
            switch (newLevel) {
                case 0: {
                    return 0;
                }
                case 2: {
                    break;
                }
                default: {
                    level = newLevel;
                }
            }
        }
        int n = argumentCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (argumentCount > -1) {
            if (method.parameters == null) {
                level = 3;
            } else {
                int parameterCount = method.parameters.length;
                if (parameterCount != argumentCount) {
                    return 0;
                }
                int i = 0;
                while (i < parameterCount) {
                    char[] qualification = this.parameterQualifications[i];
                    char[] type = this.parameterSimpleNames[i];
                    int newLevel = this.matchLevelForType(type, qualification, method.parameters[i]);
                    switch (newLevel) {
                        case 0: {
                            return 0;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            level = newLevel;
                        }
                    }
                    ++i;
                }
            }
        }
        return level;
    }

    protected void matchReportReference(AstNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (reference instanceof MessageSend) {
            locator.report((int)(((MessageSend)reference).nameSourcePosition >> 32), reference.sourceEnd, element, accuracy);
        } else {
            super.matchReportReference(reference, element, accuracy, locator);
        }
    }
}

