/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchSet;
import org.eclipse.jdt.internal.core.search.matching.MultipleSearchPattern;

public class FieldReferencePattern
extends MultipleSearchPattern {
    protected char[] name;
    protected char[] declaringQualification;
    protected char[] declaringSimpleName;
    protected char[] typeQualification;
    protected char[] typeSimpleName;
    protected boolean readAccess = true;
    protected boolean writeAccess = true;
    protected char[] decodedName;
    private static char[][] REF_TAGS = new char[][]{IIndexConstants.FIELD_REF, IIndexConstants.REF};
    private static char[][] REF_AND_DECL_TAGS = new char[][]{IIndexConstants.FIELD_REF, IIndexConstants.REF, IIndexConstants.FIELD_DECL};

    public FieldReferencePattern(char[] name, int matchMode, boolean isCaseSensitive, char[] declaringQualification, char[] declaringSimpleName, char[] typeQualification, char[] typeSimpleName, boolean readAccess, boolean writeAccess) {
        super(matchMode, isCaseSensitive);
        this.name = isCaseSensitive ? name : CharOperation.toLowerCase(name);
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = isCaseSensitive ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.typeQualification = isCaseSensitive ? typeQualification : CharOperation.toLowerCase(typeQualification);
        this.typeSimpleName = isCaseSensitive ? typeSimpleName : CharOperation.toLowerCase(typeSimpleName);
        this.readAccess = readAccess;
        this.writeAccess = writeAccess;
        this.needsResolve = true;
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int tagLength = this.currentTag.length;
        int nameLength = CharOperation.indexOf('/', word, tagLength);
        if (nameLength < 0) {
            nameLength = size;
        }
        this.decodedName = CharOperation.subarray(word, tagLength, nameLength);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        if (this.currentTag == IIndexConstants.REF) {
            this.foundAmbiguousIndexMatches = true;
        }
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file;
            int reference = references[i];
            if (reference != -1 && (file = input.getIndexedFile(reference)) != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptFieldReference(path, this.decodedName);
            }
            ++i;
        }
    }

    protected char[][] getPossibleTags() {
        if (this.writeAccess && !this.readAccess) {
            return REF_AND_DECL_TAGS;
        }
        return REF_TAGS;
    }

    protected boolean hasNextQuery() {
        return false;
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestReferencePrefix(this.currentTag, this.name, this.matchMode, this.isCaseSensitive);
    }

    protected void matchCheck(AstNode node, MatchSet set) {
        if (this.readAccess) {
            super.matchCheck(node, set);
        }
        if (node instanceof Assignment) {
            Expression lhs = ((Assignment)node).lhs;
            if (this.writeAccess) {
                super.matchCheck(lhs, set);
            } else if (!(node instanceof CompoundAssignment)) {
                set.removePossibleMatch(lhs);
                set.removeTrustedMatch(lhs);
            }
        } else if (node instanceof FieldDeclaration) {
            super.matchCheck(node, set);
        }
    }

    protected int matchContainer() {
        int matchContainer = 12;
        if (this.writeAccess && !this.readAccess) {
            matchContainer |= 2;
        }
        return matchContainer;
    }

    protected boolean matchIndexEntry() {
        if (this.name != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.name, this.decodedName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.name, this.decodedName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.name, this.decodedName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return true;
    }

    protected void matchReportReference(AstNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (reference instanceof QualifiedNameReference) {
            QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
            int length = qNameRef.tokens.length;
            int[] accuracies = new int[length];
            Binding binding = qNameRef.binding;
            int indexOfFirstFieldBinding = qNameRef.indexOfFirstFieldBinding > 0 ? qNameRef.indexOfFirstFieldBinding - 1 : 0;
            int i = 0;
            while (i < indexOfFirstFieldBinding) {
                accuracies[i] = -1;
                ++i;
            }
            if (this.matchesName(this.name, qNameRef.tokens[indexOfFirstFieldBinding]) && !(binding instanceof LocalVariableBinding)) {
                FieldBinding fieldBinding;
                FieldBinding fieldBinding2 = fieldBinding = binding instanceof FieldBinding ? (FieldBinding)binding : null;
                if (fieldBinding == null) {
                    accuracies[indexOfFirstFieldBinding] = accuracy;
                } else {
                    int level = this.matchLevel(fieldBinding);
                    switch (level) {
                        case 2: {
                            accuracies[indexOfFirstFieldBinding] = 0;
                            break;
                        }
                        case 3: {
                            accuracies[indexOfFirstFieldBinding] = 1;
                            break;
                        }
                        default: {
                            accuracies[indexOfFirstFieldBinding] = -1;
                            break;
                        }
                    }
                }
            } else {
                accuracies[indexOfFirstFieldBinding] = -1;
            }
            i = indexOfFirstFieldBinding + 1;
            while (i < length) {
                char[] token = qNameRef.tokens[i];
                if (this.matchesName(this.name, token)) {
                    FieldBinding otherBinding;
                    FieldBinding fieldBinding = otherBinding = qNameRef.otherBindings == null ? null : qNameRef.otherBindings[i - (indexOfFirstFieldBinding + 1)];
                    if (otherBinding == null) {
                        accuracies[i] = accuracy;
                    } else {
                        int level = this.matchLevel(otherBinding);
                        switch (level) {
                            case 2: {
                                accuracies[i] = 0;
                                break;
                            }
                            case 3: {
                                accuracies[i] = 1;
                                break;
                            }
                            default: {
                                accuracies[i] = -1;
                                break;
                            }
                        }
                    }
                } else {
                    accuracies[i] = -1;
                }
                ++i;
            }
            locator.reportAccurateReference(reference.sourceStart, reference.sourceEnd, qNameRef.tokens, element, accuracies);
        } else {
            locator.reportAccurateReference(reference.sourceStart, reference.sourceEnd, (char[][])new char[][]{this.name}, element, accuracy);
        }
    }

    protected void resetQuery() {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("FieldReferencePattern: ");
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            buffer.append("*.");
        }
        if (this.name != null) {
            buffer.append(this.name);
        } else {
            buffer.append("*");
        }
        if (this.typeQualification != null) {
            buffer.append(" --> ").append(this.typeQualification).append('.');
        } else if (this.typeSimpleName != null) {
            buffer.append(" --> ");
        }
        if (this.typeSimpleName != null) {
            buffer.append(this.typeSimpleName);
        } else if (this.typeQualification != null) {
            buffer.append("*");
        }
        buffer.append(", ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    public int matchLevel(AstNode node, boolean resolve) {
        if (node instanceof FieldReference) {
            return this.matchLevel((FieldReference)node, resolve);
        }
        if (node instanceof NameReference) {
            return this.matchLevel((NameReference)node, resolve);
        }
        if (node instanceof FieldDeclaration) {
            return this.matchLevel((FieldDeclaration)node, resolve);
        }
        return 0;
    }

    private int matchLevel(FieldReference fieldRef, boolean resolve) {
        if (!this.matchesName(this.name, fieldRef.token)) {
            return 0;
        }
        if (resolve) {
            return this.matchLevel(fieldRef.binding);
        }
        return this.needsResolve ? 1 : 2;
    }

    private int matchLevel(FieldDeclaration fieldDecl, boolean resolve) {
        if (!this.writeAccess || this.readAccess) {
            return 0;
        }
        if (fieldDecl.initialization == null) {
            return 0;
        }
        if (!this.matchesName(this.name, fieldDecl.name)) {
            return 0;
        }
        if (resolve) {
            return this.matchLevel(fieldDecl.binding);
        }
        return this.needsResolve ? 1 : 2;
    }

    private int matchLevel(NameReference nameRef, boolean resolve) {
        if (!resolve) {
            if (this.name == null) {
                return this.needsResolve ? 1 : 2;
            }
            if (nameRef instanceof SingleNameReference) {
                if (this.matchesName(this.name, ((SingleNameReference)nameRef).token)) {
                    return 1;
                }
                return 0;
            }
            QualifiedNameReference qNameRef = (QualifiedNameReference)nameRef;
            char[][] tokens = qNameRef.tokens;
            if (this.writeAccess && !this.readAccess) {
                if (this.matchesName(this.name, tokens[tokens.length - 1])) {
                    return 1;
                }
            } else {
                int i = 0;
                int max = tokens.length;
                while (i < max) {
                    if (this.matchesName(this.name, tokens[i])) {
                        return 1;
                    }
                    ++i;
                }
            }
            return 0;
        }
        Binding binding = nameRef.binding;
        if (binding == null) {
            return 3;
        }
        if (nameRef instanceof SingleNameReference) {
            if (binding instanceof FieldBinding) {
                return this.matchLevel((FieldBinding)binding);
            }
            return 0;
        }
        QualifiedNameReference qNameRef = (QualifiedNameReference)nameRef;
        FieldBinding fieldBinding = null;
        if (binding instanceof FieldBinding) {
            fieldBinding = (FieldBinding)binding;
            char[] name = fieldBinding.name;
            int lastDot = CharOperation.lastIndexOf('.', name);
            if (lastDot > -1) {
                name = CharOperation.subarray(name, lastDot + 1, name.length);
            }
            if (this.matchesName(this.name, name)) {
                return this.matchLevel(fieldBinding);
            }
        }
        int otherLevel = 0;
        int otherMax = qNameRef.otherBindings == null ? 0 : qNameRef.otherBindings.length;
        int i = 0;
        while (i < otherMax && otherLevel == 0) {
            char[] token = qNameRef.tokens[i + qNameRef.indexOfFirstFieldBinding];
            if (this.matchesName(this.name, token)) {
                FieldBinding otherBinding = qNameRef.otherBindings[i];
                otherLevel = this.matchLevel(otherBinding);
            }
            ++i;
        }
        return otherLevel;
    }

    private int matchLevel(FieldBinding binding) {
        if (binding == null) {
            return 3;
        }
        ReferenceBinding receiverBinding = binding.declaringClass;
        if (receiverBinding == null) {
            if (binding == ArrayBinding.LengthField) {
                if (this.declaringQualification == null && this.declaringSimpleName == null) {
                    return 2;
                }
                return 0;
            }
            return 3;
        }
        int level = this.matchLevelForType(this.declaringSimpleName, this.declaringQualification, receiverBinding);
        if (level == 0) {
            return 0;
        }
        if (this.declaringSimpleName == null) {
            int newLevel = this.matchLevelForType(this.typeSimpleName, this.typeQualification, binding.type);
            switch (newLevel) {
                case 0: {
                    return 0;
                }
                case 2: {
                    break;
                }
                default: {
                    level = newLevel;
                }
            }
        }
        return level;
    }
}

