/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.MethodReferencePattern;

public class ConstructorReferencePattern
extends MethodReferencePattern {
    private char[] decodedTypeName;

    public ConstructorReferencePattern(char[] declaringSimpleName, int matchMode, boolean isCaseSensitive, char[] declaringQualification, char[][] parameterQualifications, char[][] parameterSimpleNames, IType declaringType) {
        super(null, matchMode, isCaseSensitive, declaringQualification, declaringSimpleName, null, null, parameterQualifications, parameterSimpleNames, declaringType);
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', word);
        this.decodedParameterCount = Integer.parseInt(new String(word, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.decodedTypeName = CharOperation.subarray(word, IIndexConstants.CONSTRUCTOR_REF.length, lastSeparatorIndex);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptConstructorReference(path, this.decodedTypeName, this.decodedParameterCount);
            }
            ++i;
        }
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestConstructorReferencePrefix(this.declaringSimpleName, this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length, this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 15;
    }

    protected boolean matchIndexEntry() {
        if (this.declaringSimpleName != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.declaringSimpleName, this.decodedTypeName, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.declaringSimpleName, this.decodedTypeName, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.declaringSimpleName, this.decodedTypeName, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return this.parameterSimpleNames == null || this.parameterSimpleNames.length == this.decodedParameterCount;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("ConstructorReferencePattern: ");
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            buffer.append("*");
        }
        buffer.append('(');
        if (this.parameterSimpleNames == null) {
            buffer.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    buffer.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    buffer.append('*');
                } else {
                    buffer.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        buffer.append(", ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }

    private int matchLevel(AllocationExpression allocation, boolean resolve) {
        int argumentCount;
        char[][] typeName = allocation.type.getTypeName();
        if (this.declaringSimpleName != null && !this.matchesName(this.declaringSimpleName, typeName[typeName.length - 1])) {
            return 0;
        }
        if (resolve) {
            return this.matchLevel(allocation.binding);
        }
        int n = argumentCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (argumentCount > -1) {
            int parameterCount;
            int n2 = parameterCount = allocation.arguments == null ? 0 : allocation.arguments.length;
            if (parameterCount != argumentCount) {
                return 0;
            }
        }
        return this.needsResolve ? 1 : 2;
    }

    public int matchLevel(AstNode node, boolean resolve) {
        if (node instanceof AllocationExpression) {
            return this.matchLevel((AllocationExpression)node, resolve);
        }
        if (node instanceof ExplicitConstructorCall) {
            return this.matchLevel((ExplicitConstructorCall)node, resolve);
        }
        if (node instanceof ConstructorDeclaration) {
            return this.matchLevel((ConstructorDeclaration)node, resolve);
        }
        if (node instanceof TypeDeclaration) {
            return this.matchLevel((TypeDeclaration)node, resolve);
        }
        return 0;
    }

    private int matchLevel(ConstructorDeclaration constructor, boolean resolve) {
        ExplicitConstructorCall constructorCall = constructor.constructorCall;
        if (constructorCall != null && constructorCall.accessMode == 1) {
            return this.matchLevel(constructorCall, resolve);
        }
        return 0;
    }

    private int matchLevel(ExplicitConstructorCall call, boolean resolve) {
        int argumentCount;
        if (resolve) {
            return this.matchLevel(call.binding);
        }
        int n = argumentCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (argumentCount > -1) {
            int parameterCount;
            int n2 = parameterCount = call.arguments == null ? 0 : call.arguments.length;
            if (parameterCount != argumentCount) {
                return 0;
            }
        }
        return this.needsResolve ? 1 : 2;
    }

    private int matchLevel(TypeDeclaration type, boolean resolve) {
        if (resolve) {
            AbstractMethodDeclaration[] methods = type.methods;
            if (methods != null) {
                int i = 0;
                int length = methods.length;
                while (i < length) {
                    AbstractMethodDeclaration method = methods[i];
                    if (method.isDefaultConstructor() && method.sourceStart < type.bodyStart) {
                        return this.matchLevel((ConstructorDeclaration)method, true);
                    }
                    ++i;
                }
            }
            return 0;
        }
        return this.needsResolve ? 1 : 2;
    }

    public int matchLevel(Binding binding) {
        int argumentCount;
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        ReferenceBinding declaringBinding = method.declaringClass;
        int level = this.matchLevelForType(this.declaringSimpleName, this.declaringQualification, declaringBinding);
        if (level == 0) {
            return 0;
        }
        int n = argumentCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (argumentCount > -1) {
            if (method.parameters == null) {
                level = 3;
            } else {
                int parameterCount = method.parameters.length;
                if (parameterCount != argumentCount) {
                    return 0;
                }
                int i = 0;
                while (i < parameterCount) {
                    char[] qualification = this.parameterQualifications[i];
                    char[] type = this.parameterSimpleNames[i];
                    int newLevel = this.matchLevelForType(type, qualification, method.parameters[i]);
                    switch (newLevel) {
                        case 0: {
                            return 0;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            level = newLevel;
                        }
                    }
                    ++i;
                }
            }
        }
        return level;
    }
}

