/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.Util;

class JavaProjectElementInfo
extends OpenableElementInfo {
    protected NameLookup fNameLookup = null;
    protected SearchableEnvironment fSearchableEnvironment = null;
    private Object[] fNonJavaResources = null;

    private Object[] computeNonJavaResources(JavaProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        boolean binIsProject = false;
        char[][] exclusionPatterns = null;
        IClasspathEntry[] classpath = null;
        IPath projectOutput = null;
        try {
            classpath = project.getResolvedClasspath(true);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (projectPath.equals((Object)entry.getPath())) {
                    srcIsProject = true;
                    exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                    break;
                }
                ++i;
            }
            projectOutput = project.getOutputLocation();
            binIsProject = projectPath.equals((Object)projectOutput);
        }
        catch (JavaModelException javaModelException) {}
        Object[] nonJavaResources = new IResource[5];
        int nonJavaResourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        String resName = res.getName();
                        if (Util.isArchiveFileName(resName) && this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput) || srcIsProject && Util.isValidCompilationUnitName(resName) && !Util.isExcluded(res, exclusionPatterns) || binIsProject && Util.isValidClassFileName(resName)) break;
                        if (nonJavaResources.length == nonJavaResourcesCounter) {
                            Object[] objectArray = nonJavaResources;
                            nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                        }
                        nonJavaResources[nonJavaResourcesCounter++] = res;
                        break;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName()) || this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput)) break;
                        if (nonJavaResources.length == nonJavaResourcesCounter) {
                            Object[] objectArray = nonJavaResources;
                            nonJavaResources = new IResource[nonJavaResourcesCounter * 2];
                            System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
                        }
                        nonJavaResources[nonJavaResourcesCounter++] = res;
                    }
                }
                ++i;
            }
            if (nonJavaResources.length != nonJavaResourcesCounter) {
                Object[] objectArray = nonJavaResources;
                nonJavaResources = new IResource[nonJavaResourcesCounter];
                System.arraycopy(objectArray, 0, nonJavaResources, 0, nonJavaResourcesCounter);
            }
        }
        catch (CoreException coreException) {
            nonJavaResources = JavaElementInfo.NO_NON_JAVA_RESOURCES;
            nonJavaResourcesCounter = 0;
        }
        return nonJavaResources;
    }

    protected NameLookup getNameLookup() {
        return this.fNameLookup;
    }

    Object[] getNonJavaResources(JavaProject project) {
        Object[] nonJavaResources = this.fNonJavaResources;
        if (nonJavaResources == null) {
            nonJavaResources = this.computeNonJavaResources(project);
            this.fNonJavaResources = nonJavaResources;
        }
        return nonJavaResources;
    }

    protected SearchableEnvironment getSearchableEnvironment() {
        return this.fSearchableEnvironment;
    }

    private boolean isClasspathEntryOrOutputLocation(IPath path, IClasspathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals((Object)path)) {
            return true;
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output != null && output.equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setNameLookup(NameLookup newNameLookup) {
        this.fNameLookup = newNameLookup;
        this.fSearchableEnvironment = null;
    }

    synchronized void setNonJavaResources(Object[] resources) {
        this.fNonJavaResources = resources;
    }

    protected void setSearchableEnvironment(SearchableEnvironment newSearchableEnvironment) {
        this.fSearchableEnvironment = newSearchableEnvironment;
    }
}

