/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.util.PerThreadObject;

public abstract class JavaModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static final int APPEND = 1;
    protected static final int REMOVEALL_APPEND = 2;
    protected static final int KEEP_EXISTING = 3;
    protected static boolean POST_ACTION_VERBOSE;
    protected IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap attributes;
    public static final String HAS_MODIFIED_RESOURCE_ATTR = "hasModifiedResource";
    public static final String TRUE = "true";
    protected IJavaElement[] fElementsToProcess;
    protected IJavaElement[] fParentElements;
    protected static IJavaElement[] fgEmptyResult;
    protected IJavaElement[] fResultElements = fgEmptyResult;
    protected IProgressMonitor fMonitor = null;
    protected boolean fNested = false;
    protected boolean fForce = false;
    protected static PerThreadObject operationStacks;

    static {
        fgEmptyResult = new IJavaElement[0];
        operationStacks = new PerThreadObject();
    }

    protected JavaModelOperation() {
    }

    protected JavaModelOperation(IJavaElement[] elements) {
        this.fElementsToProcess = elements;
    }

    protected JavaModelOperation(IJavaElement[] elementsToProcess, IJavaElement[] parentElements) {
        this.fElementsToProcess = elementsToProcess;
        this.fParentElements = parentElements;
    }

    protected JavaModelOperation(IJavaElement[] elementsToProcess, IJavaElement[] parentElements, boolean force) {
        this.fElementsToProcess = elementsToProcess;
        this.fParentElements = parentElements;
        this.fForce = force;
    }

    protected JavaModelOperation(IJavaElement[] elements, boolean force) {
        this.fElementsToProcess = elements;
        this.fForce = force;
    }

    protected JavaModelOperation(IJavaElement element) {
        this.fElementsToProcess = new IJavaElement[]{element};
    }

    protected JavaModelOperation(IJavaElement element, boolean force) {
        this.fElementsToProcess = new IJavaElement[]{element};
        this.fForce = force;
    }

    protected void addAction(IPostAction action) {
        int length = this.actions.length;
        if (length == ++this.actionsEnd) {
            this.actions = new IPostAction[length * 2];
            System.arraycopy(this.actions, 0, this.actions, 0, length);
        }
        this.actions[this.actionsEnd] = action;
    }

    protected void addDelta(IJavaElementDelta delta) {
        JavaModelManager.getJavaModelManager().registerJavaModelDelta(delta);
    }

    protected void addReconcileDelta(IWorkingCopy workingCopy, IJavaElementDelta delta) {
        HashMap reconcileDeltas = JavaModelManager.getJavaModelManager().reconcileDeltas;
        JavaElementDelta previousDelta = (JavaElementDelta)reconcileDeltas.get(workingCopy);
        if (previousDelta != null) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                JavaElementDelta child = (JavaElementDelta)children[i];
                previousDelta.insertDeltaTree(child.getElement(), child);
                ++i;
            }
        } else {
            reconcileDeltas.put(workingCopy, delta);
        }
    }

    protected void removeReconcileDelta(IWorkingCopy workingCopy) {
        JavaModelManager.getJavaModelManager().reconcileDeltas.remove(workingCopy);
    }

    public void beginTask(String name, int totalWork) {
        if (this.fMonitor != null) {
            this.fMonitor.beginTask(name, totalWork);
        }
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(Util.bind("operation.cancelled"));
        }
    }

    protected IJavaModelStatus commonVerify() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return new JavaModelStatus(968);
        }
        int i = 0;
        while (i < this.fElementsToProcess.length) {
            if (this.fElementsToProcess[i] == null) {
                return new JavaModelStatus(968);
            }
            ++i;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] resources, IPath destinationPath) throws JavaModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.copy(resources, destinationPath, false, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected void createFile(IContainer folder, String name, InputStream contents, boolean force) throws JavaModelException {
        IFile file = folder.getFile((IPath)new Path(name));
        try {
            file.create(contents, force ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected void createFolder(IContainer parentFolder, String name, boolean force) throws JavaModelException {
        IFolder folder = parentFolder.getFolder((IPath)new Path(name));
        try {
            folder.create(force ? 3 : 2, true, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected void deleteEmptyPackageFragment(IPackageFragment fragment, boolean force, IResource rootResource) throws JavaModelException {
        IContainer resource = (IContainer)fragment.getResource();
        try {
            resource.delete(force ? 3 : 2, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            while (resource instanceof IFolder) {
                if ((resource = resource.getParent()).equals((Object)rootResource) || resource.members().length != 0) continue;
                resource.delete(force ? 3 : 2, this.getSubProgressMonitor(1));
                this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected void deleteResource(IResource resource, int flags) throws JavaModelException {
        try {
            resource.delete(flags, this.getSubProgressMonitor(1));
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected void deleteResources(IResource[] resources, boolean force) throws JavaModelException {
        if (resources == null || resources.length == 0) {
            return;
        }
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(resources.length);
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.delete(resources, force ? 3 : 2, subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void done() {
        if (this.fMonitor != null) {
            this.fMonitor.done();
        }
    }

    protected boolean equalsOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.equals((Object)otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void execute() throws JavaModelException {
        IJavaModelStatus status = this.verify();
        if (status.isOK()) {
            DeltaProcessor deltaProcessor = JavaModelManager.getJavaModelManager().deltaProcessor;
            if (deltaProcessor.roots == null) {
                deltaProcessor.initializeRoots();
            }
        } else {
            throw new JavaModelException(status);
        }
        this.executeOperation();
    }

    public void executeNestedOperation(JavaModelOperation operation, int subWorkAmount) throws JavaModelException {
        IProgressMonitor subProgressMonitor = this.getSubProgressMonitor(subWorkAmount);
        try {
            operation.setNested(true);
            operation.run(subProgressMonitor);
        }
        catch (CoreException ce) {
            Throwable e;
            if (ce instanceof JavaModelException) {
                throw (JavaModelException)ce;
            }
            if (ce.getStatus().getCode() == 76 && (e = ce.getStatus().getException()) instanceof JavaModelException) {
                throw (JavaModelException)((Object)e);
            }
            throw new JavaModelException(ce);
        }
    }

    protected abstract void executeOperation() throws JavaModelException;

    protected Object getAttribute(Object key) {
        ArrayList stack = this.getCurrentOperationStack();
        if (stack.size() == 0) {
            return null;
        }
        JavaModelOperation topLevelOp = (JavaModelOperation)stack.get(0);
        if (topLevelOp.attributes == null) {
            return null;
        }
        return topLevelOp.attributes.get(key);
    }

    protected ICompilationUnit getCompilationUnitFor(IJavaElement element) {
        return ((JavaElement)element).getCompilationUnit();
    }

    protected ArrayList getCurrentOperationStack() {
        ArrayList stack = (ArrayList)operationStacks.getCurrent();
        if (stack == null) {
            stack = new ArrayList();
            operationStacks.setCurrent(stack);
        }
        return stack;
    }

    protected IJavaElement[] getElementsToProcess() {
        return this.fElementsToProcess;
    }

    protected IJavaElement getElementToProcess() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return null;
        }
        return this.fElementsToProcess[0];
    }

    public IJavaModel getJavaModel() {
        if (this.fElementsToProcess == null || this.fElementsToProcess.length == 0) {
            return this.getParentElement().getJavaModel();
        }
        return this.fElementsToProcess[0].getJavaModel();
    }

    protected IPath[] getNestedFolders(IPackageFragmentRoot root) throws JavaModelException {
        IPath rootPath = root.getPath();
        IClasspathEntry[] classpath = root.getJavaProject().getRawClasspath();
        int length = classpath.length;
        IPath[] result = new IPath[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IPath path = classpath[i].getPath();
            if (rootPath.isPrefixOf(path) && !rootPath.equals((Object)path)) {
                result[index++] = path;
            }
            ++i;
        }
        if (index < length) {
            IPath[] iPathArray = result;
            result = new IPath[index];
            System.arraycopy(iPathArray, 0, result, 0, index);
        }
        return result;
    }

    protected IJavaElement getParentElement() {
        if (this.fParentElements == null || this.fParentElements.length == 0) {
            return null;
        }
        return this.fParentElements[0];
    }

    protected IJavaElement[] getParentElements() {
        return this.fParentElements;
    }

    public IJavaElement[] getResultElements() {
        return this.fResultElements;
    }

    protected IProgressMonitor getSubProgressMonitor(int workAmount) {
        SubProgressMonitor sub = null;
        if (this.fMonitor != null) {
            sub = new SubProgressMonitor(this.fMonitor, workAmount, 4);
        }
        return sub;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && this.getAttribute(HAS_MODIFIED_RESOURCE_ATTR) == TRUE;
    }

    public void internalWorked(double work) {
        if (this.fMonitor != null) {
            this.fMonitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        if (this.fMonitor != null) {
            return this.fMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList stack = this.getCurrentOperationStack();
        return stack.size() > 0 && stack.get(0) == this;
    }

    protected int firstActionWithID(String id, int start) {
        int i = start;
        while (i <= this.actionsEnd) {
            if (this.actions[i].getID().equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void moveResources(IResource[] resources, IPath destinationPath) throws JavaModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.fMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.fMonitor, resources.length, 4);
        }
        IWorkspace workspace = resources[0].getWorkspace();
        try {
            workspace.move(resources, destinationPath, false, (IProgressMonitor)subProgressMonitor);
            this.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public JavaElementDelta newJavaElementDelta() {
        return new JavaElementDelta(this.getJavaModel());
    }

    protected JavaModelOperation popOperation() {
        ArrayList stack = this.getCurrentOperationStack();
        int size = stack.size();
        if (size > 0) {
            if (size == 1) {
                operationStacks.setCurrent(null);
            }
            return (JavaModelOperation)stack.remove(size - 1);
        }
        return null;
    }

    protected void postAction(IPostAction action, int insertionMode) {
        if (POST_ACTION_VERBOSE) {
            System.out.print("(" + Thread.currentThread() + ") [JavaModelOperation.postAction(IPostAction, int)] Posting action " + action.getID());
            switch (insertionMode) {
                case 2: {
                    System.out.println(" (REMOVEALL_APPEND)");
                    break;
                }
                case 3: {
                    System.out.println(" (KEEP_EXISTING)");
                    break;
                }
                case 1: {
                    System.out.println(" (APPEND)");
                }
            }
        }
        JavaModelOperation topLevelOp = (JavaModelOperation)this.getCurrentOperationStack().get(0);
        IPostAction[] postActions = topLevelOp.actions;
        if (postActions == null) {
            topLevelOp.actions = postActions = new IPostAction[1];
            postActions[0] = action;
            topLevelOp.actionsEnd = 0;
        } else {
            String id = action.getID();
            switch (insertionMode) {
                case 2: {
                    int index = this.actionsStart - 1;
                    while ((index = topLevelOp.firstActionWithID(id, index + 1)) >= 0) {
                        System.arraycopy(postActions, index + 1, postActions, index, topLevelOp.actionsEnd - index);
                        postActions[topLevelOp.actionsEnd--] = null;
                    }
                    topLevelOp.addAction(action);
                    break;
                }
                case 3: {
                    if (topLevelOp.firstActionWithID(id, 0) >= 0) break;
                    topLevelOp.addAction(action);
                    break;
                }
                case 1: {
                    topLevelOp.addAction(action);
                }
            }
        }
    }

    protected boolean prefixesOneOf(IPath path, IPath[] otherPaths) {
        int i = 0;
        int length = otherPaths.length;
        while (i < length) {
            if (path.isPrefixOf(otherPaths[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void pushOperation(JavaModelOperation operation) {
        this.getCurrentOperationStack().add(operation);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        int previousDeltaCount;
        JavaModelManager manager;
        block13: {
            manager = JavaModelManager.getJavaModelManager();
            previousDeltaCount = manager.javaModelDeltas.size();
            try {
                this.fMonitor = monitor;
                this.pushOperation(this);
                try {
                    this.execute();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (this.isTopLevelOperation()) {
                        this.runPostActions();
                    }
                    throw throwable;
                }
                Object var4_6 = null;
                if (this.isTopLevelOperation()) {
                    this.runPostActions();
                }
                break block13;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    int i = previousDeltaCount;
                    int size = manager.javaModelDeltas.size();
                    while (i < size) {
                        manager.updateJavaModel((IJavaElementDelta)manager.javaModelDeltas.get(i));
                        ++i;
                    }
                    if (!(!this.isTopLevelOperation() || manager.javaModelDeltas.size() <= previousDeltaCount && manager.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                        manager.fire(null, 0);
                    }
                }
                catch (Throwable throwable2) {
                    Object var10_16 = null;
                    this.popOperation();
                    throw throwable2;
                }
            }
            Object var10_17 = null;
            this.popOperation();
            throw throwable;
        }
        Object var6_9 = null;
        try {
            int i = previousDeltaCount;
            int size = manager.javaModelDeltas.size();
            while (i < size) {
                manager.updateJavaModel((IJavaElementDelta)manager.javaModelDeltas.get(i));
                ++i;
            }
            if (!(!this.isTopLevelOperation() || manager.javaModelDeltas.size() <= previousDeltaCount && manager.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                manager.fire(null, 0);
            }
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            this.popOperation();
            throw throwable;
        }
        Object var10_19 = null;
        this.popOperation();
    }

    protected void runPostActions() throws JavaModelException {
        while (this.actionsStart <= this.actionsEnd) {
            IPostAction postAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelOperation.runPostActions()] Running action " + postAction.getID());
            }
            postAction.run();
        }
    }

    protected void setAttribute(Object key, Object attribute) {
        JavaModelOperation topLevelOp = (JavaModelOperation)this.getCurrentOperationStack().get(0);
        if (topLevelOp.attributes == null) {
            topLevelOp.attributes = new HashMap();
        }
        topLevelOp.attributes.put(key, attribute);
    }

    public void setCanceled(boolean b) {
        if (this.fMonitor != null) {
            this.fMonitor.setCanceled(b);
        }
    }

    protected void setNested(boolean nested) {
        this.fNested = nested;
    }

    public void setTaskName(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.subTask(name);
        }
    }

    protected IJavaModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int work) {
        if (this.fMonitor != null) {
            this.fMonitor.worked(work);
            this.checkCanceled();
        }
    }

    protected interface IPostAction {
        public String getID();

        public void run() throws JavaModelException;
    }
}

