/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.jdt.internal.compiler.parser.RecoveredLocalVariable;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredBlock
extends RecoveredStatement
implements CompilerModifiers,
TerminalTokens,
BaseTypes {
    public Block blockDeclaration;
    public RecoveredStatement[] statements;
    public int statementCount;
    public boolean preserveContent = false;
    public RecoveredLocalVariable pendingArgument;

    public RecoveredBlock(Block block, RecoveredElement parent, int bracketBalance) {
        super(block, parent, bracketBalance);
        this.blockDeclaration = block;
        this.foundOpeningBrace = true;
    }

    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalance) {
        if (this.blockDeclaration.sourceEnd != 0 && nestedBlockDeclaration.sourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(nestedBlockDeclaration, bracketBalance);
        }
        RecoveredBlock element = new RecoveredBlock(nestedBlockDeclaration, (RecoveredElement)this, bracketBalance);
        if (this.pendingArgument != null) {
            element.attach(this.pendingArgument);
            this.pendingArgument = null;
        }
        this.attach(element);
        if (nestedBlockDeclaration.sourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int bracketBalance) {
        return this.add(localDeclaration, bracketBalance, false);
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int bracketBalance, boolean delegatedByParent) {
        if (this.blockDeclaration.sourceEnd != 0 && localDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (delegatedByParent) {
                return this;
            }
            return this.parent.add(localDeclaration, bracketBalance);
        }
        RecoveredLocalVariable element = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, bracketBalance);
        if (localDeclaration instanceof Argument) {
            this.pendingArgument = element;
            return this;
        }
        this.attach(element);
        if (localDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(Statement statement, int bracketBalance) {
        return this.add(statement, bracketBalance, false);
    }

    public RecoveredElement add(Statement statement, int bracketBalance, boolean delegatedByParent) {
        if (this.blockDeclaration.sourceEnd != 0 && statement.sourceStart > this.blockDeclaration.sourceEnd) {
            if (delegatedByParent) {
                return this;
            }
            return this.parent.add(statement, bracketBalance);
        }
        RecoveredStatement element = new RecoveredStatement(statement, this, bracketBalance);
        this.attach(element);
        if (statement.sourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalance) {
        return this.add(typeDeclaration, bracketBalance, false);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalance, boolean delegatedByParent) {
        if (this.blockDeclaration.sourceEnd != 0 && typeDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (delegatedByParent) {
                return this;
            }
            return this.parent.add(typeDeclaration, bracketBalance);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalance);
        this.attach(element);
        if (typeDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    void attach(RecoveredStatement recoveredStatement) {
        if (this.statements == null) {
            this.statements = new RecoveredStatement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredStatement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = recoveredStatement;
    }

    public AstNode parseTree() {
        return this.blockDeclaration;
    }

    public String toString(int tab) {
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered block:\n");
        result.append(this.blockDeclaration.toString(tab + 1));
        if (this.statements != null) {
            int i = 0;
            while (i < this.statementCount) {
                result.append("\n");
                result.append(this.statements[i].toString(tab + 1));
                ++i;
            }
        }
        return result.toString();
    }

    public Block updatedBlock() {
        if (!this.preserveContent || this.statementCount == 0) {
            return null;
        }
        Statement[] updatedStatements = new Statement[this.statementCount];
        int updatedCount = 0;
        int i = 0;
        while (i < this.statementCount) {
            Statement updatedStatement = this.statements[i].updatedStatement();
            if (updatedStatement != null) {
                updatedStatements[updatedCount++] = updatedStatement;
            }
            ++i;
        }
        if (updatedCount == 0) {
            return null;
        }
        if (updatedCount != this.statementCount) {
            this.blockDeclaration.statements = new Statement[updatedCount];
            System.arraycopy(updatedStatements, 0, this.blockDeclaration.statements, 0, updatedCount);
        } else {
            this.blockDeclaration.statements = updatedStatements;
        }
        return this.blockDeclaration;
    }

    public Statement updatedStatement() {
        return this.updatedBlock();
    }

    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(braceEnd);
            RecoveredMethod method = this.enclosingMethod();
            if (method != null && method.methodBody == this) {
                return this.parent.updateOnClosingBrace(braceStart, braceEnd);
            }
            RecoveredInitializer initializer = this.enclosingInitializer();
            if (initializer != null && initializer.initializerBody == this) {
                return this.parent.updateOnClosingBrace(braceStart, braceEnd);
            }
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int currentPosition) {
        Block block = new Block(0);
        block.sourceStart = this.parser().scanner.startPosition;
        return this.add(block, 1);
    }

    public void updateParseTree() {
        this.updatedBlock();
    }

    public Statement updateStatement() {
        if (this.blockDeclaration.sourceEnd != 0 || this.statementCount == 0) {
            return null;
        }
        Statement[] updatedStatements = new Statement[this.statementCount];
        int updatedCount = 0;
        int i = 0;
        while (i < this.statementCount) {
            Statement updatedStatement = this.statements[i].updatedStatement();
            if (updatedStatement != null) {
                updatedStatements[updatedCount++] = updatedStatement;
            }
            ++i;
        }
        if (updatedCount == 0) {
            return null;
        }
        if (updatedCount != this.statementCount) {
            this.blockDeclaration.statements = new Statement[updatedCount];
            System.arraycopy(updatedStatements, 0, this.blockDeclaration.statements, 0, updatedCount);
        } else {
            this.blockDeclaration.statements = updatedStatements;
        }
        return this.blockDeclaration;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalance) {
        char[][] fieldTypeName;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (fieldTypeName = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(fieldTypeName[0], BaseTypes.VoidBinding.sourceName())) {
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, bracketBalance);
        }
        if (this.blockDeclaration.sourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(fieldDeclaration, bracketBalance);
        }
        return this;
    }
}

