/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class TypeDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public int modifiers;
    public int modifiersSourceStart;
    public char[] name;
    public TypeReference superclass;
    public TypeReference[] superInterfaces;
    public FieldDeclaration[] fields;
    public AbstractMethodDeclaration[] methods;
    public MemberTypeDeclaration[] memberTypes;
    public SourceTypeBinding binding;
    public ClassScope scope;
    public MethodScope initializerScope;
    public MethodScope staticInitializerScope;
    public boolean ignoreFurtherInvestigation = false;
    public int maxFieldCount;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    protected boolean hasBeenGenerated = false;
    public CompilationResult compilationResult;
    private MethodDeclaration[] missingAbstractMethods;

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int abortLevel) {
        if (this.scope == null) {
            throw new AbortCompilation();
        }
        CompilationResult compilationResult = this.scope.referenceCompilationUnit().compilationResult;
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(compilationResult);
            }
            case 4: {
                throw new AbortCompilationUnit(compilationResult);
            }
            case 16: {
                throw new AbortMethod(compilationResult);
            }
        }
        throw new AbortType(compilationResult);
    }

    public final void addClinit() {
        if (this.needClassInitMethod()) {
            AbstractMethodDeclaration[] methods = this.methods;
            if (this.methods == null) {
                boolean length = false;
                methods = new AbstractMethodDeclaration[1];
            } else {
                int length = methods.length;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods;
                methods = new AbstractMethodDeclaration[length + 1];
                System.arraycopy(abstractMethodDeclarationArray, 0, methods, 1, length);
            }
            Clinit clinit = new Clinit(this.compilationResult);
            methods[0] = clinit;
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            this.methods = methods;
        }
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            this.bits |= Integer.MIN_VALUE;
            LocalTypeBinding localType = (LocalTypeBinding)this.binding;
            localType.setConstantPoolName(currentScope.compilationUnitScope().computeConstantPoolName(localType));
            this.manageEnclosingInstanceAccessIfNecessary(currentScope);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public void analyseCode(ClassScope enclosingClassScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.updateMaxFieldCount();
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(ClassScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.bits |= Integer.MIN_VALUE;
            LocalTypeBinding localType = (LocalTypeBinding)this.binding;
            localType.setConstantPoolName(currentScope.compilationUnitScope().computeConstantPoolName(localType));
            this.manageEnclosingInstanceAccessIfNecessary(currentScope);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(CompilationUnitScope unitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean checkConstructors(Parser parser) {
        boolean hasConstructor = false;
        if (this.methods != null) {
            int i = this.methods.length;
            while (--i >= 0) {
                AbstractMethodDeclaration am = this.methods[i];
                if (!am.isConstructor()) continue;
                if (!CharOperation.equals(am.selector, this.name)) {
                    ConstructorDeclaration c = (ConstructorDeclaration)am;
                    if (c.constructorCall != null && !c.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration m = new MethodDeclaration(this.compilationResult);
                    m.sourceStart = c.sourceStart;
                    m.sourceEnd = c.sourceEnd;
                    m.bodyStart = c.bodyStart;
                    m.bodyEnd = c.bodyEnd;
                    m.declarationSourceEnd = c.declarationSourceEnd;
                    m.declarationSourceStart = c.declarationSourceStart;
                    m.selector = c.selector;
                    m.statements = c.statements;
                    m.modifiers = c.modifiers;
                    m.arguments = c.arguments;
                    m.thrownExceptions = c.thrownExceptions;
                    m.explicitDeclarations = c.explicitDeclarations;
                    m.returnType = null;
                    this.methods[i] = m;
                    continue;
                }
                if (this.isInterface()) {
                    parser.problemReporter().interfaceCannotHaveConstructors((ConstructorDeclaration)am);
                }
                hasConstructor = true;
            }
        }
        return hasConstructor;
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public ConstructorDeclaration createsInternalConstructor(boolean needExplicitConstructorCall, boolean needToInsert) {
        ConstructorDeclaration constructor = new ConstructorDeclaration(this.compilationResult);
        constructor.isDefaultConstructor = true;
        constructor.selector = this.name;
        if (this.modifiers != 0) {
            constructor.modifiers = this instanceof MemberTypeDeclaration && (this.modifiers & 2) != 0 ? 0 : this.modifiers & 7;
        }
        constructor.declarationSourceStart = constructor.sourceStart = this.sourceStart;
        constructor.sourceEnd = constructor.bodyEnd = this.sourceEnd;
        constructor.declarationSourceEnd = constructor.bodyEnd;
        if (needExplicitConstructorCall) {
            constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructor.constructorCall.sourceStart = this.sourceStart;
            constructor.constructorCall.sourceEnd = this.sourceEnd;
        }
        if (needToInsert) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructor};
            } else {
                AbstractMethodDeclaration[] newMethods = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, newMethods, 1, this.methods.length);
                newMethods[0] = constructor;
                this.methods = newMethods;
            }
        }
        return constructor;
    }

    public MethodDeclaration addMissingAbstractMethodFor(MethodBinding methodBinding) {
        TypeBinding[] argumentTypes = methodBinding.parameters;
        int argumentsLength = argumentTypes.length;
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.compilationResult);
        methodDeclaration.selector = methodBinding.selector;
        methodDeclaration.sourceStart = this.sourceStart;
        methodDeclaration.sourceEnd = this.sourceEnd;
        methodDeclaration.modifiers = methodBinding.getAccessFlags() & 0xFFFFFBFF;
        if (argumentsLength > 0) {
            String baseName = "arg";
            methodDeclaration.arguments = new Argument[argumentsLength];
            Argument[] arguments = methodDeclaration.arguments;
            int i = argumentsLength;
            while (--i >= 0) {
                arguments[i] = new Argument((String.valueOf(baseName) + i).toCharArray(), 0L, null, 0);
            }
        }
        if (this.missingAbstractMethods == null) {
            this.missingAbstractMethods = new MethodDeclaration[]{methodDeclaration};
        } else {
            MethodDeclaration[] newMethods = new MethodDeclaration[this.missingAbstractMethods.length + 1];
            System.arraycopy(this.missingAbstractMethods, 0, newMethods, 1, this.missingAbstractMethods.length);
            newMethods[0] = methodDeclaration;
            this.missingAbstractMethods = newMethods;
        }
        methodDeclaration.binding = new MethodBinding(methodDeclaration.modifiers, methodBinding.selector, methodBinding.returnType, argumentsLength == 0 ? TypeConstants.NoParameters : argumentTypes, methodBinding.thrownExceptions, this.binding);
        methodDeclaration.scope = new MethodScope(this.scope, methodDeclaration, true);
        methodDeclaration.bindArguments();
        return methodDeclaration;
    }

    public FieldDeclaration declarationOf(FieldBinding fieldBinding) {
        if (fieldBinding != null) {
            int i = 0;
            int max = this.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = this.fields[i];
                if (fieldDecl.binding == fieldBinding) {
                    return fieldDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOf(MemberTypeBinding memberTypeBinding) {
        if (memberTypeBinding != null) {
            int i = 0;
            int max = this.memberTypes.length;
            while (i < max) {
                MemberTypeDeclaration memberTypeDecl = this.memberTypes[i];
                if (memberTypeDecl.binding == memberTypeBinding) {
                    return memberTypeDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null) {
            int i = 0;
            int max = this.methods.length;
            while (i < max) {
                AbstractMethodDeclaration methodDecl = this.methods[i];
                if (methodDecl.binding == methodBinding) {
                    return methodDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOfType(char[][] typeName) {
        int typeNameLength = typeName.length;
        if (typeNameLength < 1 || !CharOperation.equals(typeName[0], this.name)) {
            return null;
        }
        if (typeNameLength == 1) {
            return this;
        }
        char[][] subTypeName = new char[typeNameLength - 1][];
        System.arraycopy(typeName, 1, subTypeName, 0, typeNameLength - 1);
        int i = 0;
        while (i < this.memberTypes.length) {
            TypeDeclaration typeDecl = this.memberTypes[i].declarationOfType(subTypeName);
            if (typeDecl != null) {
                return typeDecl;
            }
            ++i;
        }
        return null;
    }

    public void generateCode(ClassFile enclosingClassFile) {
        if (this.hasBeenGenerated) {
            return;
        }
        this.hasBeenGenerated = true;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            int max;
            int i;
            ClassFile classFile = new ClassFile(this.binding, enclosingClassFile, false);
            classFile.addFieldInfos();
            if (this.binding.isMemberType()) {
                classFile.recordEnclosingTypeAttributes(this.binding);
            }
            if (this.binding.isLocalType()) {
                enclosingClassFile.recordNestedLocalAttribute(this.binding);
                classFile.recordNestedLocalAttribute(this.binding);
            }
            if (this.memberTypes != null) {
                i = 0;
                max = this.memberTypes.length;
                while (i < max) {
                    classFile.recordNestedMemberAttribute(this.memberTypes[i].binding);
                    this.memberTypes[i].generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.setForMethodInfos();
            if (this.methods != null) {
                i = 0;
                max = this.methods.length;
                while (i < max) {
                    this.methods[i].generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.generateMissingAbstractMethods(this.missingAbstractMethods, this.scope.referenceCompilationUnit().compilationResult);
            classFile.addSpecialMethods();
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult);
            }
            classFile.addAttributes();
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile);
        }
        catch (AbortType abortType) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.hasBeenGenerated) {
            return;
        }
        int pc = codeStream.position;
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(codeStream.classFile);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCode(ClassScope classScope, ClassFile enclosingClassFile) {
        if (this.hasBeenGenerated) {
            return;
        }
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(enclosingClassFile);
    }

    public void generateCode(CompilationUnitScope unitScope) {
        this.generateCode((ClassFile)null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public void internalAnalyseCode(FlowContext flowContext, FlowInfo flowInfo) {
        int count;
        int i;
        if (this.binding.isPrivate() && !this.binding.isPrivateUsed() && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
            this.scope.problemReporter().unusedPrivateType(this);
        }
        ReferenceBinding[] defaultHandledExceptions = new ReferenceBinding[]{this.scope.getJavaLangThrowable()};
        InitializationFlowContext initializerContext = new InitializationFlowContext(null, this, this.initializerScope);
        InitializationFlowContext staticInitializerContext = new InitializationFlowContext(null, this, this.staticInitializerScope);
        FlowInfo nonStaticFieldInfo = flowInfo.copy().unconditionalInits().discardFieldInitializations();
        FlowInfo staticFieldInfo = flowInfo.copy().unconditionalInits().discardFieldInitializations();
        if (this.fields != null) {
            i = 0;
            count = this.fields.length;
            while (i < count) {
                FieldDeclaration field = this.fields[i];
                if (field.isStatic()) {
                    staticInitializerContext.handledExceptions = defaultHandledExceptions;
                    if ((staticFieldInfo = field.analyseCode(this.staticInitializerScope, (FlowContext)staticInitializerContext, staticFieldInfo)) == FlowInfo.DEAD_END) {
                        this.staticInitializerScope.problemReporter().initializerMustCompleteNormally(field);
                        staticFieldInfo = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                } else {
                    initializerContext.handledExceptions = defaultHandledExceptions;
                    if ((nonStaticFieldInfo = field.analyseCode(this.initializerScope, (FlowContext)initializerContext, nonStaticFieldInfo)) == FlowInfo.DEAD_END) {
                        this.initializerScope.problemReporter().initializerMustCompleteNormally(field);
                        nonStaticFieldInfo = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                }
                ++i;
            }
        }
        if (this.memberTypes != null) {
            i = 0;
            count = this.memberTypes.length;
            while (i < count) {
                if (flowContext != null) {
                    this.memberTypes[i].analyseCode(this.scope, flowContext, ((FlowInfo)nonStaticFieldInfo).copy());
                } else {
                    this.memberTypes[i].analyseCode(this.scope);
                }
                ++i;
            }
        }
        if (this.methods != null) {
            UnconditionalFlowInfo outerInfo = flowInfo.copy().unconditionalInits().discardFieldInitializations();
            FlowInfo constructorInfo = ((FlowInfo)nonStaticFieldInfo).unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(outerInfo);
            int i2 = 0;
            int count2 = this.methods.length;
            while (i2 < count2) {
                AbstractMethodDeclaration method = this.methods[i2];
                if (!method.ignoreFurtherInvestigation) {
                    if (method.isInitializationMethod()) {
                        if (method.isStatic()) {
                            method.analyseCode(this.scope, staticInitializerContext, staticFieldInfo.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(outerInfo));
                        } else {
                            method.analyseCode(this.scope, initializerContext, constructorInfo.copy());
                        }
                    } else {
                        method.analyseCode(this.scope, null, flowInfo.copy());
                    }
                }
                ++i2;
            }
        }
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        ReferenceBinding superclass;
        NestedTypeBinding nestedType = (NestedTypeBinding)this.binding;
        MethodScope methodScope = currentScope.methodScope();
        if (!methodScope.isStatic && !methodScope.isConstructorCall) {
            nestedType.addSyntheticArgumentAndField(this.binding.enclosingType());
        }
        if (!(!this.binding.isAnonymousType() || (superclass = this.binding.superclass).enclosingType() == null || superclass.isStatic() || this.binding.superclass.isLocalType() && ((NestedTypeBinding)this.binding.superclass).getSyntheticField(superclass.enclosingType(), true) == null)) {
            nestedType.addSyntheticArgument(superclass.enclosingType());
        }
    }

    public void manageEnclosingInstanceAccessIfNecessary(ClassScope currentScope) {
        NestedTypeBinding nestedType = (NestedTypeBinding)this.binding;
        nestedType.addSyntheticArgumentAndField(this.binding.enclosingType());
    }

    public final boolean needClassInitMethod() {
        if ((this.bits & 1) != 0) {
            return true;
        }
        if (this.fields == null) {
            return false;
        }
        if (this.isInterface()) {
            return true;
        }
        int i = this.fields.length;
        while (--i >= 0) {
            FieldDeclaration field = this.fields[i];
            if ((field.modifiers & 8) == 0) continue;
            return true;
        }
        return false;
    }

    public void parseMethod(Parser parser, CompilationUnitDeclaration unit) {
        int i;
        int length;
        if (unit.ignoreMethodBodies) {
            return;
        }
        if (this.memberTypes != null) {
            length = this.memberTypes.length;
            i = 0;
            while (i < length) {
                this.memberTypes[i].parseMethod(parser, unit);
                ++i;
            }
        }
        if (this.methods != null) {
            length = this.methods.length;
            i = 0;
            while (i < length) {
                this.methods[i].parseStatements(parser, unit);
                ++i;
            }
        }
        if (this.fields != null) {
            length = this.fields.length;
            i = 0;
            while (i < length) {
                if (this.fields[i] instanceof Initializer) {
                    ((Initializer)this.fields[i]).parseStatements(parser, this, unit);
                }
                ++i;
            }
        }
    }

    public void resolve() {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        try {
            int methodsLength;
            int count;
            int i;
            block13: {
                if (this.binding.superclass != null && this.isTypeUseDeprecated(this.binding.superclass, this.scope)) {
                    this.scope.problemReporter().deprecatedType(this.binding.superclass, this.superclass);
                }
                if (this.superInterfaces != null) {
                    int i2 = this.superInterfaces.length;
                    while (--i2 >= 0) {
                        if (this.superInterfaces[i2].resolvedType == null || !this.isTypeUseDeprecated(this.superInterfaces[i2].resolvedType, this.scope)) continue;
                        this.scope.problemReporter().deprecatedType(this.superInterfaces[i2].resolvedType, this.superInterfaces[i2]);
                    }
                }
                this.maxFieldCount = 0;
                int lastFieldID = -1;
                if (this.fields == null) break block13;
                i = 0;
                count = this.fields.length;
                while (i < count) {
                    block16: {
                        FieldDeclaration field;
                        block17: {
                            block14: {
                                block15: {
                                    field = this.fields[i];
                                    if (!field.isField()) break block14;
                                    if (field.binding != null) break block15;
                                    if (field.initialization != null) {
                                        field.initialization.resolve(field.isStatic() ? this.staticInitializerScope : this.initializerScope);
                                    }
                                    this.ignoreFurtherInvestigation = true;
                                    break block16;
                                }
                                ++this.maxFieldCount;
                                lastFieldID = field.binding.id;
                                break block17;
                            }
                            ((Initializer)field).lastFieldID = lastFieldID + 1;
                        }
                        field.resolve(field.isStatic() ? this.staticInitializerScope : this.initializerScope);
                    }
                    ++i;
                }
            }
            if (this.memberTypes != null) {
                i = 0;
                count = this.memberTypes.length;
                while (i < count) {
                    this.memberTypes[i].resolve(this.scope);
                    ++i;
                }
            }
            int missingAbstractMethodslength = this.missingAbstractMethods == null ? 0 : this.missingAbstractMethods.length;
            int n = methodsLength = this.methods == null ? 0 : this.methods.length;
            if (methodsLength + missingAbstractMethodslength > 65535) {
                this.scope.problemReporter().tooManyMethods(this);
            }
            if (this.methods != null) {
                int i3 = 0;
                int count2 = this.methods.length;
                while (i3 < count2) {
                    this.methods[i3].resolve(this.scope);
                    ++i3;
                }
            }
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void resolve(BlockScope blockScope) {
        blockScope.addLocalType(this);
        if (this.binding != null) {
            blockScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
            this.resolve();
            this.updateMaxFieldCount();
        }
    }

    public void resolve(ClassScope upperScope) {
        if (this.binding != null && this.binding instanceof LocalTypeBinding) {
            upperScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void resolve(CompilationUnitScope upperScope) {
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public String toString(int tab) {
        return String.valueOf(AstNode.tabString(tab)) + this.toStringHeader() + this.toStringBody(tab);
    }

    public String toStringBody(int tab) {
        int i;
        String s = " {";
        if (this.memberTypes != null) {
            i = 0;
            while (i < this.memberTypes.length) {
                if (this.memberTypes[i] != null) {
                    s = String.valueOf(s) + "\n" + this.memberTypes[i].toString(tab + 1);
                }
                ++i;
            }
        }
        if (this.fields != null) {
            int fieldI = 0;
            while (fieldI < this.fields.length) {
                if (this.fields[fieldI] != null) {
                    s = String.valueOf(s) + "\n" + this.fields[fieldI].toString(tab + 1);
                    if (this.fields[fieldI].isField()) {
                        s = String.valueOf(s) + ";";
                    }
                }
                ++fieldI;
            }
        }
        if (this.methods != null) {
            i = 0;
            while (i < this.methods.length) {
                if (this.methods[i] != null) {
                    s = String.valueOf(s) + "\n" + this.methods[i].toString(tab + 1);
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "\n" + AstNode.tabString(tab) + "}";
        return s;
    }

    public String toStringHeader() {
        String s = "";
        if (this.modifiers != 0) {
            s = String.valueOf(s) + AstNode.modifiersString(this.modifiers);
        }
        s = String.valueOf(s) + (this.isInterface() ? "interface " : "class ") + new String(this.name);
        if (this.superclass != null) {
            s = String.valueOf(s) + " extends " + this.superclass.toString(0);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            s = String.valueOf(s) + (this.isInterface() ? " extends " : " implements ");
            int i = 0;
            while (i < this.superInterfaces.length) {
                s = String.valueOf(s) + this.superInterfaces[i].toString(0);
                if (i != this.superInterfaces.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, CompilationUnitScope unitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, unitScope)) {
                int i;
                if (this.superclass != null) {
                    this.superclass.traverse(visitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    int superInterfaceLength = this.superInterfaces.length;
                    i = 0;
                    while (i < superInterfaceLength) {
                        this.superInterfaces[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.memberTypes != null) {
                    int memberTypesLength = this.memberTypes.length;
                    i = 0;
                    while (i < memberTypesLength) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    int fieldsLength = this.fields.length;
                    i = 0;
                    while (i < fieldsLength) {
                        FieldDeclaration field = this.fields[i];
                        if (field.isStatic()) {
                            field.traverse(visitor, this.staticInitializerScope);
                        } else {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    int methodsLength = this.methods.length;
                    i = 0;
                    while (i < methodsLength) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, unitScope);
        }
        catch (AbortType abortType) {}
    }

    void updateMaxFieldCount() {
        if (this.binding == null) {
            return;
        }
        TypeDeclaration outerMostType = this.scope.outerMostClassScope().referenceType();
        if (this.maxFieldCount > outerMostType.maxFieldCount) {
            outerMostType.maxFieldCount = this.maxFieldCount;
        } else {
            this.maxFieldCount = outerMostType.maxFieldCount;
        }
    }
}

