/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TryStatement
extends Statement {
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    public boolean subRoutineCannotReturn = true;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean tryBlockExit;
    boolean[] catchExits;
    public int[] preserveExceptionHandler;
    Label subRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    public static final char[] SecretReturnName = " returnAddress".toCharArray();
    public static final char[] SecretAnyHandlerName = " anyExceptionHandler".toCharArray();
    public static final char[] SecretLocalDeclarationName = " returnValue".toCharArray();
    int preTryInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo tryInfo;
        UnconditionalFlowInfo subInfo;
        FinallyFlowContext finallyContext;
        InsideSubRoutineFlowContext insideSubContext;
        this.preTryInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if (this.subRoutineStartLabel == null) {
            insideSubContext = null;
            finallyContext = null;
            subInfo = null;
        } else {
            insideSubContext = new InsideSubRoutineFlowContext(flowContext, this);
            finallyContext = new FinallyFlowContext(flowContext, this.finallyBlock);
            subInfo = this.finallyBlock.analyseCode(currentScope, finallyContext, flowInfo.copy()).unconditionalInits();
            if (subInfo != FlowInfo.DEAD_END) {
                this.subRoutineCannotReturn = false;
            }
            this.subRoutineInits = subInfo;
        }
        ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(insideSubContext == null ? flowContext : insideSubContext, this.tryBlock, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
        if (this.tryBlock.statements == null) {
            tryInfo = flowInfo;
            this.tryBlockExit = false;
        } else {
            tryInfo = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
            this.tryBlockExit = !tryInfo.isReachable();
        }
        handlingContext.complainIfUnusedExceptionHandlers(this.catchBlocks, this.scope, this);
        if (this.catchArguments != null) {
            int catchCount = this.catchBlocks.length;
            this.catchExits = new boolean[catchCount];
            int i = 0;
            while (i < catchCount) {
                FlowInfo catchInfo = flowInfo.copy().unconditionalInits().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i]).unconditionalInits()).addPotentialInitializationsFrom(tryInfo.unconditionalInits()).addPotentialInitializationsFrom(handlingContext.initsOnReturn);
                catchInfo.markAsDefinitelyAssigned(this.catchArguments[i].binding);
                if (this.tryBlock.statements == null) {
                    catchInfo.setReachMode(1);
                }
                catchInfo = this.catchBlocks[i].analyseCode(currentScope, insideSubContext == null ? flowContext : insideSubContext, catchInfo);
                this.catchExits[i] = !catchInfo.isReachable();
                tryInfo = tryInfo.mergedWith(catchInfo.unconditionalInits());
                ++i;
            }
        }
        if (this.subRoutineStartLabel == null) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(tryInfo);
            return tryInfo;
        }
        finallyContext.complainOnRedundantFinalAssignments(tryInfo.isReachable() ? tryInfo.addPotentialInitializationsFrom(insideSubContext.initsOnReturn) : insideSubContext.initsOnReturn, currentScope);
        if (subInfo == FlowInfo.DEAD_END) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(subInfo);
            return subInfo;
        }
        FlowInfo mergedInfo = tryInfo.addInitializationsFrom(subInfo);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public boolean cannotReturn() {
        return this.subRoutineCannotReturn;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean nonReturningSubRoutine;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.tryBlock.isEmptyBlock()) {
            if (this.subRoutineStartLabel != null) {
                this.finallyBlock.generateCode(this.scope, codeStream);
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            return;
        }
        int pc = codeStream.position;
        Label endLabel = new Label(codeStream);
        boolean requiresNaturalJsr = false;
        int maxCatches = this.catchArguments == null ? 0 : this.catchArguments.length;
        ExceptionLabel[] exceptionLabels = new ExceptionLabel[maxCatches];
        int i = 0;
        while (i < maxCatches) {
            boolean preserveCurrentHandler;
            boolean bl = preserveCurrentHandler = (this.preserveExceptionHandler[i / 32] & 1 << i % 32) != 0;
            if (preserveCurrentHandler) {
                exceptionLabels[i] = new ExceptionLabel(codeStream, (ReferenceBinding)this.catchArguments[i].binding.type);
            }
            ++i;
        }
        ExceptionLabel anyExceptionLabel = null;
        if (this.subRoutineStartLabel != null) {
            this.subRoutineStartLabel.codeStream = codeStream;
            anyExceptionLabel = new ExceptionLabel(codeStream, null);
        }
        this.tryBlock.generateCode(this.scope, codeStream);
        boolean tryBlockHasSomeCode = codeStream.position != pc;
        boolean bl = nonReturningSubRoutine = this.subRoutineStartLabel != null && this.subRoutineCannotReturn;
        if (!this.tryBlockExit && tryBlockHasSomeCode) {
            int position = codeStream.position;
            if (nonReturningSubRoutine) {
                codeStream.goto_(this.subRoutineStartLabel);
            } else {
                requiresNaturalJsr = true;
                codeStream.goto_(endLabel);
            }
            codeStream.updateLastRecordedEndPC(position);
        }
        if (tryBlockHasSomeCode) {
            boolean preserveCurrentHandler;
            int i2 = 0;
            while (i2 < maxCatches) {
                boolean bl2 = preserveCurrentHandler = (this.preserveExceptionHandler[i2 / 32] & 1 << i2 % 32) != 0;
                if (preserveCurrentHandler) {
                    exceptionLabels[i2].placeEnd();
                }
                ++i2;
            }
            if (this.catchArguments == null) {
                if (anyExceptionLabel != null) {
                    anyExceptionLabel.placeEnd();
                }
            } else {
                i2 = 0;
                while (i2 < maxCatches) {
                    boolean bl3 = preserveCurrentHandler = (this.preserveExceptionHandler[i2 / 32] & 1 << i2 % 32) != 0;
                    if (preserveCurrentHandler) {
                        if (this.preTryInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                        }
                        exceptionLabels[i2].place();
                        codeStream.incrStackSize(1);
                        int varPC = codeStream.position;
                        LocalVariableBinding catchVar = this.catchArguments[i2].binding;
                        if (catchVar.resolvedPosition != -1) {
                            codeStream.store(catchVar, false);
                            catchVar.recordInitializationStartPC(codeStream.position);
                            codeStream.addVisibleLocalVariable(catchVar);
                        } else {
                            codeStream.pop();
                        }
                        codeStream.recordPositionsFrom(varPC, this.catchArguments[i2].sourceStart);
                        this.catchBlocks[i2].generateCode(this.scope, codeStream);
                    }
                    if (i2 == maxCatches - 1) {
                        if (anyExceptionLabel != null) {
                            anyExceptionLabel.placeEnd();
                        }
                        if (this.subRoutineStartLabel != null && !this.catchExits[i2] && preserveCurrentHandler) {
                            requiresNaturalJsr = true;
                            codeStream.goto_(endLabel);
                        }
                    } else if (!this.catchExits[i2] && preserveCurrentHandler) {
                        if (nonReturningSubRoutine) {
                            codeStream.goto_(this.subRoutineStartLabel);
                        } else {
                            requiresNaturalJsr = true;
                            codeStream.goto_(endLabel);
                        }
                    }
                    ++i2;
                }
            }
            int finallySequenceStartPC = codeStream.position;
            if (this.subRoutineStartLabel != null) {
                anyExceptionLabel.place();
                if (this.preTryInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                }
                codeStream.incrStackSize(1);
                if (nonReturningSubRoutine) {
                    codeStream.pop();
                } else {
                    codeStream.store(this.anyExceptionVariable, false);
                    codeStream.jsr(this.subRoutineStartLabel);
                    codeStream.load(this.anyExceptionVariable);
                    codeStream.athrow();
                }
            }
            endLabel.place();
            if (this.subRoutineStartLabel != null) {
                if (nonReturningSubRoutine) {
                    requiresNaturalJsr = false;
                }
                Label veryEndLabel = new Label(codeStream);
                if (requiresNaturalJsr) {
                    codeStream.jsr(this.subRoutineStartLabel);
                    codeStream.goto_(veryEndLabel);
                }
                this.subRoutineStartLabel.place();
                if (!nonReturningSubRoutine) {
                    codeStream.incrStackSize(1);
                    codeStream.store(this.returnAddressVariable, false);
                }
                codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                this.finallyBlock.generateCode(this.scope, codeStream);
                if (!nonReturningSubRoutine) {
                    int position = codeStream.position;
                    codeStream.ret(this.returnAddressVariable.resolvedPosition);
                    codeStream.updateLastRecordedEndPC(position);
                }
                if (requiresNaturalJsr) {
                    veryEndLabel.place();
                }
            }
        } else if (this.subRoutineStartLabel != null) {
            this.finallyBlock.generateCode(this.scope, codeStream);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resetStateForCodeGeneration() {
        if (this.subRoutineStartLabel != null) {
            this.subRoutineStartLabel.resetStateForCodeGeneration();
        }
    }

    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope);
        BlockScope tryScope = new BlockScope(this.scope);
        BlockScope finallyScope = null;
        if (this.finallyBlock != null && this.finallyBlock.statements != null) {
            MethodBinding methodBinding;
            finallyScope = new BlockScope(this.scope, false);
            MethodScope methodScope = this.scope.methodScope();
            this.returnAddressVariable = new LocalVariableBinding(SecretReturnName, (TypeBinding)upperScope.getJavaLangObject(), 0, false);
            finallyScope.addLocalVariable(this.returnAddressVariable);
            this.returnAddressVariable.constant = AstNode.NotAConstant;
            this.subRoutineStartLabel = new Label();
            this.anyExceptionVariable = new LocalVariableBinding(SecretAnyHandlerName, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
            finallyScope.addLocalVariable(this.anyExceptionVariable);
            this.anyExceptionVariable.constant = AstNode.NotAConstant;
            if (!methodScope.isInsideInitializer() && (methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                TypeBinding methodReturnType = methodBinding.returnType;
                if (methodReturnType.id != 6) {
                    this.secretReturnValue = new LocalVariableBinding(SecretLocalDeclarationName, methodReturnType, 0, false);
                    finallyScope.addLocalVariable(this.secretReturnValue);
                    this.secretReturnValue.constant = AstNode.NotAConstant;
                }
            }
            this.finallyBlock.resolveUsing(finallyScope);
            finallyScope.shiftScopes = new BlockScope[this.catchArguments == null ? 1 : this.catchArguments.length + 1];
            finallyScope.shiftScopes[0] = tryScope;
        }
        this.tryBlock.resolveUsing(tryScope);
        if (this.catchBlocks != null) {
            int length = this.catchArguments.length;
            TypeBinding[] argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                BlockScope catchScope = new BlockScope(this.scope);
                if (finallyScope != null) {
                    finallyScope.shiftScopes[i + 1] = catchScope;
                }
                if ((argumentTypes[i] = this.catchArguments[i].resolveForCatch(catchScope)) == null) {
                    return;
                }
                this.catchBlocks[i].resolveUsing(catchScope);
                ++i;
            }
            this.caughtExceptionTypes = new ReferenceBinding[length];
            i = 0;
            while (i < length) {
                this.caughtExceptionTypes[i] = (ReferenceBinding)argumentTypes[i];
                int j = 0;
                while (j < i) {
                    if (this.caughtExceptionTypes[i].isCompatibleWith(argumentTypes[j])) {
                        this.scope.problemReporter().wrongSequenceOfExceptionTypesError(this, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
        if (finallyScope != null) {
            this.scope.addSubscope(finallyScope);
        }
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        s = String.valueOf(s) + "try ";
        s = this.tryBlock == Block.None ? String.valueOf(s) + "{}" : String.valueOf(s) + "\n" + this.tryBlock.toString(tab + 1);
        if (this.catchBlocks != null) {
            int i = 0;
            while (i < this.catchBlocks.length) {
                s = String.valueOf(s) + "\n" + AstNode.tabString(tab) + "catch (" + this.catchArguments[i].toString(0) + ") " + this.catchBlocks[i].toString(tab + 1);
                ++i;
            }
        }
        if (this.finallyBlock != null) {
            s = this.finallyBlock == Block.None ? String.valueOf(s) + "\n" + AstNode.tabString(tab) + "finally {}" : String.valueOf(s) + "\n" + AstNode.tabString(tab) + "finally\n" + this.finallyBlock.toString(tab + 1);
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.tryBlock.traverse(visitor, this.scope);
            if (this.catchArguments != null) {
                int i = 0;
                int max = this.catchBlocks.length;
                while (i < max) {
                    this.catchArguments[i].traverse(visitor, this.scope);
                    this.catchBlocks[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

