/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;

class VariableBinding
implements IVariableBinding {
    private org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding;
    private BindingResolver resolver;
    private String name;
    private ITypeBinding declaringClass;
    private ITypeBinding type;

    VariableBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.VariableBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public boolean isField() {
        return this.binding instanceof FieldBinding;
    }

    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.name);
        }
        return this.name;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.isField()) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if (this.declaringClass == null) {
                this.declaringClass = this.resolver.getTypeBinding(fieldBinding.declaringClass);
            }
            return this.declaringClass;
        }
        return null;
    }

    public ITypeBinding getType() {
        if (this.type == null) {
            this.type = this.resolver.getTypeBinding(this.binding.type);
        }
        return this.type;
    }

    public int getKind() {
        return 3;
    }

    public int getModifiers() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).getAccessFlags();
        }
        if (this.binding.isFinal()) {
            return 16;
        }
        return 0;
    }

    public boolean isDeprecated() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isDeprecated();
        }
        return false;
    }

    public boolean isSynthetic() {
        if (this.isField()) {
            return ((FieldBinding)this.binding).isSynthetic();
        }
        return false;
    }

    public String getKey() {
        if (this.isField()) {
            StringBuffer buffer = new StringBuffer();
            if (this.getDeclaringClass() != null) {
                buffer.append(this.getDeclaringClass().getKey());
            }
            buffer.append(this.getName());
            return buffer.toString();
        }
        return null;
    }

    public int getVariableId() {
        return this.binding.id;
    }

    public String toString() {
        return this.binding.toString();
    }
}

